/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.cyclops.commoncapabilities.CommonCapabilities;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemMatch;
import org.cyclops.commoncapabilities.ingredient.NBTBaseComparator;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.config.IChangedCallback;
import org.cyclops.cyclopscore.config.extendedconfig.DummyConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.nbt.path.NbtParseException;
import org.cyclops.cyclopscore.nbt.path.NbtPath;
import org.cyclops.cyclopscore.nbt.path.navigate.INbtPathNavigation;
import org.cyclops.cyclopscore.nbt.path.navigate.NbtPathNavigationList;
import org.cyclops.cyclopscore.tracking.Analytics;
import org.cyclops.cyclopscore.tracking.IModVersion;
import org.cyclops.cyclopscore.tracking.Versions;

public class GeneralConfig
extends DummyConfig {
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="Config version for CommonCapabilities.\nDO NOT EDIT MANUALLY!", showInGui=false)
    public static String version = "2.4.4";
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="Set 'true' to enable development debug mode. This will result in a lower performance!", requiresMcRestart=true)
    public static boolean debug = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If the recipe loader should crash when finding invalid recipes.", requiresMcRestart=true)
    public static boolean crashOnInvalidRecipe = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If mod compatibility loader should crash hard if errors occur in that process.", requiresMcRestart=true)
    public static boolean crashOnModCompatCrash = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If an anonymous mod startup analytics request may be sent to our analytics service.")
    public static boolean analytics = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If the version checker should be enabled.")
    public static boolean versionChecker = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The NBT Paths that should be filtered away when checking equality.", changedCallback=IgnoreNbtPathsForEqualityChangedCallback.class)
    public static String[] ignoreNbtPathsForEqualityFilters = new String[]{"$.ForgeCaps[\"astralsorcery:cap_item_amulet_holder\"]", "$.binding"};
    public static ConfigurableType TYPE = ConfigurableType.DUMMY;

    public GeneralConfig() {
        super((ModBase)CommonCapabilities._instance, true, "general", null, GeneralConfig.class);
    }

    public void onRegistered() {
        this.getMod().putGenericReference(ModBase.REFKEY_CRASH_ON_INVALID_RECIPE, (Object)crashOnInvalidRecipe);
        this.getMod().putGenericReference(ModBase.REFKEY_DEBUGCONFIG, (Object)debug);
        this.getMod().putGenericReference(ModBase.REFKEY_CRASH_ON_MODCOMPAT_CRASH, (Object)crashOnModCompatCrash);
        if (analytics) {
            Analytics.registerMod((ModBase)this.getMod(), (String)"UA-65307010-7");
        }
        if (versionChecker) {
            Versions.registerMod((ModBase)this.getMod(), (IModVersion)CommonCapabilities._instance, (String)"https://raw.githubusercontent.com/CyclopsMC/Versions/master/1.12/CommonCapabilities.txt");
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public static class IgnoreNbtPathsForEqualityChangedCallback
    implements IChangedCallback {
        public void onChanged(Object value) {
            ArrayList navigations = Lists.newArrayList();
            for (String path : (String[])value) {
                try {
                    navigations.add(NbtPath.parse((String)path).asNavigation());
                }
                catch (NbtParseException e) {
                    CommonCapabilities.clog(Level.ERROR, String.format("Failed to parse NBT path to filter: %s", path));
                }
            }
            ItemMatch.NBT_COMPARATOR = NBTBaseComparator.INSTANCE = new NBTBaseComparator((INbtPathNavigation)new NbtPathNavigationList((List)navigations));
        }

        public void onRegisteredPostInit(Object value) {
        }
    }
}

