/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.lib.util;

import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconRitual;
import com.shinoow.abyssalcraft.api.ritual.RitualRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class RitualUtil {
    private static Map<IBlockState, Integer> ritualBlocks = new HashMap<IBlockState, Integer>();
    private static Map<IBlockState, Integer> altarMeta = new HashMap<IBlockState, Integer>();

    public static void addBlocks() {
        ritualBlocks.put(Blocks.field_150347_e.func_176223_P(), 0);
        ritualBlocks.put(ACBlocks.cobblestone.func_176203_a(0), 0);
        ritualBlocks.put(ACBlocks.cobblestone.func_176203_a(1), 1);
        ritualBlocks.put(ACBlocks.cobblestone.func_176203_a(4), 1);
        ritualBlocks.put(ACBlocks.cobblestone.func_176203_a(2), 2);
        ritualBlocks.put(ACBlocks.cobblestone.func_176203_a(3), 2);
        ritualBlocks.put(ACBlocks.ethaxium_brick.func_176223_P(), 3);
        ritualBlocks.put(ACBlocks.dark_ethaxium_brick.func_176223_P(), 3);
        altarMeta.put(Blocks.field_150347_e.func_176223_P(), 0);
        altarMeta.put(ACBlocks.cobblestone.func_176203_a(0), 1);
        altarMeta.put(ACBlocks.cobblestone.func_176203_a(1), 2);
        altarMeta.put(ACBlocks.cobblestone.func_176203_a(4), 3);
        altarMeta.put(ACBlocks.cobblestone.func_176203_a(2), 4);
        altarMeta.put(ACBlocks.cobblestone.func_176203_a(3), 5);
        altarMeta.put(ACBlocks.ethaxium_brick.func_176223_P(), 6);
        altarMeta.put(ACBlocks.dark_ethaxium_brick.func_176223_P(), 7);
    }

    public static boolean tryAltar(World world, BlockPos pos, int bookType) {
        IBlockState ritualBlock = world.func_180495_p(pos);
        int x = 0;
        int y = 0;
        int z = 0;
        if (!(ritualBlock == null || !ritualBlocks.containsKey(ritualBlock) || bookType < ritualBlocks.get(ritualBlock) || world.func_180495_p(pos.func_177982_a(x - 3, y, z)) != ritualBlock || world.func_180495_p(pos.func_177982_a(x, y, z - 3)) != ritualBlock || world.func_180495_p(pos.func_177982_a(x + 3, y, z)) != ritualBlock || world.func_180495_p(pos.func_177982_a(x, y, z + 3)) != ritualBlock || world.func_180495_p(pos.func_177982_a(x - 2, y, z + 2)) != ritualBlock || world.func_180495_p(pos.func_177982_a(x - 2, y, z - 2)) != ritualBlock || world.func_180495_p(pos.func_177982_a(x + 2, y, z + 2)) != ritualBlock || world.func_180495_p(pos.func_177982_a(x + 2, y, z - 2)) != ritualBlock || world.func_175665_u(pos.func_177982_a(x - 3, y, z - 1)) || world.func_175665_u(pos.func_177982_a(x - 3, y, z + 1)) || world.func_175665_u(pos.func_177982_a(x - 4, y, z)) || world.func_175665_u(pos.func_177982_a(x - 4, y, z - 1)) || world.func_175665_u(pos.func_177982_a(x - 4, y, z + 1)) || world.func_175665_u(pos.func_177982_a(x - 3, y, z - 2)) || world.func_175665_u(pos.func_177982_a(x - 3, y, z - 3)) || world.func_175665_u(pos.func_177982_a(x - 2, y, z - 3)) || world.func_175665_u(pos.func_177982_a(x - 1, y, z - 3)) || world.func_175665_u(pos.func_177982_a(x - 1, y, z - 4)) || world.func_175665_u(pos.func_177982_a(x, y, z - 4)) || world.func_175665_u(pos.func_177982_a(x + 1, y, z - 4)) || world.func_175665_u(pos.func_177982_a(x + 1, y, z - 3)) || world.func_175665_u(pos.func_177982_a(x + 2, y, z - 3)) || world.func_175665_u(pos.func_177982_a(x + 3, y, z - 3)) || world.func_175665_u(pos.func_177982_a(x + 3, y, z - 2)) || world.func_175665_u(pos.func_177982_a(x + 3, y, z - 1)) || world.func_175665_u(pos.func_177982_a(x + 4, y, z - 1)) || world.func_175665_u(pos.func_177982_a(x + 4, y, z)) || world.func_175665_u(pos.func_177982_a(x + 4, y, z + 1)) || world.func_175665_u(pos.func_177982_a(x + 3, y, z + 1)) || world.func_175665_u(pos.func_177982_a(x + 3, y, z + 2)) || world.func_175665_u(pos.func_177982_a(x + 3, y, z + 3)) || world.func_175665_u(pos.func_177982_a(x + 2, y, z + 3)) || world.func_175665_u(pos.func_177982_a(x + 1, y, z + 3)) || world.func_175665_u(pos.func_177982_a(x + 1, y, z + 4)) || world.func_175665_u(pos.func_177982_a(x, y, z + 4)) || world.func_175665_u(pos.func_177982_a(x - 1, y, z + 4)) || world.func_175665_u(pos.func_177982_a(x - 1, y, z + 3)) || world.func_175665_u(pos.func_177982_a(x - 2, y, z + 3)) || world.func_175665_u(pos.func_177982_a(x - 3, y, z + 3)) || world.func_175665_u(pos.func_177982_a(x - 3, y, z + 2)) || world.func_175665_u(pos.func_177982_a(x - 1, y, z + 0)) || world.func_175665_u(pos.func_177982_a(x + 1, y, z)) || world.func_175665_u(pos.func_177982_a(x, y, z - 1)) || world.func_175665_u(pos.func_177982_a(x, y, z + 1)) || world.func_175665_u(pos.func_177982_a(x - 1, y, z + 1)) || world.func_175665_u(pos.func_177982_a(x - 2, y, z)) || world.func_175665_u(pos.func_177982_a(x - 2, y, z)) || world.func_175665_u(pos.func_177982_a(x - 2, y, z - 1)) || world.func_175665_u(pos.func_177982_a(x - 1, y, z - 1)) || world.func_175665_u(pos.func_177982_a(x - 1, y, z - 2)) || world.func_175665_u(pos.func_177982_a(x, y, z - 2)) || world.func_175665_u(pos.func_177982_a(x + 1, y, z - 2)) || world.func_175665_u(pos.func_177982_a(x + 1, y, z - 1)) || world.func_175665_u(pos.func_177982_a(x + 2, y, z - 1)) || world.func_175665_u(pos.func_177982_a(x + 2, y, z)) || world.func_175665_u(pos.func_177982_a(x + 2, y, z + 1)) || world.func_175665_u(pos.func_177982_a(x + 1, y, z + 1)) || world.func_175665_u(pos.func_177982_a(x + 1, y, z + 2)) || world.func_175665_u(pos.func_177982_a(x, y, z + 2)) || world.func_175665_u(pos.func_177982_a(x - 1, y, z + 2)) || !RitualRegistry.instance().sameBookType(world.field_73011_w.getDimension(), ritualBlocks.get(ritualBlock)))) {
            if (!world.field_72995_K) {
                RitualUtil.createAltar(world, pos, ritualBlock);
            }
            return true;
        }
        return false;
    }

    private static void createAltar(World world, BlockPos pos, IBlockState block) {
        if (altarMeta.containsKey(block)) {
            int meta = altarMeta.get(block);
            int x = 0;
            int y = 0;
            int z = 0;
            world.func_175655_b(pos, false);
            world.func_175655_b(pos.func_177982_a(x - 3, y, z), false);
            world.func_175655_b(pos.func_177982_a(x, y, z - 3), false);
            world.func_175655_b(pos.func_177982_a(x + 3, y, z), false);
            world.func_175655_b(pos.func_177982_a(x, y, z + 3), false);
            world.func_175655_b(pos.func_177982_a(x - 2, y, z + 2), false);
            world.func_175655_b(pos.func_177982_a(x - 2, y, z - 2), false);
            world.func_175655_b(pos.func_177982_a(x + 2, y, z + 2), false);
            world.func_175655_b(pos.func_177982_a(x + 2, y, z - 2), false);
            world.func_180501_a(pos, ACBlocks.ritual_altar.func_176203_a(meta), 2);
            world.func_180501_a(pos.func_177982_a(x - 3, y, z), ACBlocks.ritual_pedestal.func_176203_a(meta), 2);
            world.func_180501_a(pos.func_177982_a(x, y, z - 3), ACBlocks.ritual_pedestal.func_176203_a(meta), 2);
            world.func_180501_a(pos.func_177982_a(x + 3, y, z), ACBlocks.ritual_pedestal.func_176203_a(meta), 2);
            world.func_180501_a(pos.func_177982_a(x, y, z + 3), ACBlocks.ritual_pedestal.func_176203_a(meta), 2);
            world.func_180501_a(pos.func_177982_a(x - 2, y, z + 2), ACBlocks.ritual_pedestal.func_176203_a(meta), 2);
            world.func_180501_a(pos.func_177982_a(x - 2, y, z - 2), ACBlocks.ritual_pedestal.func_176203_a(meta), 2);
            world.func_180501_a(pos.func_177982_a(x + 2, y, z + 2), ACBlocks.ritual_pedestal.func_176203_a(meta), 2);
            world.func_180501_a(pos.func_177982_a(x + 2, y, z - 2), ACBlocks.ritual_pedestal.func_176203_a(meta), 2);
        }
    }

    public static void modifyRitualBookType(String name, int bookType) {
        for (NecronomiconRitual r : RitualRegistry.instance().getRituals()) {
            if (!r.getUnlocalizedName().substring("ac.ritual.".length()).equals(name)) continue;
            ReflectionHelper.setPrivateValue(NecronomiconRitual.class, (Object)r, (Object)bookType, (String[])new String[]{"bookType"});
            break;
        }
    }

    public static void modifyRitualDimension(String name, int dimension) {
        for (NecronomiconRitual r : RitualRegistry.instance().getRituals()) {
            if (!r.getUnlocalizedName().substring("ac.ritual.".length()).equals(name)) continue;
            ReflectionHelper.setPrivateValue(NecronomiconRitual.class, (Object)r, (Object)dimension, (String[])new String[]{"dimension"});
            break;
        }
    }

    public static void modifyRitualSacrificeRequirement(String name, boolean requiresSacrifice) {
        for (NecronomiconRitual r : RitualRegistry.instance().getRituals()) {
            if (!r.getUnlocalizedName().substring("ac.ritual.".length()).equals(name)) continue;
            ReflectionHelper.setPrivateValue(NecronomiconRitual.class, (Object)r, (Object)requiresSacrifice, (String[])new String[]{"requiresSacrifice"});
            break;
        }
    }

    public static void modifyRitualEnergyRequirement(String name, float requiredEnergy) {
        for (NecronomiconRitual r : RitualRegistry.instance().getRituals()) {
            if (!r.getUnlocalizedName().substring("ac.ritual.".length()).equals(name)) continue;
            ReflectionHelper.setPrivateValue(NecronomiconRitual.class, (Object)r, (Object)Float.valueOf(requiredEnergy), (String[])new String[]{"requiredEnergy"});
            break;
        }
    }

    public static void modifyRitualSacrifice(String name, Object sacrifice) {
        for (NecronomiconRitual r : RitualRegistry.instance().getRituals()) {
            if (!r.getUnlocalizedName().substring("ac.ritual.".length()).equals(name) || r.getSacrifice() == null) continue;
            ReflectionHelper.setPrivateValue(NecronomiconRitual.class, (Object)r, (Object)sacrifice, (String[])new String[]{"sacrifice"});
            break;
        }
    }

    public static void modifyRitualNbtSensitivity(String name, boolean nbtSensitive) {
        for (NecronomiconRitual r : RitualRegistry.instance().getRituals()) {
            if (!r.getUnlocalizedName().substring("ac.ritual.".length()).equals(name)) continue;
            ReflectionHelper.setPrivateValue(NecronomiconRitual.class, (Object)r, (Object)nbtSensitive, (String[])new String[]{"nbtSensitive"});
            break;
        }
    }

    public static void modifyRitualNbtSensitivitySacrifice(String name, boolean nbtSensitiveSacrifice) {
        for (NecronomiconRitual r : RitualRegistry.instance().getRituals()) {
            if (!r.getUnlocalizedName().substring("ac.ritual.".length()).equals(name)) continue;
            ReflectionHelper.setPrivateValue(NecronomiconRitual.class, (Object)r, (Object)nbtSensitiveSacrifice, (String[])new String[]{"nbtSensitiveSacrifice"});
            break;
        }
    }

    public static void modifyRitualOfferings(String name, Object ... offerings) {
        for (NecronomiconRitual r : RitualRegistry.instance().getRituals()) {
            if (!r.getUnlocalizedName().substring("ac.ritual.".length()).equals(name)) continue;
            ReflectionHelper.setPrivateValue(NecronomiconRitual.class, (Object)r, (Object)offerings, (String[])new String[]{"offerings"});
            break;
        }
    }

    public static void modifyRitualReplaceOffering(String name, Object original, Object replace, boolean nbt) {
        for (NecronomiconRitual r : RitualRegistry.instance().getRituals()) {
            if (!r.getUnlocalizedName().substring("ac.ritual.".length()).equals(name)) continue;
            Object[] offerings = new Object[r.getOfferings().length];
            for (int i = 0; i < offerings.length; ++i) {
                offerings[i] = APIUtils.areObjectsEqual(APIUtils.convertToStack(original), r.getOfferings()[i], nbt) ? replace : r.getOfferings()[i];
            }
            ReflectionHelper.setPrivateValue(NecronomiconRitual.class, (Object)r, (Object)offerings, (String[])new String[]{"offerings"});
            break;
        }
    }
}

