/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.init;

import com.shinoow.abyssalcraft.AbyssalCraft;
import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.biome.ACBiomes;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.common.CommonProxy;
import com.shinoow.abyssalcraft.common.entity.EntityAbyssalZombie;
import com.shinoow.abyssalcraft.common.entity.EntityDepthsGhoul;
import com.shinoow.abyssalcraft.common.entity.EntityOmotholGhoul;
import com.shinoow.abyssalcraft.common.entity.anti.EntityAntiAbyssalZombie;
import com.shinoow.abyssalcraft.common.entity.anti.EntityAntiGhoul;
import com.shinoow.abyssalcraft.common.handlers.AbyssalCraftEventHooks;
import com.shinoow.abyssalcraft.common.handlers.InternalMethodHandler;
import com.shinoow.abyssalcraft.common.handlers.InternalNecroDataHandler;
import com.shinoow.abyssalcraft.common.handlers.KnowledgeEventHandler;
import com.shinoow.abyssalcraft.common.handlers.PlagueEventHandler;
import com.shinoow.abyssalcraft.common.handlers.PurgeEventHandler;
import com.shinoow.abyssalcraft.common.util.ACLogger;
import com.shinoow.abyssalcraft.init.ILifeCycleHandler;
import com.shinoow.abyssalcraft.init.MiscHandler;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.ACLib;
import com.shinoow.abyssalcraft.lib.ACLoot;
import com.shinoow.abyssalcraft.lib.ACTabs;
import com.shinoow.abyssalcraft.lib.util.RitualUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class InitHandler
implements ILifeCycleHandler {
    public static final InitHandler INSTANCE = new InitHandler();
    public static Configuration cfg;
    private static String[] abyssalZombieBlacklist;
    private static String[] depthsGhoulBlacklist;
    private static String[] antiAbyssalZombieBlacklist;
    private static String[] antiGhoulBlacklist;
    private static String[] omotholGhoulBlacklist;
    private static String[] interdimensionalCageBlacklist;
    private static String[] dreadPlagueImmunityList;
    private static String[] dreadPlagueCarrierList;
    private static String[] coraliumPlagueImmunityList;
    private static String[] coraliumPlagueCarrierList;
    public static int[] coraliumOreGeneration;
    private static int[] blackHoleBlacklist;
    private static int[] oreGenDimBlacklist;
    private static int[] structureGenDimBlacklist;
    private int[] blackHoleDimlist;
    public static boolean dark1;
    public static boolean dark2;
    public static boolean dark3;
    public static boolean dark4;
    public static boolean dark5;
    public static boolean coralium1;
    public static boolean darkspawn1;
    public static boolean darkspawn2;
    public static boolean darkspawn3;
    public static boolean darkspawn4;
    public static boolean darkspawn5;
    public static boolean coraliumspawn1;
    public static int darkWeight1;
    public static int darkWeight2;
    public static int darkWeight3;
    public static int darkWeight4;
    public static int darkWeight5;
    public static int coraliumWeight;
    public static final Fluid LIQUID_CORALIUM;
    public static final Fluid LIQUID_ANTIMATTER;
    private static final List<ItemStack> abyssal_zombie_blacklist;
    private static final List<ItemStack> depths_ghoul_blacklist;
    private static final List<ItemStack> anti_abyssal_zombie_blacklist;
    private static final List<ItemStack> anti_ghoul_blacklist;
    private static final List<ItemStack> omothol_ghoul_blacklist;
    private static final List<String> dread_carriers;
    private static final List<String> dread_immunity;
    private static final List<String> coralium_carriers;
    private static final List<String> coralium_immunity;
    public static final Map<ResourceLocation, Tuple<Integer, Float>> demon_transformations;
    final List<Block> BLOCKS = new ArrayList<Block>();
    final List<Item> ITEMS = new ArrayList<Item>();
    final List<Biome> BIOMES = new ArrayList<Biome>();
    final List<Enchantment> ENCHANTMENTS = new ArrayList<Enchantment>();
    final List<Potion> POTIONS = new ArrayList<Potion>();
    final List<PotionType> POTION_TYPES = new ArrayList<PotionType>();
    final List<SoundEvent> SOUND_EVENTS = new ArrayList<SoundEvent>();

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        AbyssalCraft.metadata = event.getModMetadata();
        AbyssalCraft.metadata.description = AbyssalCraft.metadata.description + "\n\n\u00a76Supporters: " + this.getSupporterList() + "\u00a7r";
        MinecraftForge.EVENT_BUS.register((Object)new AbyssalCraftEventHooks());
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new AbyssalCraftEventHooks());
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new KnowledgeEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlagueEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PurgeEventHandler());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)AbyssalCraft.instance, (IGuiHandler)new CommonProxy());
        AbyssalCraftAPI.setInternalNDHandler(new InternalNecroDataHandler());
        AbyssalCraftAPI.setInternalMethodHandler(new InternalMethodHandler());
        ACLoot.init();
        ACTabs.init();
        cfg = new Configuration(event.getSuggestedConfigurationFile());
        InitHandler.syncConfig();
        if (ACConfig.hardcoreMode) {
            AbyssalCraftAPI.coralium.func_151518_m();
            AbyssalCraftAPI.dread.func_151518_m();
        }
        if (!FluidRegistry.isFluidRegistered((String)"liquidcoralium")) {
            AbyssalCraftAPI.liquid_coralium_fluid = LIQUID_CORALIUM;
            FluidRegistry.registerFluid((Fluid)AbyssalCraftAPI.liquid_coralium_fluid);
            FluidRegistry.addBucketForFluid((Fluid)AbyssalCraftAPI.liquid_coralium_fluid);
        } else {
            ACLogger.warning("Liquid Coralium was already registered by another mod, adding ours as alternative.", new Object[0]);
            AbyssalCraftAPI.liquid_coralium_fluid = FluidRegistry.getFluid((String)"liquidcoralium");
            FluidRegistry.registerFluid((Fluid)LIQUID_CORALIUM);
            FluidRegistry.addBucketForFluid((Fluid)LIQUID_CORALIUM);
        }
        if (!FluidRegistry.isFluidRegistered((String)"liquidantimatter")) {
            AbyssalCraftAPI.liquid_antimatter_fluid = LIQUID_ANTIMATTER;
            FluidRegistry.registerFluid((Fluid)AbyssalCraftAPI.liquid_antimatter_fluid);
            FluidRegistry.addBucketForFluid((Fluid)AbyssalCraftAPI.liquid_antimatter_fluid);
        } else {
            ACLogger.warning("Liquid Antimatter was already registered by another mod, adding ours as alternative.", new Object[0]);
            AbyssalCraftAPI.liquid_antimatter_fluid = FluidRegistry.getFluid((String)"liquidantimatter");
            FluidRegistry.registerFluid((Fluid)LIQUID_ANTIMATTER);
            FluidRegistry.addBucketForFluid((Fluid)LIQUID_ANTIMATTER);
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        this.constructBlacklists();
        DimensionType[] dims = DimensionManager.getRegisteredDimensions().keySet().toArray(new DimensionType[0]);
        this.blackHoleDimlist = new int[dims.length];
        for (int i = 0; i < dims.length; ++i) {
            this.blackHoleDimlist[i] = dims[i].func_186068_a();
        }
    }

    @Override
    public void loadComplete(FMLLoadCompleteEvent event) {
    }

    public void serverStart(FMLServerAboutToStartEvent event) {
        String expect;
        String clname = AbyssalCraftAPI.getInternalNDHandler().getClass().getName();
        if (!clname.equals(expect = "com.shinoow.abyssalcraft.common.handlers.InternalNecroDataHandler")) {
            new IllegalAccessError("The AbyssalCraft API internal NecroData handler has been overriden. Since things are not going to work correctly, the game will now shut down. (Expected classname: " + expect + ", Actual classname: " + clname + ")").printStackTrace();
            FMLCommonHandler.instance().exitJava(1, true);
        }
        if (!(clname = AbyssalCraftAPI.getInternalMethodHandler().getClass().getName()).equals(expect = "com.shinoow.abyssalcraft.common.handlers.InternalMethodHandler")) {
            new IllegalAccessError("The AbyssalCraft API internal Method handler has been overriden. Since things are not going to work correctly, the game will now shut down. (Expected classname: " + expect + ", Actual classname: " + clname + ")").printStackTrace();
            FMLCommonHandler.instance().exitJava(1, true);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals("abyssalcraft")) {
            InitHandler.syncConfig();
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])this.BLOCKS.toArray(new Block[0]));
        RitualUtil.addBlocks();
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])this.ITEMS.toArray(new Item[0]));
        ACItems.liquid_coralium_bucket_stack = FluidUtil.getFilledBucket((FluidStack)new FluidStack(AbyssalCraftAPI.liquid_coralium_fluid, 1000));
        ACItems.liquid_antimatter_bucket_stack = FluidUtil.getFilledBucket((FluidStack)new FluidStack(AbyssalCraftAPI.liquid_antimatter_fluid, 1000));
        AbyssalCraftAPI.setRepairItems();
        MiscHandler.addOreDictionaryStuff();
    }

    @SubscribeEvent
    public void registerBiomes(RegistryEvent.Register<Biome> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])this.BIOMES.toArray(new Biome[0]));
        if (dark1) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(ACBiomes.darklands, darkWeight1));
            BiomeManager.addVillageBiome((Biome)ACBiomes.darklands, (boolean)true);
        }
        if (dark2) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(ACBiomes.darklands_forest, darkWeight2));
            BiomeManager.addVillageBiome((Biome)ACBiomes.darklands_forest, (boolean)true);
        }
        if (dark3) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(ACBiomes.darklands_plains, darkWeight3));
            BiomeManager.addVillageBiome((Biome)ACBiomes.darklands_plains, (boolean)true);
        }
        if (dark4) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(ACBiomes.darklands_hills, darkWeight4));
        }
        if (dark5) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(ACBiomes.darklands_mountains, darkWeight5));
            BiomeManager.addStrongholdBiome((Biome)ACBiomes.darklands_mountains);
        }
        if (coralium1) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(ACBiomes.coralium_infested_swamp, coraliumWeight));
        }
        if (darkspawn1) {
            BiomeManager.addSpawnBiome((Biome)ACBiomes.darklands);
        }
        if (darkspawn2) {
            BiomeManager.addSpawnBiome((Biome)ACBiomes.darklands_forest);
        }
        if (darkspawn3) {
            BiomeManager.addSpawnBiome((Biome)ACBiomes.darklands_plains);
        }
        if (darkspawn4) {
            BiomeManager.addSpawnBiome((Biome)ACBiomes.darklands_hills);
        }
        if (darkspawn5) {
            BiomeManager.addSpawnBiome((Biome)ACBiomes.darklands_mountains);
        }
        if (coraliumspawn1) {
            BiomeManager.addSpawnBiome((Biome)ACBiomes.coralium_infested_swamp);
        }
        BiomeDictionary.addTypes((Biome)ACBiomes.darklands, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes((Biome)ACBiomes.darklands_forest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes((Biome)ACBiomes.darklands_plains, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes((Biome)ACBiomes.darklands_hills, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes((Biome)ACBiomes.darklands_mountains, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes((Biome)ACBiomes.coralium_infested_swamp, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP});
        BiomeDictionary.addTypes((Biome)ACBiomes.abyssal_wastelands, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD});
        BiomeDictionary.addTypes((Biome)ACBiomes.dreadlands, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD});
        BiomeDictionary.addTypes((Biome)ACBiomes.purified_dreadlands, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD});
        BiomeDictionary.addTypes((Biome)ACBiomes.dreadlands_mountains, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD});
        BiomeDictionary.addTypes((Biome)ACBiomes.dreadlands_forest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD});
        BiomeDictionary.addTypes((Biome)ACBiomes.omothol, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD});
        BiomeDictionary.addTypes((Biome)ACBiomes.dark_realm, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD});
        BiomeDictionary.addTypes((Biome)ACBiomes.purged, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD});
    }

    @SubscribeEvent
    public void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])this.ENCHANTMENTS.toArray(new Enchantment[0]));
    }

    @SubscribeEvent
    public void registerPotions(RegistryEvent.Register<Potion> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])this.POTIONS.toArray(new Potion[0]));
    }

    @SubscribeEvent
    public void registerPotionTypes(RegistryEvent.Register<PotionType> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])this.POTION_TYPES.toArray(new PotionType[0]));
    }

    @SubscribeEvent
    public void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])this.SOUND_EVENTS.toArray(new SoundEvent[0]));
    }

    private static void syncConfig() {
        cfg.setCategoryComment("dimensions", "Dimension configuration (ID configuration and dimension unloading). Any changes take effect after a Minecraft restart.");
        cfg.setCategoryComment("biome_generation", "Biome generation configuration (whether a biome should generate). Any changes take effect after a Minecraft restart.");
        cfg.setCategoryComment("biome_spawning", "Biome spawning configuration (if players have a chance of spawning in the biomes). Any changes take effect after a Minecraft restart.");
        cfg.setCategoryComment("general", "General configuration (misc things). Only the spawn weights require a Minecraft restart for changes to take effect.");
        cfg.setCategoryComment("biome_weight", "Biome weight configuration (the chance n out of 100 that a biome is picked to generate). Any changes take effect after a Minecraft restart.");
        cfg.setCategoryComment("shoggoth", "Shoggoth Ooze configuration (blacklist materials from turning into ooze). Any changes take effect immediately.");
        cfg.setCategoryComment("worldgen", "World generation configuration (things that generate in the world). Any changes take effect immediately.");
        cfg.setCategoryComment("item_blacklist", "Entity Item Blacklist (allows you to blacklist items/blocks for entities that can pick up things). Any changes take effect after a Minecraft restart.");
        cfg.setCategoryComment("silly_settings", "These settings are generally out of place, and don't contribute to the mod experience. They exist because 'what if X did this?'");
        cfg.setCategoryComment("blocks", "These settings allow you to disable specific blocks in the mod, mainly slabs, stairs and walls. Any changes take effect after a Minecraft restart.");
        cfg.setCategoryComment("mod_compat", "Mod compatibility configuration (settings in regards to certain compatiblity with other mods that can be disabled at will).");
        cfg.setCategoryComment("wet_noodle", "These settings allow you to disable features of a destructive type, or things that to some extent will impact how the mod is played (while generally making it easier).");
        ACLib.abyssal_wasteland_id = cfg.get("dimensions", "The Abyssal Wasteland", 50, "The first dimension, full of undead monsters.").getInt();
        ACLib.dreadlands_id = cfg.get("dimensions", "The Dreadlands", 51, "The second dimension, infested with mutated monsters.").getInt();
        ACLib.omothol_id = cfg.get("dimensions", "Omothol", 52, "The third dimension, also known as \u00a7oThe Realm of J'zahar\u00a7r.").getInt();
        ACLib.dark_realm_id = cfg.get("dimensions", "The Dark Realm", 53, "Hidden fourth dimension, reached by falling down from Omothol").getInt();
        ACConfig.keepLoaded1 = cfg.get("dimensions", "Prevent unloading: The Abyssal Wasteland", false, "Set true to prevent The Abyssal Wasteland from automatically unloading (might affect performance)").getBoolean();
        ACConfig.keepLoaded2 = cfg.get("dimensions", "Prevent unloading: The Dreadlands", false, "Set true to prevent The Dreadlands from automatically unloading (might affect performance)").getBoolean();
        ACConfig.keepLoaded3 = cfg.get("dimensions", "Prevent unloading: Omothol", false, "Set true to prevent Omothol from automatically unloading (might affect performance)").getBoolean();
        ACConfig.keepLoaded4 = cfg.get("dimensions", "Prevent unloading: The Dark Realm", false, "Set true to prevent The Dark Realm from automatically unloading (might affect performance)").getBoolean();
        dark1 = cfg.get("biome_generation", "Darklands", true, "Set true for the Darklands biome to generate.").getBoolean();
        dark2 = cfg.get("biome_generation", "Darklands Forest", true, "Set true for the Darklands Forest biome to generate.").getBoolean();
        dark3 = cfg.get("biome_generation", "Darklands Plains", true, "Set true for the Darklands Plains biome to generate.").getBoolean();
        dark4 = cfg.get("biome_generation", "Darklands Highland", true, "Set true for the Darklands Highland biome to generate.").getBoolean();
        dark5 = cfg.get("biome_generation", "Darklands Mountain", true, "Set true for the Darklands Mountain biome to generate.").getBoolean();
        coralium1 = cfg.get("biome_generation", "Coralium Infested Swamp", true, "Set true for the Coralium Infested Swamp to generate.").getBoolean();
        darkspawn1 = cfg.get("biome_spawning", "Darklands", true, "If true, you can spawn in the Darklands biome.").getBoolean();
        darkspawn2 = cfg.get("biome_spawning", "Darklands Forest", true, "If true, you can spawn in the Darklands Forest biome.").getBoolean();
        darkspawn3 = cfg.get("biome_spawning", "Darklands Plains", true, "If true, you can spawn in the Darklands Plains biome.").getBoolean();
        darkspawn4 = cfg.get("biome_spawning", "Darklands Highland", true, "If true, you can spawn in the Darklands Highland biome.").getBoolean();
        darkspawn5 = cfg.get("biome_spawning", "Darklands Mountain", true, "If true, you can spawn in the Darklands Mountain biome.").getBoolean();
        coraliumspawn1 = cfg.get("biome_spawning", "Coralium Infested Swamp", true, "If true, you can spawn in the Coralium Infested Swamp biome.").getBoolean();
        ACConfig.shouldSpread = cfg.get("general", "Liquid Coralium transmutation", true, "Set true for the Liquid Coralium to convert other liquids into itself and transmute blocks into their Abyssal Wasteland counterparts outside of the Abyssal Wasteland.").getBoolean();
        ACConfig.shouldInfect = cfg.get("general", "Coralium Plague spreading", false, "Set true to allow the Coralium Plague to spread outside The Abyssal Wasteland.").getBoolean();
        ACConfig.destroyOcean = cfg.get("general", "Oceanic Coralium Pollution", false, "Set true to allow the Liquid Coralium to spread across oceans. WARNING: The game can crash from this.").getBoolean();
        ACConfig.demonAnimalFire = cfg.get("general", "Demon Animal burning", true, "Set to false to prevent Demon Animals (Pigs, Cows, Chickens) from burning in the overworld.").getBoolean();
        ACConfig.evilAnimalSpawnWeight = cfg.get("general", "Evil Animal spawn weight", 20, "Spawn weight for the Evil Animals (Pigs, Cows, Chickens), keep under 35 to avoid complete annihilation.\n[range: 0 ~ 100, default: 20]", 0, 100).getInt();
        ACConfig.particleBlock = cfg.get("general", "Block particles", true, "Toggles whether blocks that emits particles should do so.").getBoolean();
        ACConfig.particleEntity = cfg.get("general", "Entity particles", true, "Toggles whether entities that emits particles should do so.").getBoolean();
        ACConfig.hardcoreMode = cfg.get("general", "Hardcore Mode", false, "Toggles Hardcore mode. If set to true, all mobs (in the mod) will become tougher.").getBoolean();
        ACConfig.antiItemDisintegration = cfg.get("general", "Liquid Antimatter item disintegration", true, "Toggles whether or not Liquid Antimatter will disintegrate any items dropped into a pool of it.").getBoolean();
        ACConfig.portalCooldown = cfg.get("general", "Portal cooldown", 100, "Cooldown after using a portal, increasing the value increases the delay until you can teleport again. Measured in ticks (20 ticks = 1 second).\n[range: 10 ~ 300, default: 100]", 10, 300).getInt();
        ACConfig.demonAnimalSpawnWeight = cfg.get("general", "Demon Animal spawn weight", 15, "Spawn weight for the Demon Animals (Pigs, Cows, Chickens) spawning in the Nether.\n[range: 0 ~ 100, default: 15]", 0, 100).getInt();
        ACConfig.smeltingRecipes = cfg.get("general", "Smelting Recipes", true, "Toggles whether or not to add smelting recipes for armor pieces.").getBoolean();
        ACConfig.purgeMobSpawns = cfg.get("general", "Purge Mob Spawns", false, "Toggles whether or not to clear and repopulate the monster spawn list of all dimension biomes to ensure no mob from another mod got in there.").getBoolean();
        interdimensionalCageBlacklist = cfg.get("general", "Interdimensional Cage Blacklist", new String[0], "Entities added to this list can't be captured with the Interdimensional Cage.").getStringList();
        ACConfig.damageAmpl = cfg.get("general", "Hardcore Mode damage amplifier", 1.0, "When Hardcore Mode is enabled, you can use this to amplify the armor-piercing damage mobs deal.\n[range: 1.0 ~ 10.0, default: 1.0]", 1.0, 10.0).getDouble();
        ACConfig.depthsHelmetOverlayOpacity = cfg.get("general", "Visage of The Depths Overlay Opacity", 1.0, "Sets the opacity for the overlay shown when wearing the Visage of The Depths, reducing the value increases the transparency on the texture. Client Side only!\n[range: 0.5 ~ 1.0, default: 1.0]", 0.5, 1.0).getDouble();
        ACConfig.mimicFire = cfg.get("general", "Mimic Fire", true, "Toggles whether or not Demon Animals will spread Mimic Fire instead of regular Fire (regular Fire can affect performance)").getBoolean();
        ACConfig.armorPotionEffects = cfg.get("general", "Armor Potion Effects", true, "Toggles any interactions where armor sets either give certain Potion Effects, or dispell others. Useful if you have another mod installed that provides similar customization to any armor set.").getBoolean();
        ACConfig.syncDataOnBookOpening = cfg.get("general", "Necronomicon Data Syncing", true, "Toggles whether or not the Necronomicon knowledge will sync from the server to the client each time a player opens their Necronomicon.").getBoolean();
        ACConfig.dreadGrassSpread = cfg.get("general", "Dreadlands Grass Spread", true, "Toggles whether or not Dreadlands Grass can spread onto normal grass and dirt, slowly turning them into their Dreadlands counterparts.").getBoolean();
        APIUtils.display_names = cfg.get("general", "Display Item Names", false, "Toggles whether or not to override the name locking and display item names regardless of the knowledge being obtained or not.").getBoolean();
        blackHoleBlacklist = cfg.get("general", "Reality Maelstrom Blacklist", new int[0], "Dimension IDs added to this list won't be used as potential destinations for black holes created by J'zahar.").getIntList();
        ACConfig.portalSpawnsNearPlayer = cfg.get("general", "Portal Mob Spawning Near Players", true, "Toggles whether or not portals require a player to be nearby in order for it to rarely spawn mobs. If this option is disabled they follow the same principle as Nether portals.").getBoolean();
        ACConfig.showBossDialogs = cfg.get("general", "Show Boss Dialogs", true, "Toggles whether or not boss dialogs are displayed at any point during their fights (when they spawn, when they die,  etc)").getBoolean();
        ACConfig.knowledgeSyncDelay = cfg.get("general", "Knowledge Sync Delay", 60, "Delay in ticks until Knowledge is synced to the client upon changing dimensions. Higher numbers mean you might see item names re-locked for a few seconds when changing dimension, but might reduce load time for the dimension by a little (useful in larger modpacks).\\n[range: 20 ~ 400, default: 60]", 20, 400).getInt();
        dreadPlagueImmunityList = cfg.get("general", "Dread Plague Immunity List", new String[0], "Entities added to this list are considered immune to the Dread Plague.").getStringList();
        dreadPlagueCarrierList = cfg.get("general", "Dread Plague Carrier List", new String[0], "Entities added to this list are considered carriers of the Dread Plague (this also makes them immune).").getStringList();
        coraliumPlagueImmunityList = cfg.get("general", "Coralium Plague Immunity List", new String[0], "Entities added to this list are considered immune to the Coralium Plague.").getStringList();
        coraliumPlagueCarrierList = cfg.get("general", "Coralium Plague Carrier List", new String[0], "Entities added to this list are considered carriers of the Coralium Plague (this also makes them immune).").getStringList();
        ACConfig.lootTableContent = cfg.get("general", "Loot Table Content", true, "Toggles whether or not AbyssalCraft Items should be inserted into vanilla loot tables (dungeons, strongholds etc).").getBoolean();
        ACConfig.depthsGhoulBiomeDictSpawn = cfg.get("general", "Depths Ghoul Biome Dictionary Spawning", true, "Toggles whether or not Depths Ghouls should use the Biome Dictionary for finding biomes to spawn in (which might lead to them spawning in dimensions from other mods).").getBoolean();
        ACConfig.abyssalZombieBiomeDictSpawn = cfg.get("general", "Abyssal Zombie Biome Dictionary Spawning", true, "Toggles whether or not Abyssal Zombies should use the Biome Dictionary for finding biomes to spawn in (which might lead to them spawning in dimensions from other mods).").getBoolean();
        darkWeight1 = cfg.get("biome_weight", "Darklands", 5, "Biome weight for the Darklands biome, controls the chance of it generating (n out of 100).\n[range: 0 ~ 100, default: 5]", 0, 100).getInt();
        darkWeight2 = cfg.get("biome_weight", "Darklands Forest", 5, "Biome weight for the Darklands Forest biome, controls the chance of it generating (n out of 100)\n[range: 0 ~ 100, default: 5]", 0, 100).getInt();
        darkWeight3 = cfg.get("biome_weight", "Darklands Plains", 5, "Biome weight for the Darklands Plains biome, controls the chance of it generating (n out of 100)\n[range: 0 ~ 100, default: 5]", 0, 100).getInt();
        darkWeight4 = cfg.get("biome_weight", "Darklands Highland", 5, "Biome weight for the Darklands Highland biome, controls the chance of it generating (n out of 100)\n[range: 0 ~ 100, default: 5]", 0, 100).getInt();
        darkWeight5 = cfg.get("biome_weight", "Darklands Mountain", 5, "Biome weight for the Darklands Mountain biome, controls the chance of it generating (n out of 100)\n[range: 0 ~ 100, default: 5]").getInt();
        coraliumWeight = cfg.get("biome_weight", "Coralium Infested Swamp", 5, "Biome weight for the Coralium Infested Swamp biome, controls the chance of it generating (n out of 100)\n[range: 0 ~ 100, default: 5]", 0, 100).getInt();
        ACConfig.shoggothOoze = cfg.get("shoggoth", "Shoggoth Ooze Spread", true, "Toggles whether or not Lesser Shoggoths should spread their ooze when walking around.").getBoolean();
        ACConfig.oozeExpire = cfg.get("shoggoth", "Ooze expiration", false, "Toggles whether or not Shoggoth Ooze slowly reverts to dirt after constant light exposure.").getBoolean();
        ACConfig.consumeItems = cfg.get("shoggoth", "Item Consumption", true, "Toggles whether or not Lesser Shoggoths will consume any dropped item they run into.").getBoolean();
        ACConfig.shieldsBlockAcid = cfg.get("shoggoth", "Shields Block Acid", true, "Toggles whether or not Shields can block the acid projectiles spat by Lesser Shoggoths.").getBoolean();
        ACConfig.acidResistanceHardness = cfg.get("shoggoth", "Acid Resistance Hardness", 3.0, "The minimum Block Hardness required for a Block to not be destroyed by Shoggoth Acid (some blocks are unaffected regardless of their hardness)\\n[range: 2.1 ~ 51.0, default: 3.0]", 2.1, 51.0).getDouble();
        ACConfig.acidSpitFrequency = cfg.get("shoggoth", "Acid Spit Frequency", 100, "The frequency (in ticks) at which a Lesser Shoggoth can spit acid. Higher values increase the time between each spit attack, while lower values descrease the time (and 0 disables it).\\n[range: 0 ~ 300, default: 100]", 0, 300).getInt();
        ACConfig.generateDarklandsStructures = cfg.get("worldgen", "Darklands Structures", true, "Toggles whether or not to generate random Darklands structures.").getBoolean();
        ACConfig.generateShoggothLairs = cfg.get("worldgen", "Shoggoth Lairs", true, "Toggles whether or not to generate Shoggoth Lairs (however, they will still generate in Omothol).").getBoolean();
        ACConfig.generateAbyssalWastelandPillars = cfg.get("worldgen", "Abyssal Wasteland Pillars", true, "Toggles whether or not to generate Tall Obsidian Pillars in the Abyssal Wasteland.").getBoolean();
        ACConfig.generateAbyssalWastelandRuins = cfg.get("worldgen", "Abyssal Wasteland Ruins", true, "Toggles whether or not to generate small ruins in the Abyssal Wasteland.").getBoolean();
        ACConfig.generateAntimatterLake = cfg.get("worldgen", "Liquid Antimatter Lakes", true, "Toggles whether or not to generate Liquid Antimatter Lakes in Coralium Infested Swamps.").getBoolean();
        ACConfig.generateCoraliumLake = cfg.get("worldgen", "Liquid Coralium Lakes", true, "Toggles whether or not to generate Liquid Coralium Lakes in the Abyssal Wasteland.").getBoolean();
        ACConfig.generateDreadlandsStalagmite = cfg.get("worldgen", "Dreadlands Stalagmites", true, "Toggles whether or not to generate Stalagmites in Dreadlands and Purified Dreadlands biomes.").getBoolean();
        ACConfig.generateCoraliumOre = cfg.get("worldgen", "Coralium Ore", true, "Toggles whether or not to generate Coralium Ore in the Overworld.").getBoolean();
        ACConfig.generateNitreOre = cfg.get("worldgen", "Nitre Ore", true, "Toggles whether or not to generate Nitre Ore in the Overworld.").getBoolean();
        ACConfig.generateAbyssalniteOre = cfg.get("worldgen", "Abyssalnite Ore", true, "Toggles wheter or not to generate Abyssalnite Ore in Darklands Biomes.").getBoolean();
        ACConfig.generateAbyssalCoraliumOre = cfg.get("worldgen", "Abyssal Coralium Ore", true, "Toggles whether or not to generate Coralium Ore in the Abyssal Wasteland.").getBoolean();
        ACConfig.generateDreadlandsAbyssalniteOre = cfg.get("worldgen", "Dreadlands Abyssalnite Ore", true, "Toggles whether or not to generate Abyssalnite Ore in the Dreadlands.").getBoolean();
        ACConfig.generateDreadedAbyssalniteOre = cfg.get("worldgen", "Dreaded Abyssalnite Ore", true, "Toggles whether or not to generate Dreaded Abyssalnite Ore in the Dreadlands.").getBoolean();
        ACConfig.generateAbyssalIronOre = cfg.get("worldgen", "Abyssal Iron Ore", true, "Toggles whether or not to generate Iron Ore in the Abyssal Wasteland.").getBoolean();
        ACConfig.generateAbyssalGoldOre = cfg.get("worldgen", "Abyssal Gold Ore", true, "Toggles whether or not to generate Gold Ore in the Abyssal Wasteland.").getBoolean();
        ACConfig.generateAbyssalDiamondOre = cfg.get("worldgen", "Abyssal Diamond Ore", true, "Toggles whether or not to generate Diamond Ore in the Abyssal Wasteland").getBoolean();
        ACConfig.generateAbyssalNitreOre = cfg.get("worldgen", "Abyssal Nitre Ore", true, "Toggles whether or not to generate Nitre Ore in the Abyssal Wasteland.").getBoolean();
        ACConfig.generateAbyssalTinOre = cfg.get("worldgen", "Abyssal Tin Ore", true, "Toggles whether or not to generate Tin Ore in the Abyssal Wasteland").getBoolean();
        ACConfig.generateAbyssalCopperOre = cfg.get("worldgen", "Abyssal Copper Ore", true, "Toggles whether or not to generate Copper Ore in the Abyssal Wasteland.").getBoolean();
        ACConfig.generatePearlescentCoraliumOre = cfg.get("worldgen", "Pearlescent Coralium Ore", true, "Toggles whether or not to generate Pearlescent Coralium Ore in the Abyssal Wasteland.").getBoolean();
        ACConfig.generateLiquifiedCoraliumOre = cfg.get("worldgen", "Liquified Coralium Ore", true, "Toggles whether or not to generate Liquified Coralium Ore in the Abyssal Wasteland.").getBoolean();
        ACConfig.shoggothLairSpawnRate = cfg.get("worldgen", "Shoggoth Lair Generation Chance: Swamps", 30, "Generation chance of a Shoggoth Lair in swamp biomes. Higher numbers decrease the chance of a Lair generating, while lower numbers increase the chance.\n[range: 0 ~ 1000, default: 30]", 0, 1000).getInt();
        coraliumOreGeneration = cfg.get("worldgen", "Coralium Ore Generation", new int[]{12, 8, 40}, "Coralium Ore generation. First parameter is the vein count, secound is amount of ores per vein, third is max height for it to generate at. Coralium Ore generation in swamps are half as common as oceans.").getIntList();
        ACConfig.shoggothLairSpawnRateRivers = cfg.get("worldgen", "Shoggoth Lair Generation Chance: Rivers", 30, "Generation chance of a Shoggoth Lair in river biomes. Higher numbers decrease the chance of a Lair generating, while lower numbers increase the chance.\n[range: 0 ~ 1000, default: 30]", 0, 1000).getInt();
        oreGenDimBlacklist = cfg.get("worldgen", "Ore Generation Dimension Blacklist", new int[0], "Dimension IDs added to this list won't have any of AbyssalCraft's Overworld ores (Coralium, Nitre) generating in them. This only affects surface worlds (dimensions that handle world generation like the Overworld does).").getIntList();
        structureGenDimBlacklist = cfg.get("worldgen", "Structure Generation Dimension Blacklist", new int[0], "Dimension IDs added to this list won't have any of AbyssalCraft's Overworld structures (Darklands structures, Shoggoth lairs) generating in them. This only affects surface worlds (dimensions that handle world generation like the Overworld does).").getIntList();
        abyssalZombieBlacklist = cfg.get("item_blacklist", "Abyssal Zombie Item Blacklist", new String[]{"minecraft:rotten_flesh", "minecraft:bone", "abyssalcraft:antiflesh", "abyssalcraft:corflesh", "abyssalcraft:anticorflesh"}, "Items/Blocks added to this list won't be picked up by Abyssal Zombies. Format: modid:name:meta, where meta is optional.").getStringList();
        depthsGhoulBlacklist = cfg.get("item_blacklist", "Depths Ghoul Item Blacklist", new String[]{"minecraft:rotten_flesh", "minecraft:bone", "abyssalcraft:antiflesh", "abyssalcraft:corflesh", "abyssalcraft:anticorflesh"}, "Items/Blocks added to this list won't be picked up by Depths Ghouls. Format: modid:name:meta, where meta is optional.").getStringList();
        antiAbyssalZombieBlacklist = cfg.get("item_blacklist", "Abyssal Anti-Zombie Item Blacklist", new String[]{"minecraft:rotten_flesh", "minecraft:bone", "abyssalcraft:antiflesh", "abyssalcraft:corflesh", "abyssalcraft:anticorflesh"}, "Items/Blocks added to this list won't be picked up by Abyssal Anti-Zombies. Format: modid:name:meta, where meta is optional.").getStringList();
        antiGhoulBlacklist = cfg.get("item_blacklist", "Anti-Ghoul Item Blacklist", new String[]{"minecraft:rotten_flesh", "minecraft:bone", "abyssalcraft:antiflesh", "abyssalcraft:corflesh", "abyssalcraft:anticorflesh"}, "Items/Blocks added to this list won't be picked up by Anti-Ghouls. Format: modid:name:meta, where meta is optional.").getStringList();
        omotholGhoulBlacklist = cfg.get("item_blacklist", "Omothol Ghoul Item Blacklist", new String[]{"minecraft:rotten_flesh", "minecraft:bone", "abyssalcraft:antiflesh", "abyssalcraft:corflesh", "abyssalcraft:anticorflesh"}, "Items/Blocks added to this list won't be picked up by Omothol Ghouls. Format: modid:name:meta, where meta is optional.").getStringList();
        ACConfig.breakLogic = cfg.get("silly_settings", "Liquid Coralium Physics", false, "Set true to allow the Liquid Coralium to break the laws of physics in terms of movement").getBoolean();
        ACConfig.nuclearAntimatterExplosions = cfg.get("silly_settings", "Nuclear Antimatter Explosions", false, "Take a wild guess what this does... Done guessing? Yeah, makes the antimatter explosions more genuine by making them go all nuclear. Recommended to not enable unless you want chaos and destruction.").getBoolean();
        ACConfig.jzaharBreaksFourthWall = cfg.get("silly_settings", "J'zahar Can Break The Fourth Wall", true, "Toggles whether or not J'zahar can break the fourth wall.").getBoolean();
        ACConfig.darkstone_brick_slab = cfg.get("blocks", "Darkstone Brick Slab", true).getBoolean();
        ACConfig.darkstone_cobblestone_slab = cfg.get("blocks", "Darkstone Cobblestone Slab", true).getBoolean();
        ACConfig.darkstone_brick_stairs = cfg.get("blocks", "Darkstone Brick Stairs", true).getBoolean();
        ACConfig.darkstone_cobblestone_stairs = cfg.get("blocks", "Darkstone Cobblestone Stairs", true).getBoolean();
        ACConfig.darkstone_slab = cfg.get("blocks", "Darkstone Slab", true).getBoolean();
        ACConfig.darklands_oak_slab = cfg.get("blocks", "Darklands Oak Slab", true).getBoolean();
        ACConfig.darklands_oak_stairs = cfg.get("blocks", "Darklands Oak Stairs", true).getBoolean();
        ACConfig.abyssal_stone_brick_slab = cfg.get("blocks", "Abyssal Stone Brick Slab", true).getBoolean();
        ACConfig.abyssal_stone_brick_stairs = cfg.get("blocks", "Abyssal Stone Brick Stairs", true).getBoolean();
        ACConfig.coralium_stone_brick_slab = cfg.get("blocks", "Coralium Stone Brick Slab", true).getBoolean();
        ACConfig.coralium_stone_brick_stairs = cfg.get("blocks", "Coralium Stone Brick Stairs", true).getBoolean();
        ACConfig.dreadstone_brick_slab = cfg.get("blocks", "Dreadstone Brick Slab", true).getBoolean();
        ACConfig.dreadstone_brick_stairs = cfg.get("blocks", "Dreadstone Brick Stairs", true).getBoolean();
        ACConfig.abyssalnite_stone_brick_slab = cfg.get("blocks", "Abyssalnite Stone Brick Slab", true).getBoolean();
        ACConfig.abyssalnite_stone_brick_stairs = cfg.get("blocks", "Abyssalnite Stone Brick Stairs", true).getBoolean();
        ACConfig.ethaxium_brick_slab = cfg.get("blocks", "Ethaxium Brick Slab", true).getBoolean();
        ACConfig.ethaxium_brick_stairs = cfg.get("blocks", "Ethaxium Brick Stairs", true).getBoolean();
        ACConfig.abyssal_cobblestone_slab = cfg.get("blocks", "Abyssal Cobblestone Slab", true).getBoolean();
        ACConfig.abyssal_cobblestone_stairs = cfg.get("blocks", "Abyssal Cobblestone Stairs", true).getBoolean();
        ACConfig.coralium_cobblestone_slab = cfg.get("blocks", "Coralium Cobblestone Slab", true).getBoolean();
        ACConfig.coralium_cobblestone_stairs = cfg.get("blocks", "Coralium Cobblestone Stairs", true).getBoolean();
        ACConfig.dreadstone_cobblestone_slab = cfg.get("blocks", "Dreadstone Cobblestone Slab", true).getBoolean();
        ACConfig.dreadstone_cobblestone_stairs = cfg.get("blocks", "Dreadstone Cobblestone Stairs", true).getBoolean();
        ACConfig.abyssalnite_cobblestone_slab = cfg.get("blocks", "Abyssalnite Cobblestone Slab", true).getBoolean();
        ACConfig.abyssalnite_cobblestone_stairs = cfg.get("blocks", "Abyssalnite Cobblestone Stairs", true).getBoolean();
        ACConfig.darkstone_cobblestone_wall = cfg.get("blocks", "Darkstone Cobblestone Wall", true).getBoolean();
        ACConfig.abyssal_cobbblestone_wall = cfg.get("blocks", "Abyssal Cobblestone Wall", true).getBoolean();
        ACConfig.coralium_cobblestone_wall = cfg.get("blocks", "Coralium Cobblestone Wall", true).getBoolean();
        ACConfig.dreadstone_cobblestone_wall = cfg.get("blocks", "Dreadstone Cobblestone Wall", true).getBoolean();
        ACConfig.abyssalnite_cobblestone_wall = cfg.get("blocks", "Abyssalnite Cobblestone Wall", true).getBoolean();
        ACConfig.no_dreadlands_spread = cfg.get("wet_noodle", "Disable Dreadlands Spread", false, "Toggles whether or not the spreading of Dreadlands through the Dread Plague is disabled. Cha'garoth remains unaffected by this (because he doesn't naturally spawn outside of the dimension).").getBoolean();
        ACConfig.no_acid_breaking_blocks = cfg.get("wet_noodle", "Disable Acid Projectiles Breaking Blocks", false, "Toggles whether or not the acid projectiles Lesser Shoggoths spit can break blocks.").getBoolean();
        ACConfig.no_spectral_dragons = cfg.get("wet_noodle", "Disable Spectral Dragons", false, "Toggles whether or not Spectral Dragons should spawn in the Abyssal Wasteland.").getBoolean();
        ACConfig.no_projectile_damage_immunity = cfg.get("wet_noodle", "Disable Projectile Damage Immunity", false, "Toggles whether or not Lesser Shoggoths are immune to projectile damage.").getBoolean();
        ACConfig.no_disruptions = cfg.get("wet_noodle", "Disable Disruptions", false, "Toggles whether or not statues or failing rituals will trigger disruptions.").getBoolean();
        ACConfig.no_black_holes = cfg.get("wet_noodle", "Disable Black Holes", false, "Toggles whether or not J'zahar can use his attack that creates a black hole.").getBoolean();
        String[] transformations = cfg.getStringList("Demon Animal Transformations", "general", new String[0], "Mobs added to this list will have a chance of spawning a Demon Animal of choice on death.\nFormat: entityid;demonanimal;chance \nwhere entityid is the String used in the /summon command\n demonanimal is a Integer representing the Demon Animal to spawn (0 = Demon Pig, 1 = Demon Cow, 2 = Demon Chicken, 3 = Demon Sheep)\nchance is a decimal number representing the chance (optional, can be left out) of the Demon Animal being spawned (0.2 would mean a 20% chance, defaults to 100% if not set");
        ACConfig.hcdarkness_aw = cfg.get("mod_compat", "Hardcore Darkness: Abyssal Wasteland", true, "Toggles whether or not the Abyssal Wasteland should be darker if Hardcore Darkness is installed.").getBoolean();
        ACConfig.hcdarkness_dl = cfg.get("mod_compat", "Hardcore Darkness: Dreadlands", true, "Toggles whether or not the Dreadlands should be darker if Hardcore Darkness is installed.").getBoolean();
        ACConfig.hcdarkness_omt = cfg.get("mod_compat", "Hardcore Darkness: Omothol", true, "Toggles whether or not Omothol should be darker if Hardcore Darkness is installed.").getBoolean();
        ACConfig.hcdarkness_dr = cfg.get("mod_compat", "Hardcore Darkness: Dark Realm", true, "Toggles whether or not the Dark Realm should be darker if Hardcore Darkness is installed.").getBoolean();
        ACConfig.evilAnimalSpawnWeight = MathHelper.func_76125_a((int)ACConfig.evilAnimalSpawnWeight, (int)0, (int)100);
        ACConfig.portalCooldown = MathHelper.func_76125_a((int)ACConfig.portalCooldown, (int)10, (int)300);
        ACConfig.demonAnimalSpawnWeight = MathHelper.func_76125_a((int)ACConfig.demonAnimalSpawnWeight, (int)0, (int)100);
        ACConfig.shoggothLairSpawnRate = MathHelper.func_76125_a((int)ACConfig.shoggothLairSpawnRate, (int)0, (int)1000);
        darkWeight1 = MathHelper.func_76125_a((int)darkWeight1, (int)0, (int)100);
        darkWeight2 = MathHelper.func_76125_a((int)darkWeight2, (int)0, (int)100);
        darkWeight3 = MathHelper.func_76125_a((int)darkWeight3, (int)0, (int)100);
        darkWeight4 = MathHelper.func_76125_a((int)darkWeight4, (int)0, (int)100);
        darkWeight5 = MathHelper.func_76125_a((int)darkWeight5, (int)0, (int)100);
        coraliumWeight = MathHelper.func_76125_a((int)coraliumWeight, (int)0, (int)100);
        ACConfig.damageAmpl = MathHelper.func_151237_a((double)ACConfig.damageAmpl, (double)1.0, (double)10.0);
        ACConfig.depthsHelmetOverlayOpacity = MathHelper.func_151237_a((double)ACConfig.depthsHelmetOverlayOpacity, (double)0.5, (double)1.0);
        if (coraliumOreGeneration.length != 3) {
            coraliumOreGeneration = new int[]{12, 8, 40};
        }
        ACConfig.acidResistanceHardness = MathHelper.func_151237_a((double)ACConfig.acidResistanceHardness, (double)2.1, (double)51.0);
        ACConfig.acidSpitFrequency = MathHelper.func_76125_a((int)ACConfig.acidSpitFrequency, (int)0, (int)300);
        ACConfig.knowledgeSyncDelay = MathHelper.func_76125_a((int)ACConfig.knowledgeSyncDelay, (int)20, (int)400);
        demon_transformations.clear();
        for (String str : transformations) {
            if (str.length() <= 0) continue;
            String[] stuff = str.split(";");
            if (stuff.length >= 2) {
                demon_transformations.put(new ResourceLocation(stuff[0]), (Tuple<Integer, Float>)new Tuple((Object)Integer.valueOf(stuff[1]), (Object)Float.valueOf(stuff.length == 3 ? Float.valueOf(stuff[2]).floatValue() : 1.0f)));
                continue;
            }
            ACLogger.severe("Invalid Demon Animal Transformation: {}", str);
        }
        InitHandler.clearImmunityLists();
        for (String str : dreadPlagueImmunityList) {
            InitHandler.addDreadPlagueImmunity(str);
        }
        for (String str : dreadPlagueCarrierList) {
            InitHandler.addDreadPlagueCarrier(str);
        }
        for (String str : coraliumPlagueImmunityList) {
            InitHandler.addCoraliumPlagueImmunity(str);
        }
        for (String str : coraliumPlagueCarrierList) {
            InitHandler.addCoraliumPlagueCarrier(str);
        }
        if (cfg.hasChanged()) {
            cfg.save();
        }
    }

    private void constructBlacklists() {
        Item item;
        String[] stuff;
        if (abyssalZombieBlacklist.length > 0) {
            for (String str : abyssalZombieBlacklist) {
                if (str.length() <= 0) continue;
                stuff = str.split(":");
                item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(stuff[0], stuff[1]));
                if (item != null) {
                    abyssal_zombie_blacklist.add(new ItemStack(item, 1, stuff.length == 3 ? Integer.valueOf(stuff[2]) : Short.MAX_VALUE));
                    continue;
                }
                ACLogger.severe("{} is not a valid Item!", str);
            }
        }
        if (depthsGhoulBlacklist.length > 0) {
            for (String str : depthsGhoulBlacklist) {
                if (str.length() <= 0) continue;
                stuff = str.split(":");
                item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(stuff[0], stuff[1]));
                if (item != null) {
                    depths_ghoul_blacklist.add(new ItemStack(item, 1, stuff.length == 3 ? Integer.valueOf(stuff[2]) : Short.MAX_VALUE));
                    continue;
                }
                ACLogger.severe("{} is not a valid Item!", str);
            }
        }
        if (antiAbyssalZombieBlacklist.length > 0) {
            for (String str : antiAbyssalZombieBlacklist) {
                if (str.length() <= 0) continue;
                stuff = str.split(":");
                item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(stuff[0], stuff[1]));
                if (item != null) {
                    anti_abyssal_zombie_blacklist.add(new ItemStack(item, 1, stuff.length == 3 ? Integer.valueOf(stuff[2]) : Short.MAX_VALUE));
                    continue;
                }
                ACLogger.severe("{} is not a valid Item!", str);
            }
        }
        if (antiGhoulBlacklist.length > 0) {
            for (String str : antiGhoulBlacklist) {
                if (str.length() <= 0) continue;
                stuff = str.split(":");
                item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(stuff[0], stuff[1]));
                if (item != null) {
                    anti_ghoul_blacklist.add(new ItemStack(item, 1, stuff.length == 3 ? Integer.valueOf(stuff[2]) : Short.MAX_VALUE));
                    continue;
                }
                ACLogger.severe("{} is not a valid Item!", str);
            }
        }
        if (omotholGhoulBlacklist.length > 0) {
            for (String str : omotholGhoulBlacklist) {
                if (str.length() <= 0) continue;
                stuff = str.split(":");
                item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(stuff[0], stuff[1]));
                if (item != null) {
                    omothol_ghoul_blacklist.add(new ItemStack(item, 1, stuff.length == 3 ? Integer.valueOf(stuff[2]) : Short.MAX_VALUE));
                    continue;
                }
                ACLogger.severe("{} is not a valid Item!", str);
            }
        }
    }

    public boolean isItemBlacklisted(Entity entity, ItemStack stack) {
        if (entity instanceof EntityAbyssalZombie && !abyssal_zombie_blacklist.isEmpty()) {
            for (ItemStack stack2 : abyssal_zombie_blacklist) {
                if (!this.areStacksEqual(stack2, stack)) continue;
                return true;
            }
        }
        if (entity instanceof EntityDepthsGhoul && !depths_ghoul_blacklist.isEmpty()) {
            for (ItemStack stack2 : depths_ghoul_blacklist) {
                if (!this.areStacksEqual(stack2, stack)) continue;
                return true;
            }
        }
        if (entity instanceof EntityAntiAbyssalZombie && !anti_abyssal_zombie_blacklist.isEmpty()) {
            for (ItemStack stack2 : anti_abyssal_zombie_blacklist) {
                if (!this.areStacksEqual(stack2, stack)) continue;
                return true;
            }
        }
        if (entity instanceof EntityAntiGhoul && !anti_ghoul_blacklist.isEmpty()) {
            for (ItemStack stack2 : anti_ghoul_blacklist) {
                if (!this.areStacksEqual(stack2, stack)) continue;
                return true;
            }
        }
        if (entity instanceof EntityOmotholGhoul && !omothol_ghoul_blacklist.isEmpty()) {
            for (ItemStack stack2 : omothol_ghoul_blacklist) {
                if (!this.areStacksEqual(stack2, stack)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.func_77973_b() == stack2.func_77973_b() && (stack1.func_77952_i() == Short.MAX_VALUE || stack1.func_77952_i() == stack2.func_77952_i());
    }

    public boolean isEntityBlacklisted(Entity entity) {
        String id = EntityList.func_75621_b((Entity)entity);
        for (String str : interdimensionalCageBlacklist) {
            if (!str.equals(id)) continue;
            return true;
        }
        return false;
    }

    public int getRandomDimension(int currentdim, Random rand) {
        int id = 0;
        int tries = 0;
        while (((id = this.blackHoleDimlist[rand.nextInt(this.blackHoleDimlist.length)]) == currentdim || this.isDimBlacklisted(id)) && ++tries < 20) {
        }
        return tries == 20 ? ACLib.dark_realm_id : id;
    }

    private boolean isDimBlacklisted(int id) {
        for (int check : blackHoleBlacklist) {
            if (check != id) continue;
            return true;
        }
        return false;
    }

    public boolean isDimBlacklistedFromOreGen(int id) {
        for (int check : oreGenDimBlacklist) {
            if (check != id) continue;
            return true;
        }
        return false;
    }

    public boolean isDimBlacklistedFromStructureGen(int id) {
        for (int check : structureGenDimBlacklist) {
            if (check != id) continue;
            return true;
        }
        return false;
    }

    private static void addDreadPlagueImmunity(String entity) {
        if (EntityList.func_180125_b((ResourceLocation)new ResourceLocation(entity))) {
            dread_immunity.add(entity);
        }
    }

    private static void addDreadPlagueCarrier(String entity) {
        InitHandler.addDreadPlagueImmunity(entity);
        if (EntityList.func_180125_b((ResourceLocation)new ResourceLocation(entity))) {
            dread_carriers.add(entity);
        }
    }

    private static void addCoraliumPlagueImmunity(String entity) {
        if (EntityList.func_180125_b((ResourceLocation)new ResourceLocation(entity))) {
            coralium_immunity.add(entity);
        }
    }

    private static void addCoraliumPlagueCarrier(String entity) {
        InitHandler.addCoraliumPlagueImmunity(entity);
        if (EntityList.func_180125_b((ResourceLocation)new ResourceLocation(entity))) {
            coralium_carriers.add(entity);
        }
    }

    private static void clearImmunityLists() {
        dread_immunity.clear();
        dread_carriers.clear();
        coralium_immunity.clear();
        coralium_carriers.clear();
    }

    public boolean isImmuneOrCarrier(String entity, int list) {
        switch (list) {
            case 0: {
                return dread_immunity.contains(entity);
            }
            case 1: {
                return dread_carriers.contains(entity);
            }
            case 2: {
                return coralium_immunity.contains(entity);
            }
            case 3: {
                return coralium_carriers.contains(entity);
            }
        }
        return false;
    }

    private String getSupporterList() {
        String names = "";
        try {
            BufferedReader nameFile = new BufferedReader(new InputStreamReader(new URL("https://raw.githubusercontent.com/Shinoow/AbyssalCraft/master/supporters.txt").openStream()));
            names = nameFile.readLine();
            nameFile.close();
        }
        catch (IOException e) {
            ACLogger.severe("Failed to fetch supporter list, using local version!", new Object[0]);
            names = "Tedyhere";
        }
        return names;
    }

    static {
        LIQUID_CORALIUM = new Fluid("liquidcoralium", new ResourceLocation("abyssalcraft", "blocks/cwater_still"), new ResourceLocation("abyssalcraft", "blocks/cwater_flow")).setDensity(3000).setTemperature(350);
        LIQUID_ANTIMATTER = new Fluid("liquidantimatter", new ResourceLocation("abyssalcraft", "blocks/anti_still"), new ResourceLocation("abyssalcraft", "blocks/anti_flow")).setDensity(4000).setViscosity(1500).setTemperature(100);
        abyssal_zombie_blacklist = new ArrayList<ItemStack>();
        depths_ghoul_blacklist = new ArrayList<ItemStack>();
        anti_abyssal_zombie_blacklist = new ArrayList<ItemStack>();
        anti_ghoul_blacklist = new ArrayList<ItemStack>();
        omothol_ghoul_blacklist = new ArrayList<ItemStack>();
        dread_carriers = new ArrayList<String>();
        dread_immunity = new ArrayList<String>();
        coralium_carriers = new ArrayList<String>();
        coralium_immunity = new ArrayList<String>();
        demon_transformations = new HashMap<ResourceLocation, Tuple<Integer, Float>>();
    }
}

