/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.network.server;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.entity.EntityUtil;
import com.shinoow.abyssalcraft.api.entity.IOmotholEntity;
import com.shinoow.abyssalcraft.common.network.AbstractMessage;
import com.shinoow.abyssalcraft.lib.ACLib;
import com.shinoow.abyssalcraft.lib.util.items.IStaffOfRending;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class StaffOfRendingMessage
extends AbstractMessage.AbstractServerMessage<StaffOfRendingMessage> {
    int id;
    EnumHand hand;

    public StaffOfRendingMessage() {
    }

    public StaffOfRendingMessage(int id, EnumHand hand) {
        this.id = id;
        this.hand = hand;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.id = ByteBufUtils.readVarInt((ByteBuf)buffer, (int)5);
        this.hand = ByteBufUtils.readVarInt((ByteBuf)buffer, (int)5) == 0 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        ByteBufUtils.writeVarInt((ByteBuf)buffer, (int)this.id, (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buffer, (int)(this.hand == EnumHand.MAIN_HAND ? 0 : 1), (int)5);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        if (player.func_184586_b(this.hand) == null) {
            return;
        }
        ItemStack stack = player.func_184586_b(this.hand);
        Entity e = player.field_70170_p.func_73045_a(this.id);
        if (e == null) {
            return;
        }
        if (stack.func_77973_b() instanceof IStaffOfRending) {
            if (e instanceof EntityLiving) {
                IStaffOfRending staff = (IStaffOfRending)stack.func_77973_b();
                EntityLiving target = (EntityLiving)e;
                if (target.func_70668_bt() == AbyssalCraftAPI.SHADOW && target.func_184222_aU()) {
                    if (!target.field_70128_L && target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)staff.getDrainAmount(stack))) {
                        staff.increaseEnergy(stack, "Shadow");
                    }
                } else if (player.field_70170_p.field_73011_w.getDimension() == ACLib.abyssal_wasteland_id && EntityUtil.isCoraliumPlagueCarrier((EntityLivingBase)target) && target.func_184222_aU()) {
                    if (!target.field_70128_L && target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)staff.getDrainAmount(stack))) {
                        staff.increaseEnergy(stack, "Abyssal");
                    }
                } else if (player.field_70170_p.field_73011_w.getDimension() == ACLib.dreadlands_id && EntityUtil.isDreadPlagueCarrier((EntityLivingBase)target) && target.func_184222_aU()) {
                    if (!target.field_70128_L && target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)staff.getDrainAmount(stack))) {
                        staff.increaseEnergy(stack, "Dread");
                    }
                } else if (player.field_70170_p.field_73011_w.getDimension() == ACLib.omothol_id && target instanceof IOmotholEntity && target.func_70668_bt() != AbyssalCraftAPI.SHADOW && target.func_184222_aU() && !target.field_70128_L && target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)staff.getDrainAmount(stack))) {
                    staff.increaseEnergy(stack, "Omothol");
                }
            } else if (e instanceof MultiPartEntityPart && ((MultiPartEntityPart)e).field_70259_a instanceof EntityLiving) {
                IStaffOfRending staff = (IStaffOfRending)stack.func_77973_b();
                MultiPartEntityPart target = (MultiPartEntityPart)e;
                EntityLiving parent = (EntityLiving)target.field_70259_a;
                if (parent.func_70668_bt() == AbyssalCraftAPI.SHADOW && parent.func_184222_aU()) {
                    if (!target.field_70128_L && target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)staff.getDrainAmount(stack))) {
                        staff.increaseEnergy(stack, "Shadow");
                    }
                } else if (player.field_70170_p.field_73011_w.getDimension() == ACLib.abyssal_wasteland_id && EntityUtil.isCoraliumPlagueCarrier((EntityLivingBase)parent) && parent.func_184222_aU()) {
                    if (!target.field_70128_L && target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)staff.getDrainAmount(stack))) {
                        staff.increaseEnergy(stack, "Abyssal");
                    }
                } else if (player.field_70170_p.field_73011_w.getDimension() == ACLib.dreadlands_id && EntityUtil.isDreadPlagueCarrier((EntityLivingBase)parent) && parent.func_184222_aU()) {
                    if (!target.field_70128_L && target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)staff.getDrainAmount(stack))) {
                        staff.increaseEnergy(stack, "Dread");
                    }
                } else if (player.field_70170_p.field_73011_w.getDimension() == ACLib.omothol_id && parent instanceof IOmotholEntity && parent.func_70668_bt() != AbyssalCraftAPI.SHADOW && parent.func_184222_aU() && !target.field_70128_L && target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)staff.getDrainAmount(stack))) {
                    staff.increaseEnergy(stack, "Omothol");
                }
            }
        }
    }
}

