/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.items;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.common.blocks.BlockACStone;
import com.shinoow.abyssalcraft.common.items.ItemACBasic;
import com.shinoow.abyssalcraft.lib.ACLib;
import com.shinoow.abyssalcraft.lib.ACTabs;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;

public class ItemPortalPlacer
extends ItemACBasic {
    private final int key;

    public ItemPortalPlacer(int key, String unlocalizedName) {
        super(unlocalizedName);
        this.key = key;
        this.field_77777_bU = 1;
        this.func_77637_a(ACTabs.tabTools);
    }

    public boolean func_77662_d() {
        return true;
    }

    @Override
    public String func_77653_i(ItemStack par1ItemStack) {
        switch (this.key) {
            case 1: {
                return TextFormatting.DARK_RED + super.func_77653_i(par1ItemStack);
            }
            case 2: {
                return TextFormatting.BLUE + super.func_77653_i(par1ItemStack);
            }
        }
        return super.func_77653_i(par1ItemStack);
    }

    public void func_77624_a(ItemStack par1ItemStack, World entityplayer, List list, ITooltipFlag is) {
        list.add(I18n.func_135052_a((String)"tooltip.portalplacer.1", (Object[])new Object[0]));
        list.add(I18n.func_135052_a((String)"tooltip.portalplacer.2", (Object[])new Object[0]));
        if (this.key > 0) {
            list.add(I18n.func_135052_a((String)"tooltip.portalplacer.3", (Object[])new Object[0]));
        }
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.field_73011_w != null && !this.isCorrectDim(Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension())) {
            list.add(TextFormatting.DARK_RED + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"tooltip.portalplacer.4", (Object[])new Object[0]));
        }
    }

    private boolean isCorrectDim(int dim) {
        switch (this.key) {
            case 0: {
                if (dim == 0 || dim == ACLib.abyssal_wasteland_id) {
                    return true;
                }
                return AbyssalCraftAPI.getGatewayKeyOverride(dim) == 0;
            }
            case 1: {
                if (dim == 0 || dim == ACLib.abyssal_wasteland_id || dim == ACLib.dreadlands_id) {
                    return true;
                }
                return AbyssalCraftAPI.getGatewayKeyOverride(dim) >= 0 && AbyssalCraftAPI.getGatewayKeyOverride(dim) < 2;
            }
            case 2: {
                if (dim == 0 || dim == ACLib.abyssal_wasteland_id || dim == ACLib.dreadlands_id || dim == ACLib.omothol_id || dim == ACLib.dark_realm_id) {
                    return true;
                }
                return AbyssalCraftAPI.getGatewayKeyOverride(dim) >= 0;
            }
        }
        return false;
    }

    private boolean dimWarning(int dim) {
        switch (this.key) {
            case 0: {
                if (dim == ACLib.dreadlands_id || dim == ACLib.omothol_id || dim == ACLib.dark_realm_id) {
                    return true;
                }
                return AbyssalCraftAPI.getGatewayKeyOverride(dim) > 0;
            }
            case 1: {
                if (dim == ACLib.omothol_id || dim == ACLib.dark_realm_id) {
                    return true;
                }
                return AbyssalCraftAPI.getGatewayKeyOverride(dim) > 1;
            }
        }
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (this.isCorrectDim(player.field_71093_bK)) {
                int direction = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                int o = AbyssalCraftAPI.getGatewayKeyOverride(player.field_71093_bK);
                switch (this.key) {
                    case 0: {
                        return this.buildPortal(world, pos, direction, ACBlocks.stone.func_176223_P().func_177226_a(BlockACStone.TYPE, (Comparable)((Object)BlockACStone.EnumStoneType.ABYSSAL_STONE)), ACBlocks.coralium_fire.func_176223_P());
                    }
                    case 1: {
                        if (player.field_71093_bK == ACLib.abyssal_wasteland_id && player.func_70093_af() || player.field_71093_bK == 0 || o == 0) {
                            return this.buildPortal(world, pos, direction, ACBlocks.stone.func_176223_P().func_177226_a(BlockACStone.TYPE, (Comparable)((Object)BlockACStone.EnumStoneType.ABYSSAL_STONE)), ACBlocks.coralium_fire.func_176223_P());
                        }
                        return this.buildPortal(world, pos, direction, ACBlocks.stone.func_176223_P().func_177226_a(BlockACStone.TYPE, (Comparable)((Object)BlockACStone.EnumStoneType.DREADSTONE)), ACBlocks.dreaded_fire.func_176223_P());
                    }
                    case 2: {
                        if (player.field_71093_bK == ACLib.abyssal_wasteland_id && player.func_70093_af() || player.field_71093_bK == 0 || o == 0) {
                            return this.buildPortal(world, pos, direction, ACBlocks.stone.func_176223_P().func_177226_a(BlockACStone.TYPE, (Comparable)((Object)BlockACStone.EnumStoneType.ABYSSAL_STONE)), ACBlocks.coralium_fire.func_176223_P());
                        }
                        if (player.field_71093_bK == ACLib.dreadlands_id && player.func_70093_af() || player.field_71093_bK == ACLib.abyssal_wasteland_id || o == 1) {
                            return this.buildPortal(world, pos, direction, ACBlocks.stone.func_176223_P().func_177226_a(BlockACStone.TYPE, (Comparable)((Object)BlockACStone.EnumStoneType.DREADSTONE)), ACBlocks.dreaded_fire.func_176223_P());
                        }
                        return this.buildPortal(world, pos, direction, ACBlocks.stone.func_176223_P().func_177226_a(BlockACStone.TYPE, (Comparable)((Object)BlockACStone.EnumStoneType.OMOTHOL_STONE)), ACBlocks.omothol_fire.func_176223_P());
                    }
                }
                return EnumActionResult.FAIL;
            }
        } else {
            if (this.dimWarning(player.field_71093_bK)) {
                FMLClientHandler.instance().getClient().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("message.portalplacer.error.2", new Object[0]));
                return EnumActionResult.FAIL;
            }
            if (!this.isCorrectDim(player.field_71093_bK)) {
                FMLClientHandler.instance().getClient().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("message.portalplacer.error.1", new Object[0]));
                return EnumActionResult.FAIL;
            }
        }
        return EnumActionResult.PASS;
    }

    private EnumActionResult buildPortal(World world, BlockPos pos, int direction, IBlockState frame, IBlockState fire) {
        if (direction == 1 || direction == 3) {
            boolean b = true;
            for (int z = -1; z < 3; ++z) {
                if (world.func_180495_p(pos.func_177982_a(0, 0, z)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177982_a(0, 0, z))) continue;
                b = false;
            }
            if (b) {
                pos = pos.func_177977_b();
            }
            for (int y = 1; y < 6; ++y) {
                for (int z = -1; z < 3; ++z) {
                    if (world.func_180495_p(pos.func_177982_a(0, y, z)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177982_a(0, y, z))) continue;
                    return EnumActionResult.FAIL;
                }
            }
            world.func_175656_a(pos.func_177982_a(0, 1, 0), frame);
            world.func_175656_a(pos.func_177982_a(0, 1, 1), frame);
            world.func_175656_a(pos.func_177982_a(0, 1, 2), frame);
            world.func_175656_a(pos.func_177982_a(0, 1, -1), frame);
            world.func_175656_a(pos.func_177982_a(0, 2, -1), frame);
            world.func_175656_a(pos.func_177982_a(0, 3, -1), frame);
            world.func_175656_a(pos.func_177982_a(0, 4, -1), frame);
            world.func_175656_a(pos.func_177982_a(0, 5, -1), frame);
            world.func_175656_a(pos.func_177982_a(0, 2, 2), frame);
            world.func_175656_a(pos.func_177982_a(0, 3, 2), frame);
            world.func_175656_a(pos.func_177982_a(0, 4, 2), frame);
            world.func_175656_a(pos.func_177982_a(0, 5, 2), frame);
            world.func_175656_a(pos.func_177982_a(0, 5, 0), frame);
            world.func_175656_a(pos.func_177982_a(0, 5, 1), frame);
            world.func_175656_a(pos.func_177982_a(0, 2, 1), fire);
            return EnumActionResult.SUCCESS;
        }
        boolean b = true;
        for (int x = -1; x < 3; ++x) {
            if (world.func_180495_p(pos.func_177982_a(x, 0, 0)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177982_a(x, 0, 0))) continue;
            b = false;
        }
        if (b) {
            pos = pos.func_177977_b();
        }
        for (int y = 1; y < 6; ++y) {
            for (int x = -1; x < 3; ++x) {
                if (world.func_180495_p(pos.func_177982_a(x, y, 0)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177982_a(x, y, 0))) continue;
                return EnumActionResult.FAIL;
            }
        }
        world.func_175656_a(pos.func_177982_a(0, 1, 0), frame);
        world.func_175656_a(pos.func_177982_a(1, 1, 0), frame);
        world.func_175656_a(pos.func_177982_a(2, 1, 0), frame);
        world.func_175656_a(pos.func_177982_a(-1, 1, 0), frame);
        world.func_175656_a(pos.func_177982_a(-1, 2, 0), frame);
        world.func_175656_a(pos.func_177982_a(-1, 3, 0), frame);
        world.func_175656_a(pos.func_177982_a(-1, 4, 0), frame);
        world.func_175656_a(pos.func_177982_a(-1, 5, 0), frame);
        world.func_175656_a(pos.func_177982_a(2, 2, 0), frame);
        world.func_175656_a(pos.func_177982_a(2, 3, 0), frame);
        world.func_175656_a(pos.func_177982_a(2, 4, 0), frame);
        world.func_175656_a(pos.func_177982_a(2, 5, 0), frame);
        world.func_175656_a(pos.func_177982_a(0, 5, 0), frame);
        world.func_175656_a(pos.func_177982_a(1, 5, 0), frame);
        world.func_175656_a(pos.func_177982_a(1, 2, 0), fire);
        return EnumActionResult.SUCCESS;
    }
}

