/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.items;

import com.shinoow.abyssalcraft.AbyssalCraft;
import com.shinoow.abyssalcraft.api.energy.IEnergyTransporterItem;
import com.shinoow.abyssalcraft.api.energy.PEUtils;
import com.shinoow.abyssalcraft.api.energy.structure.StructureHandler;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.common.blocks.BlockRitualAltar;
import com.shinoow.abyssalcraft.common.items.ItemACBasic;
import com.shinoow.abyssalcraft.common.network.PacketDispatcher;
import com.shinoow.abyssalcraft.common.network.client.ShouldSyncMessage;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.ACSounds;
import com.shinoow.abyssalcraft.lib.util.RitualUtil;
import com.shinoow.abyssalcraft.lib.util.SpecialTextUtil;
import com.shinoow.abyssalcraft.lib.util.blocks.IRitualAltar;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemNecronomicon
extends ItemACBasic
implements IEnergyTransporterItem {
    private int bookType;

    public ItemNecronomicon(String par1, int type) {
        super(par1);
        this.func_77625_d(1);
        this.bookType = type;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs par2CreativeTab, NonNullList<ItemStack> par3List) {
        if (this.func_194125_a(par2CreativeTab)) {
            par3List.add((Object)new ItemStack((Item)this));
            ItemStack stack = new ItemStack((Item)this);
            this.addEnergy(stack, this.getMaxEnergy(stack));
            par3List.add((Object)stack);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World par2World, EntityPlayer par3EntityPlayer, EnumHand hand) {
        ItemStack stack = par3EntityPlayer.func_184586_b(hand);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("owner")) {
            stack.func_77978_p().func_74778_a("owner", par3EntityPlayer.func_70005_c_());
            if (!par3EntityPlayer.func_70093_af()) {
                if (!par2World.field_72995_K && ACConfig.syncDataOnBookOpening) {
                    PacketDispatcher.sendTo(new ShouldSyncMessage(par3EntityPlayer), (EntityPlayerMP)par3EntityPlayer);
                }
                par3EntityPlayer.openGui((Object)AbyssalCraft.instance, 33, par2World, 0, 0, 0);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        if (stack.func_77978_p().func_74779_i("owner").equals(par3EntityPlayer.func_70005_c_())) {
            if (!par3EntityPlayer.func_70093_af()) {
                if (!par2World.field_72995_K && ACConfig.syncDataOnBookOpening) {
                    PacketDispatcher.sendTo(new ShouldSyncMessage(par3EntityPlayer), (EntityPlayerMP)par3EntityPlayer);
                }
                par3EntityPlayer.openGui((Object)AbyssalCraft.instance, 33, par2World, 0, 0, 0);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        } else if (par2World.field_72995_K) {
            SpecialTextUtil.JzaharText(I18n.func_135052_a((String)"message.necronomicon.nope", (Object[])new Object[0]));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World w, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack is = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (!(w.func_180495_p(pos).func_177230_c() instanceof BlockRitualAltar)) {
                if (this.isOwner(player, is) && (RitualUtil.tryAltar(w, pos, this.bookType) || StructureHandler.instance().tryFormStructure(w, pos, this.bookType, player))) {
                    w.func_184133_a(player, pos, ACSounds.remnant_scream, player.func_184176_by(), 3.0f, 1.0f);
                    return EnumActionResult.SUCCESS;
                }
            } else if (w.func_175625_s(pos) instanceof IRitualAltar && this.isOwner(player, is)) {
                IRitualAltar altar = (IRitualAltar)w.func_175625_s(pos);
                altar.performRitual(w, pos, player);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public boolean isOwner(EntityPlayer player, ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        return stack.func_77978_p().func_74779_i("owner").equals(player.func_70005_c_());
    }

    public void func_77624_a(ItemStack is, World player, List<String> l, ITooltipFlag B) {
        if (is.func_77942_o() && is.func_77978_p().func_74764_b("owner")) {
            l.add("Owner: " + is.func_77978_p().func_74779_i("owner"));
        }
    }

    public boolean func_77651_p() {
        return true;
    }

    public int getBookType() {
        return this.bookType;
    }

    @Override
    public float getContainedEnergy(ItemStack stack) {
        return PEUtils.getContainedEnergy(stack);
    }

    @Override
    public int getMaxEnergy(ItemStack stack) {
        if (this == ACItems.necronomicon) {
            return 5000;
        }
        if (this == ACItems.abyssal_wasteland_necronomicon) {
            return 10000;
        }
        if (this == ACItems.dreadlands_necronomicon) {
            return 20000;
        }
        if (this == ACItems.omothol_necronomicon) {
            return 40000;
        }
        if (this == ACItems.abyssalnomicon) {
            return 100000;
        }
        return 0;
    }

    @Override
    public void addEnergy(ItemStack stack, float energy) {
        PEUtils.addEnergy(this, stack, energy);
    }

    @Override
    public float consumeEnergy(ItemStack stack, float energy) {
        return PEUtils.consumeEnergy(stack, energy);
    }

    @Override
    public boolean canAcceptPE(ItemStack stack) {
        return this.getContainedEnergy(stack) < (float)this.getMaxEnergy(stack);
    }

    @Override
    public boolean canTransferPE(ItemStack stack) {
        return this.getContainedEnergy(stack) > 0.0f;
    }

    @Override
    public boolean canAcceptPEExternally(ItemStack stack) {
        return this.getContainedEnergy(stack) < (float)this.getMaxEnergy(stack);
    }

    @Override
    public boolean canTransferPEExternally(ItemStack stack) {
        return this.getContainedEnergy(stack) > 0.0f;
    }
}

