/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.entity;

import com.github.alexthe666.iceandfire.entity.IBlacklistedFromStatues;
import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.api.entity.EntityUtil;
import com.shinoow.abyssalcraft.api.entity.IOmotholEntity;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.common.blocks.BlockACStone;
import com.shinoow.abyssalcraft.common.blocks.BlockShoggothOoze;
import com.shinoow.abyssalcraft.common.entity.EntityAbyssalZombie;
import com.shinoow.abyssalcraft.common.entity.EntityAcidProjectile;
import com.shinoow.abyssalcraft.common.entity.EntityDepthsGhoul;
import com.shinoow.abyssalcraft.common.entity.EntityDreadSpawn;
import com.shinoow.abyssalcraft.common.entity.EntityDreadguard;
import com.shinoow.abyssalcraft.common.entity.EntityDreadling;
import com.shinoow.abyssalcraft.common.entity.EntityGatekeeperMinion;
import com.shinoow.abyssalcraft.common.entity.EntityOmotholGhoul;
import com.shinoow.abyssalcraft.common.entity.EntityOmotholWarden;
import com.shinoow.abyssalcraft.common.entity.EntityRemnant;
import com.shinoow.abyssalcraft.common.entity.EntitySkeletonGoliath;
import com.shinoow.abyssalcraft.common.entity.ai.EntityAILesserShoggothAttackMelee;
import com.shinoow.abyssalcraft.common.entity.ai.EntityAILesserShoggothBuildMonolith;
import com.shinoow.abyssalcraft.common.entity.ai.EntityAIWorship;
import com.shinoow.abyssalcraft.common.entity.demon.EntityDemonPig;
import com.shinoow.abyssalcraft.common.items.armor.ItemEthaxiumArmor;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.ACLib;
import com.shinoow.abyssalcraft.lib.ACLoot;
import com.shinoow.abyssalcraft.lib.ACSounds;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="com.github.alexthe666.iceandfire.entity.IBlacklistedFromStatues", modid="iceandfire")
public class EntityLesserShoggoth
extends EntityMob
implements IOmotholEntity,
IEntityMultiPart,
IBlacklistedFromStatues {
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityLesserShoggoth.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> CHILD = EntityDataManager.func_187226_a(EntityLesserShoggoth.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityLesserShoggoth.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FOOD = EntityDataManager.func_187226_a(EntityLesserShoggoth.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final UUID babySpeedBoostUUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier babySpeedBoostModifier = new AttributeModifier(babySpeedBoostUUID, "Baby speed boost", 0.3, 1);
    private int monolithTimer;
    private float shoggothWidth = -1.0f;
    private float shoggothHeight;
    public boolean isBuilding;
    public boolean isAssisting;
    public MultiPartEntityPart[] shoggothParts;
    public MultiPartEntityPart shoggothHead;
    public MultiPartEntityPart shoggothBody;

    public EntityLesserShoggoth(World par1World) {
        super(par1World);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILesserShoggothAttackMelee(this, 0.35, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 0.35));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.35));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.35));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityDepthsGhoul.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityAbyssalZombie.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityZombie.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntitySkeleton.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntitySkeletonGoliath.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityDreadling.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityDreadSpawn.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityDemonPig.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityDreadguard.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityOmotholWarden.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityOmotholGhoul.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityRemnant.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLesserShoggoth.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityGatekeeperMinion.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILesserShoggothBuildMonolith(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWorship((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 20, true, false, entity -> EntityUtil.isShoggothFood((EntityLivingBase)entity)));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombie.class, 10, true, false, entity -> !(entity instanceof EntityZombieVillager)));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySkeleton.class, true, false));
        this.func_70105_a(1.8f, 2.6f);
        this.shoggothHead = new MultiPartEntityPart((IEntityMultiPart)this, "head", 1.0f, 1.0f);
        this.shoggothBody = new MultiPartEntityPart((IEntityMultiPart)this, "body", 1.0f, 1.0f);
        this.shoggothParts = new MultiPartEntityPart[]{this.shoggothHead, this.shoggothBody};
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ACConfig.hardcoreMode ? 200.0 : 100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ACConfig.hardcoreMode ? 16.0 : 8.0);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CHILD, (Object)0);
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
        this.field_70180_af.func_187214_a(FOOD, (Object)0);
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    public boolean func_70631_g_() {
        return (Byte)this.field_70180_af.func_187225_a(CHILD) == 1;
    }

    public void setChild(boolean par1) {
        this.field_70180_af.func_187227_b(CHILD, (Object)((byte)(par1 ? 1 : 0)));
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            IAttributeInstance attributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            attributeinstance.func_111124_b(babySpeedBoostModifier);
            if (par1) {
                attributeinstance.func_111121_a(babySpeedBoostModifier);
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ACConfig.hardcoreMode ? 100.0 : 50.0);
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ACConfig.hardcoreMode ? 8.0 : 4.0);
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ACConfig.hardcoreMode ? 200.0 : 100.0);
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ACConfig.hardcoreMode ? 16.0 : 8.0);
                this.func_70606_j(ACConfig.hardcoreMode ? 200.0f : 100.0f);
            }
        }
        this.setChildSize(par1);
    }

    public int getShoggothType() {
        return (Integer)this.field_70180_af.func_187225_a(TYPE);
    }

    public void setShoggothType(int par1) {
        this.field_70180_af.func_187227_b(TYPE, (Object)par1);
    }

    public void setFoodLevel(int par1) {
        this.field_70180_af.func_187227_b(FOOD, (Object)par1);
    }

    public int getFoodLevel() {
        return (Integer)this.field_70180_af.func_187225_a(FOOD);
    }

    public void feed(EntityLivingBase entity) {
        int food = this.getFoodLevel() + this.getPointsFromSize(entity.field_70131_O * entity.field_70130_N);
        this.field_70180_af.func_187227_b(FOOD, (Object)food);
        this.func_184185_a(SoundEvents.field_187739_dZ, this.func_70599_aP(), this.func_70647_i());
    }

    private int getPointsFromSize(float size) {
        int food = 0;
        float sizeNum = size;
        while (sizeNum > 0.0f) {
            ++food;
            sizeNum = (float)((double)sizeNum - 0.25);
        }
        return food;
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void reduceMonolithTimer() {
        this.monolithTimer = this.monolithTimer - 200 >= 200 ? (this.monolithTimer -= 200) : 0;
    }

    public void resetMonolithTimer() {
        this.monolithTimer = 0;
    }

    public int getMonolithTimer() {
        return this.monolithTimer;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70090_H()) {
            this.field_70159_w += this.func_70040_Z().field_72450_a * 0.005;
            this.field_70181_x += this.func_70040_Z().field_72448_b * 0.005;
            this.field_70179_y += this.func_70040_Z().field_72449_c * 0.005;
        }
        if (this.field_70170_p.field_72995_K) {
            this.setChildSize(this.func_70631_g_());
        }
        if (!this.func_70631_g_()) {
            ++this.monolithTimer;
        }
        if (this.getFoodLevel() >= 8 && !this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0) {
            this.setFoodLevel(this.getFoodLevel() - 8);
            if (!this.func_70631_g_() && !this.field_70170_p.field_72995_K) {
                EntityLesserShoggoth shoggoth = new EntityLesserShoggoth(this.field_70170_p);
                shoggoth.func_82149_j((Entity)this);
                shoggoth.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v)), null);
                shoggoth.setChild(true);
                shoggoth.setShoggothType(this.getShoggothType());
                this.field_70170_p.func_72838_d((Entity)shoggoth);
                this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                if (this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.func_70681_au().nextInt(3) == 0) {
                    EntityLivingBase target = this.func_70638_az();
                    EntityAcidProjectile acidprojectile = new EntityAcidProjectile(this.field_70170_p, (EntityLivingBase)this);
                    double d0 = target.field_70165_t - this.field_70165_t;
                    double d1 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f - acidprojectile.field_70163_u;
                    double d2 = target.field_70161_v - this.field_70161_v;
                    float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
                    acidprojectile.func_70186_c(d0, d1 + (double)f1, d2, 0.8f, 8.0f);
                    shoggoth.func_184220_m((Entity)acidprojectile);
                    this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                    this.field_70170_p.func_72838_d((Entity)acidprojectile);
                }
            } else {
                this.setChild(false);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            for (int l = 0; l < 1; ++l) {
                int x = MathHelper.func_76128_c((double)(this.field_70165_t + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                int y = MathHelper.func_76128_c((double)this.field_70163_u);
                int z = MathHelper.func_76128_c((double)(this.field_70161_v + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f)));
                this.spawnOoze(x, y, z);
                if (this.func_70631_g_()) continue;
                this.spawnOoze(x - 1, y, z);
                this.spawnOoze(x, y, z - 1);
                this.spawnOoze(x - 1, y, z - 1);
            }
        }
        if (this.field_70173_aa % 40 == 0 && ACConfig.consumeItems && !this.field_70170_p.field_72995_K) {
            for (EntityItem entity : this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ())) {
                if (entity.func_92059_d().func_77973_b() instanceof ItemFood) {
                    int food = this.getFoodLevel() + entity.func_92059_d().func_190916_E();
                    this.field_70180_af.func_187227_b(FOOD, (Object)food);
                    this.func_184185_a(SoundEvents.field_187739_dZ, this.func_70599_aP(), this.func_70647_i());
                } else {
                    this.func_184185_a(SoundEvents.field_187635_cQ, this.func_70599_aP(), 1.0f);
                }
                this.field_70170_p.func_72900_e((Entity)entity);
            }
        }
        int i = 0;
        while ((float)i < 2.0f * this.func_70013_c() && this.getShoggothType() == 4 && ACConfig.particleEntity && this.field_70170_p.field_73011_w.getDimension() != ACLib.dark_realm_id) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            ++i;
        }
        double a = Math.toRadians(this.field_70177_z);
        double offsetx = -Math.sin(a);
        double offsetz = Math.cos(a);
        if (!this.func_70631_g_()) {
            this.shoggothBody.field_70131_O = 2.2f;
            this.shoggothBody.field_70130_N = 1.8f;
            this.shoggothHead.field_70130_N = 1.6f;
            this.shoggothHead.field_70131_O = 1.2f;
            this.shoggothBody.func_70071_h_();
            this.shoggothBody.func_70012_b(this.field_70165_t - offsetx * 0.5, this.field_70163_u, this.field_70161_v - offsetz * 0.5, 0.0f, 0.0f);
            this.shoggothHead.func_70071_h_();
            this.shoggothHead.func_70012_b(this.field_70165_t - offsetx * -0.5, this.field_70163_u + 1.5, this.field_70161_v - offsetz * -0.5, 0.0f, 0.0f);
        } else {
            this.shoggothBody.field_70131_O = 1.1f;
            this.shoggothBody.field_70130_N = 0.9f;
            this.shoggothHead.field_70130_N = 0.8f;
            this.shoggothHead.field_70131_O = 0.6f;
            this.shoggothBody.func_70071_h_();
            this.shoggothBody.func_70012_b(this.field_70165_t - offsetx * 0.25, this.field_70163_u, this.field_70161_v - offsetz * 0.25, 0.0f, 0.0f);
            this.shoggothHead.func_70071_h_();
            this.shoggothHead.func_70012_b(this.field_70165_t - offsetx * -0.25, this.field_70163_u + 0.75, this.field_70161_v - offsetz * -0.25, 0.0f, 0.0f);
        }
    }

    private void spawnOoze(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        if (ACConfig.shoggothOoze) {
            if ((this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151579_a || this.field_70170_p.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, pos)) && ACBlocks.shoggoth_ooze.func_176196_c(this.field_70170_p, pos) && this.field_70170_p.func_180495_p(pos).func_177230_c() != ACBlocks.shoggoth_ooze && !this.field_70170_p.func_180495_p(pos).func_185904_a().func_76224_d()) {
                this.field_70170_p.func_175656_a(pos, ACBlocks.shoggoth_ooze.func_176223_P());
            } else if (this.field_70170_p.func_180495_p(pos).func_177230_c() == ACBlocks.shoggoth_ooze && (Integer)this.field_70170_p.func_180495_p(pos).func_177229_b((IProperty)BlockShoggothOoze.LAYERS) < 8 && this.field_70173_aa % 10 == 0 && this.field_70146_Z.nextInt(5) == 0) {
                IBlockState state = this.field_70170_p.func_180495_p(pos);
                this.field_70170_p.func_175656_a(pos, state.func_177226_a((IProperty)BlockShoggothOoze.LAYERS, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)BlockShoggothOoze.LAYERS) + 1)));
            }
        }
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean par1) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = par1 ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public boolean func_70652_k(Entity par1Entity) {
        boolean flag = super.func_70652_k(par1Entity);
        if (flag && par1Entity instanceof EntityLivingBase) {
            switch (this.getShoggothType()) {
                case 1: {
                    if (EntityUtil.isEntityCoralium((EntityLivingBase)par1Entity)) break;
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(AbyssalCraftAPI.coralium_plague, 100));
                    break;
                }
                case 2: {
                    if (EntityUtil.isEntityDread((EntityLivingBase)par1Entity)) break;
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(AbyssalCraftAPI.dread_plague, 100));
                    break;
                }
                case 3: {
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100));
                    break;
                }
                case 4: {
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100));
                }
            }
        }
        if (ACConfig.hardcoreMode && par1Entity instanceof EntityPlayer) {
            par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76348_h().func_151518_m(), 3.0f * (float)(ACConfig.damageAmpl > 1.0 ? ACConfig.damageAmpl : 1.0));
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource.func_76352_a() && !ACConfig.no_projectile_damage_immunity) {
            this.func_184185_a(SoundEvents.field_187882_fq, this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            return false;
        }
        if (par1DamageSource == DamageSource.field_76368_d) {
            if (this.field_70170_p.func_180495_p(this.func_180425_c()) != ACBlocks.stone.func_176223_P().func_177226_a(BlockACStone.TYPE, (Comparable)((Object)BlockACStone.EnumStoneType.MONOLITH_STONE)) && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                this.sprayAcid(true);
            } else {
                return false;
            }
        }
        if (par1DamageSource == DamageSource.field_76367_g) {
            return false;
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    public void func_180430_e(float par1, float par2) {
    }

    protected SoundEvent func_184639_G() {
        return ACSounds.shoggoth_ambient;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ACSounds.shoggoth_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return ACSounds.shoggoth_death;
    }

    protected void func_180429_a(BlockPos pos, Block par4) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    protected void func_70628_a(boolean par1, int par2) {
        ItemStack item = new ItemStack(ACItems.shoggoth_flesh, 1, this.getShoggothType());
        if (item != null) {
            int i = this.field_70146_Z.nextInt(3);
            if (par2 > 0) {
                i += this.field_70146_Z.nextInt(par2 + 1);
            }
            for (int j = 0; j < i; ++j) {
                this.func_70099_a(item, 0.0f);
            }
        }
    }

    protected ResourceLocation func_184647_J() {
        switch (this.getShoggothType()) {
            case 0: {
                return ACLoot.ENTITY_LESSER_SHOGGOTH;
            }
            case 1: {
                return ACLoot.ENTITY_LESSER_ABYSSAL_SHOGGOTH;
            }
            case 2: {
                return ACLoot.ENTITY_LESSER_DREADED_SHOGGOTH;
            }
            case 3: {
                return ACLoot.ENTITY_LESSER_OMOTHOL_SHOGGOTH;
            }
            case 4: {
                return ACLoot.ENTITY_LESSER_SHADOW_SHOGGOTH;
            }
        }
        return null;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return this.getShoggothType() == 4 ? AbyssalCraftAPI.SHADOW : EnumCreatureAttribute.UNDEFINED;
    }

    public void sprayAcidAt(Entity target) {
        EntityAcidProjectile acidprojectile = new EntityAcidProjectile(this.field_70170_p, (EntityLivingBase)this);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f - acidprojectile.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
        acidprojectile.func_70186_c(d0, d1 + (double)f1, d2, 1.0f, 12.0f);
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)acidprojectile);
    }

    public void sprayAcid(boolean above) {
        AxisAlignedBB aabb = this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0);
        this.field_70170_p.func_72960_a((Entity)this, (byte)23);
        for (EntityLivingBase entity : this.field_70170_p.func_175647_a(EntityLivingBase.class, aabb, e -> !(e instanceof EntityLesserShoggoth))) {
            if (!EntityUtil.canEntityBlockDamageSource(DamageSource.func_76358_a((EntityLivingBase)this), entity) || !ACConfig.shieldsBlockAcid) {
                if (!entity.func_70097_a(AbyssalCraftAPI.acid, (float)(4.5 - (double)this.func_70032_d((Entity)entity)))) continue;
                for (ItemStack armor : entity.func_184193_aE()) {
                    if (armor.func_77973_b() instanceof ItemEthaxiumArmor) continue;
                    armor.func_77972_a(this.func_70631_g_() ? 4 : 8, entity);
                }
                continue;
            }
            if (!EntityUtil.damageShield(entity, this.func_70631_g_() ? 6 : 12)) continue;
            entity.func_70097_a(AbyssalCraftAPI.acid, 1.0f);
        }
        int i = (int)aabb.field_72340_a;
        while ((double)i < aabb.field_72336_d + 1.0) {
            int j = (int)aabb.field_72339_c;
            while ((double)j < aabb.field_72334_f + 1.0) {
                int k = 0;
                while (above ? k < 2 : k > -2) {
                    BlockPos pos = new BlockPos((double)i, above ? aabb.field_72337_e : aabb.field_72338_b, (double)j);
                    if (!this.field_70170_p.func_175623_d(pos) && (double)this.field_70170_p.func_180495_p(pos).func_185887_b(this.field_70170_p, pos) < ACConfig.acidResistanceHardness && this.field_70170_p.func_180495_p(pos) != ACBlocks.stone.func_176223_P().func_177226_a(BlockACStone.TYPE, (Comparable)((Object)BlockACStone.EnumStoneType.MONOLITH_STONE)) && this.field_70170_p.func_180495_p(pos).func_177230_c() != ACBlocks.shoggoth_biomass && !this.field_70170_p.func_180495_p(pos).func_177230_c().hasTileEntity(this.field_70170_p.func_180495_p(pos)) && this.field_70170_p.func_180495_p(pos).func_185887_b(this.field_70170_p, pos) != -1.0f && this.field_70170_p.func_180495_p(pos).func_177230_c().canEntityDestroy(this.field_70170_p.func_180495_p(pos), (IBlockAccess)this.field_70170_p, pos, (Entity)this)) {
                        this.field_70170_p.func_175655_b(pos, false);
                    }
                    k = above ? k + 1 : k - 1;
                }
                ++j;
            }
            ++i;
        }
    }

    protected void addAcidParticles() {
        if (this.field_70170_p.field_72995_K) {
            AxisAlignedBB aabb = this.func_174813_aQ();
            Vec3d vector = this.func_70040_Z();
            int i = (int)aabb.field_72340_a;
            while ((double)i < aabb.field_72336_d + 1.0) {
                int j = (int)aabb.field_72338_b;
                while ((double)j < aabb.field_72337_e + 1.0) {
                    int k = (int)aabb.field_72339_c;
                    while ((double)k < aabb.field_72334_f + 1.0) {
                        double dx = vector.field_72450_a;
                        double dy = vector.field_72448_b;
                        double dz = vector.field_72449_c;
                        double spread = 5.0 + this.func_70681_au().nextDouble() * 2.5;
                        double velocity = 0.5 + this.func_70681_au().nextDouble() * 0.5;
                        dx += this.func_70681_au().nextGaussian() * (double)0.0075f * spread;
                        dy += this.func_70681_au().nextGaussian() * (double)0.0075f * spread;
                        dz += this.func_70681_au().nextGaussian() * (double)0.0075f * spread;
                        this.field_70170_p.func_175688_a(EnumParticleTypes.SLIME, (double)i, (double)j, (double)k, dx *= velocity, dy *= velocity, dz *= velocity, new int[0]);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)23);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 23) {
            this.addAcidParticles();
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        byte var2;
        super.func_70037_a(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74767_n("IsBaby")) {
            this.setChild(true);
        }
        if (par1NBTTagCompound.func_74764_b("ShoggothType")) {
            var2 = par1NBTTagCompound.func_74771_c("ShoggothType");
            this.setShoggothType(var2);
        }
        if (par1NBTTagCompound.func_74764_b("FoodLevel")) {
            var2 = par1NBTTagCompound.func_74771_c("FoodLevel");
            this.setFoodLevel(var2);
        }
        this.monolithTimer = par1NBTTagCompound.func_74762_e("MonolithTimer");
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        if (this.func_70631_g_()) {
            par1NBTTagCompound.func_74757_a("IsBaby", true);
        }
        par1NBTTagCompound.func_74774_a("ShoggothType", (byte)this.getShoggothType());
        par1NBTTagCompound.func_74774_a("FoodLevel", (byte)this.getFoodLevel());
        par1NBTTagCompound.func_74768_a("MonolithTimer", this.monolithTimer);
    }

    public void func_70074_a(EntityLivingBase par1EntityLivingBase) {
        super.func_70074_a(par1EntityLivingBase);
        if (EntityUtil.isShoggothFood(par1EntityLivingBase)) {
            this.feed(par1EntityLivingBase);
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData par1EntityLivingData) {
        IEntityLivingData data = super.func_180482_a(difficulty, par1EntityLivingData);
        this.setShoggothType(0);
        if (this.field_70170_p.field_73011_w.getDimension() == ACLib.abyssal_wasteland_id) {
            this.setShoggothType(1);
        }
        if (this.field_70170_p.field_73011_w.getDimension() == ACLib.dreadlands_id) {
            this.setShoggothType(2);
        }
        if (this.field_70170_p.field_73011_w.getDimension() == ACLib.omothol_id) {
            this.setShoggothType(3);
        }
        if (this.field_70170_p.field_73011_w.getDimension() == ACLib.dark_realm_id) {
            this.setShoggothType(4);
        }
        if (data == null) {
            data = new GroupData(this.field_70170_p.field_73012_v.nextFloat() < ForgeModContainer.zombieBabyChance, null);
        }
        if (data instanceof GroupData) {
            GroupData groupdata = (GroupData)data;
            if (groupdata.isBaby) {
                this.setChild(true);
            }
        }
        return data;
    }

    public void setChildSize(boolean p_146071_1_) {
        this.multiplySize(p_146071_1_ ? 0.5f : 1.0f);
    }

    protected final void func_70105_a(float p_70105_1_, float p_70105_2_) {
        boolean flag = this.shoggothWidth > 0.0f && this.shoggothHeight > 0.0f;
        this.shoggothWidth = p_70105_1_;
        this.shoggothHeight = p_70105_2_;
        if (!flag) {
            this.multiplySize(1.0f);
        }
    }

    protected final void multiplySize(float p_146069_1_) {
        super.func_70105_a(this.shoggothWidth * p_146069_1_, this.shoggothHeight * p_146069_1_);
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float damage) {
        return this.func_70097_a(source, damage);
    }

    public Entity[] func_70021_al() {
        return this.shoggothParts;
    }

    public boolean canBeTurnedToStone() {
        return false;
    }

    class GroupData
    implements IEntityLivingData {
        public boolean isBaby = false;

        private GroupData(boolean par2) {
            this.isBaby = par2;
        }

        GroupData(boolean par2, Object par4EntityLesserShoggothINNER1) {
            this(par2);
        }
    }
}

