/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks.tile;

import com.shinoow.abyssalcraft.api.energy.EnergyEnum;
import com.shinoow.abyssalcraft.api.energy.IEnergyManipulator;
import com.shinoow.abyssalcraft.api.energy.IEnergyTransporterItem;
import com.shinoow.abyssalcraft.api.energy.PEUtils;
import com.shinoow.abyssalcraft.api.energy.disruption.DisruptionHandler;
import com.shinoow.abyssalcraft.api.energy.structure.IStructureComponent;
import com.shinoow.abyssalcraft.api.entity.EntityUtil;
import com.shinoow.abyssalcraft.common.blocks.BlockStatue;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.ACLib;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;

public class TileEntityStatue
extends TileEntity
implements IEnergyManipulator,
ITickable,
IStructureComponent {
    private int timer;
    private final int timerMax = 120;
    private int activationTimer;
    private EnergyEnum.AmplifierType currentAmplifier;
    private EnergyEnum.DeityType currentDeity;
    private int tolerance;
    private int facing;
    private boolean isMultiblock;
    private BlockPos basePos;

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.timer = nbttagcompound.func_74762_e("Timer");
        this.activationTimer = nbttagcompound.func_74762_e("ActivationTimer");
        this.tolerance = nbttagcompound.func_74762_e("Tolerance");
        PEUtils.readManipulatorNBT(this, nbttagcompound);
        this.facing = nbttagcompound.func_74762_e("Facing");
        this.isMultiblock = nbttagcompound.func_74767_n("IsMultiblock");
        this.basePos = BlockPos.func_177969_a((long)nbttagcompound.func_74763_f("BasePosition"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("Timer", this.timer);
        nbttagcompound.func_74768_a("ActivationTimer", this.activationTimer);
        nbttagcompound.func_74768_a("Tolerance", this.tolerance);
        PEUtils.writeManipulatorNBT(this, nbttagcompound);
        nbttagcompound.func_74768_a("Facing", this.facing);
        nbttagcompound.func_74757_a("IsMultiblock", this.isMultiblock);
        if (this.basePos != null) {
            nbttagcompound.func_74772_a("BasePosition", this.basePos.func_177986_g());
        }
        return nbttagcompound;
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.field_175730_i.remove(this);
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    @Override
    public void setActive(EnergyEnum.AmplifierType amp, EnergyEnum.DeityType deity) {
        if (!this.isActive()) {
            this.activationTimer = 1200;
            this.setActiveDeity(deity);
            this.setActiveAmplifier(amp);
        }
    }

    @Override
    public boolean isActive() {
        return this.activationTimer > 0;
    }

    @Override
    public float getEnergyQuanta() {
        return this.isActive() ? 10.0f * (Math.max(this.getAmplifier(EnergyEnum.AmplifierType.POWER), 1.0f) + PEUtils.getStructureAmplifier(this.field_145850_b, this, EnergyEnum.AmplifierType.POWER)) : 5.0f;
    }

    @Override
    public EnergyEnum.DeityType getDeity(IBlockState state) {
        switch ((BlockStatue.EnumDeityType)((Object)state.func_177229_b(BlockStatue.TYPE))) {
            case AZATHOTH: {
                return EnergyEnum.DeityType.AZATHOTH;
            }
            case CTHULHU: {
                return EnergyEnum.DeityType.CTHULHU;
            }
            case HASTUR: {
                return EnergyEnum.DeityType.HASTUR;
            }
            case JZAHAR: {
                return EnergyEnum.DeityType.JZAHAR;
            }
            case NYARLATHOTEP: {
                return EnergyEnum.DeityType.NYARLATHOTEP;
            }
            case SHUBNIGGURATH: {
                return EnergyEnum.DeityType.SHUBNIGGURATH;
            }
            case YOGSOTHOTH: {
                return EnergyEnum.DeityType.YOGSOTHOTH;
            }
        }
        return null;
    }

    @Override
    public float getAmplifier(EnergyEnum.AmplifierType type) {
        if (type == this.currentAmplifier) {
            switch (type) {
                case DURATION: {
                    return this.currentDeity == this.getDeity(this.field_145850_b.func_180495_p(this.field_174879_c)) ? 4.0f : 2.0f;
                }
                case POWER: {
                    return this.currentDeity == this.getDeity(this.field_145850_b.func_180495_p(this.field_174879_c)) ? 2.5f : 1.5f;
                }
                case RANGE: {
                    return this.currentDeity == this.getDeity(this.field_145850_b.func_180495_p(this.field_174879_c)) ? 6.0f : 4.0f;
                }
            }
            return 0.0f;
        }
        return 0.0f;
    }

    @Override
    public EnergyEnum.DeityType getActiveDeity() {
        return this.currentDeity;
    }

    @Override
    public EnergyEnum.AmplifierType getActiveAmplifier() {
        return this.currentAmplifier;
    }

    @Override
    public void setActiveDeity(EnergyEnum.DeityType deity) {
        this.currentDeity = deity;
    }

    @Override
    public void setActiveAmplifier(EnergyEnum.AmplifierType amplifier) {
        this.currentAmplifier = amplifier;
    }

    @Override
    public void addTolerance(int num) {
        if (!this.isInMultiblock()) {
            this.tolerance += num;
        }
    }

    @Override
    public int getTolerance() {
        return this.tolerance;
    }

    @Override
    public boolean canTransferPE() {
        return true;
    }

    @Override
    public void disrupt() {
        this.tolerance = 0;
        if (this.field_145850_b.field_73011_w.getDimension() != ACLib.omothol_id && !this.isInMultiblock() && !ACConfig.no_disruptions) {
            this.field_145850_b.func_72942_c((Entity)new EntityLightningBolt(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), true));
            DisruptionHandler.instance().generateDisruption(this.getDeity(this.field_145850_b.func_180495_p(this.field_174879_c)), this.field_145850_b, this.field_174879_c, this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_174879_c).func_72314_b(16.0, 16.0, 16.0)));
        }
    }

    public void func_73660_a() {
        if (this.isActive()) {
            --this.activationTimer;
            ((WorldServer)this.field_145850_b).func_175739_a(EnumParticleTypes.PORTAL, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.9, (double)this.field_174879_c.func_177952_p() + 0.5, 0, 0.0, 0.0, 0.0, 1.0, new int[0]);
        } else {
            PEUtils.clearManipulatorData(this);
        }
        int range = (int)((float)(7 + PEUtils.getRangeAmplifiers(this.field_145850_b, this.field_174879_c, this) * 4) + this.getAmplifier(EnergyEnum.AmplifierType.RANGE));
        int xp = this.field_174879_c.func_177958_n();
        int yp = this.field_174879_c.func_177956_o();
        int zp = this.field_174879_c.func_177952_p();
        if ((this.field_145850_b.func_175710_j(this.field_174879_c) || this.isMultiblock) && (PEUtils.checkForAdjacentManipulators(this.field_145850_b, this.field_174879_c) || this.isMultiblock)) {
            if (this.field_145850_b.func_184137_a((double)xp, (double)yp, (double)zp, (double)range, false) != null && EntityUtil.hasNecronomicon(this.field_145850_b.func_184137_a((double)xp, (double)yp, (double)zp, (double)range, false))) {
                ItemStack item = this.field_145850_b.func_184137_a((double)xp, (double)yp, (double)zp, (double)range, false).func_184586_b(EnumHand.MAIN_HAND);
                ItemStack item1 = this.field_145850_b.func_184137_a((double)xp, (double)yp, (double)zp, (double)range, false).func_184586_b(EnumHand.OFF_HAND);
                if (!item.func_190926_b() && item.func_77973_b() instanceof IEnergyTransporterItem || !item1.func_190926_b() && item1.func_77973_b() instanceof IEnergyTransporterItem) {
                    ++this.timer;
                    if (this.timer >= (int)(120.0f / (Math.max(this.getAmplifier(EnergyEnum.AmplifierType.DURATION), 1.0f) + PEUtils.getStructureAmplifier(this.field_145850_b, this, EnergyEnum.AmplifierType.DURATION)))) {
                        this.timer = this.field_145850_b.field_73012_v.nextInt(10);
                        PEUtils.transferPEToNearbyPlayers(this.field_145850_b, this.field_174879_c, this, range);
                    }
                }
            }
            PEUtils.transferPEToNearbyDroppedItems(this.field_145850_b, this.field_174879_c, this, range);
            PEUtils.transferPEToCollectors(this.field_145850_b, this.field_174879_c, this, (int)((float)PEUtils.getRangeAmplifiers(this.field_145850_b, this.field_174879_c, this) + this.getAmplifier(EnergyEnum.AmplifierType.RANGE) / 2.0f));
        }
        if (this.tolerance >= 100) {
            this.disrupt();
        }
    }

    public int getFacing() {
        return this.facing;
    }

    public void setFacing(int face) {
        this.facing = face;
    }

    @Override
    public boolean isInMultiblock() {
        return this.isMultiblock;
    }

    @Override
    public void setInMultiblock(boolean bool) {
        this.isMultiblock = bool;
    }

    @Override
    public BlockPos getBasePosition() {
        return this.basePos;
    }

    @Override
    public void setBasePosition(BlockPos pos) {
        this.basePos = pos;
    }
}

