/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.spell;

import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.spell.IScroll;
import com.shinoow.abyssalcraft.api.spell.Spell;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpellRegistry {
    private final List<Spell> spells = new ArrayList<Spell>();
    private final Logger logger = LogManager.getLogger((String)"SpellRegistry");
    private static final SpellRegistry instance = new SpellRegistry();

    public static SpellRegistry instance() {
        return instance;
    }

    private SpellRegistry() {
    }

    public void registerSpell(Spell spell) {
        if (spell.getBookType() <= 4 && spell.getBookType() >= 0) {
            for (Spell entry : this.spells) {
                if (!spell.getUnlocalizedName().equals(entry.getUnlocalizedName())) continue;
                this.logger.log(Level.ERROR, "Necronomicon Spell already registered: {}", (Object)spell.getUnlocalizedName());
                return;
            }
            this.spells.add(spell);
        } else {
            this.logger.log(Level.ERROR, "Necronomicon book type does not exist: {}", (Object)spell.getBookType());
        }
    }

    public List<Spell> getSpells() {
        return this.spells;
    }

    public Spell getSpell(int bookType, ItemStack parchment, ItemStack[] reagents) {
        for (Spell spell : this.spells) {
            if (!this.areSpellsEqual(spell, bookType, parchment, reagents)) continue;
            return spell;
        }
        return null;
    }

    public Spell getSpell(String name) {
        for (Spell spell : this.spells) {
            if (!spell.getUnlocalizedName().equals(name)) continue;
            return spell;
        }
        return null;
    }

    private boolean areSpellsEqual(Spell spell, int bookType, ItemStack parchment, ItemStack[] reagents) {
        if (spell.getBookType() <= bookType && APIUtils.areItemStackArraysEqual(spell.getReagents(), reagents, spell.isNBTSensitive()) && (spell.getParent() == null && (!parchment.func_77942_o() || !parchment.func_77978_p().func_74764_b("Spell")) || spell.getParent() != null && spell.getParent().getUnlocalizedName().equals(parchment.func_77978_p().func_74779_i("Spell"))) && (spell.getParchment().func_190926_b() || APIUtils.areStacksEqual(parchment, spell.getParchment()))) {
            return parchment.func_77973_b() instanceof IScroll && ((IScroll)parchment.func_77973_b()).getScrollType(parchment).getQuality() >= spell.getScrollType().getQuality();
        }
        return false;
    }

    public ItemStack inscribeSpell(Spell spell, ItemStack parchment) {
        if (spell != null) {
            if (!parchment.func_77942_o()) {
                parchment.func_77982_d(new NBTTagCompound());
            }
            parchment.func_77978_p().func_74778_a("Spell", spell.getUnlocalizedName());
            return parchment;
        }
        return ItemStack.field_190927_a;
    }
}

