/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.item.ICrystal;
import com.shinoow.abyssalcraft.api.item.IUnlockableItem;
import com.shinoow.abyssalcraft.api.necronomicon.condition.caps.INecroDataCapability;
import com.shinoow.abyssalcraft.api.necronomicon.condition.caps.NecroDataCapability;
import com.shinoow.abyssalcraft.api.recipe.EngraverRecipes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class APIUtils {
    public static boolean display_names;

    public static boolean isCrystal(ItemStack item) {
        if (item.func_77973_b() instanceof ICrystal) {
            return true;
        }
        for (ItemStack crystal : AbyssalCraftAPI.getCrystals()) {
            if (crystal.func_77973_b() != item.func_77973_b() || crystal.func_77952_i() != Short.MAX_VALUE && crystal.func_77952_i() != item.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    public static boolean isCoin(ItemStack item) {
        for (ItemStack coin : EngraverRecipes.instance().getCoinList()) {
            if (coin.func_77973_b() != item.func_77973_b() || coin.func_77952_i() != Short.MAX_VALUE && coin.func_77952_i() != item.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    public static ItemStack convertToStack(Object obj) {
        if (obj == null) {
            return ItemStack.field_190927_a;
        }
        if (obj instanceof ItemStack) {
            return ((ItemStack)obj).func_77946_l();
        }
        if (obj instanceof Item) {
            return new ItemStack((Item)obj);
        }
        if (obj instanceof Block) {
            return new ItemStack((Block)obj);
        }
        if (obj instanceof Ingredient) {
            return ((Ingredient)obj).func_193365_a().length > 0 ? ((Ingredient)obj).func_193365_a()[0].func_77946_l() : ItemStack.field_190927_a;
        }
        if (obj instanceof ItemStack[]) {
            return ((ItemStack[])obj)[0].func_77946_l();
        }
        if (obj instanceof String) {
            return ((ItemStack)OreDictionary.getOres((String)((String)obj)).get(0)).func_77946_l();
        }
        if (obj instanceof List) {
            return ((ItemStack)((List)obj).get(0)).func_77946_l();
        }
        throw new ClassCastException("Not a Item, Block, ItemStack, Ingredient, Array of ItemStacks, String or List of ItemStacks!");
    }

    public static boolean areItemStackArraysEqual(Object[] array1, ItemStack[] array2, boolean nbt) {
        List<Object> compareList = APIUtils.nonNullList(array1);
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        for (ItemStack item : array2) {
            if (item.func_190926_b()) continue;
            itemList.add(item);
        }
        if (itemList.size() == compareList.size()) {
            block1: for (ItemStack item : itemList) {
                for (Object compare : compareList) {
                    if (!APIUtils.areObjectsEqual(item, compare, nbt)) continue;
                    compareList.remove(compare);
                    continue block1;
                }
            }
        }
        return compareList.isEmpty();
    }

    private static List<Object> nonNullList(Object[] array) {
        ArrayList<Object> l = new ArrayList<Object>();
        for (Object o : array) {
            if (o == null) continue;
            l.add(o);
        }
        return l;
    }

    public static boolean areObjectsEqual(ItemStack stack, Object obj, boolean nbt) {
        block7: {
            block8: {
                block6: {
                    if (obj instanceof ItemStack) {
                        return APIUtils.areStacksEqual(stack, (ItemStack)obj, nbt);
                    }
                    if (obj instanceof Item) {
                        return APIUtils.areStacksEqual(stack, new ItemStack((Item)obj), nbt);
                    }
                    if (obj instanceof Block) {
                        return APIUtils.areStacksEqual(stack, new ItemStack((Block)obj), nbt);
                    }
                    if (!(obj instanceof ItemStack[])) break block6;
                    for (ItemStack item : (ItemStack[])obj) {
                        if (!APIUtils.areStacksEqual(stack, item, nbt)) continue;
                        return true;
                    }
                    break block7;
                }
                if (!(obj instanceof String)) break block8;
                for (ItemStack item : OreDictionary.getOres((String)((String)obj))) {
                    if (!APIUtils.areStacksEqual(stack, item, nbt)) continue;
                    return true;
                }
                break block7;
            }
            if (!(obj instanceof List)) break block7;
            for (ItemStack item : (List)obj) {
                if (!APIUtils.areStacksEqual(stack, item, nbt)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2, boolean nbt) {
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return false;
        }
        return nbt ? APIUtils.areStacksEqual(stack1, stack2) && APIUtils.areItemStackTagsEqual(stack2, stack1, 0) : APIUtils.areStacksEqual(stack1, stack2);
    }

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return false;
        }
        return stack1.func_77973_b() == stack2.func_77973_b() && (stack2.func_77952_i() == Short.MAX_VALUE || stack1.func_77952_i() == stack2.func_77952_i());
    }

    @SideOnly(value=Side.CLIENT)
    public static FontRenderer getFontRenderer(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof IUnlockableItem) || display_names) {
            return null;
        }
        INecroDataCapability cap = NecroDataCapability.getCap((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        return cap.isUnlocked(((IUnlockableItem)stack.func_77973_b()).getUnlockCondition(stack), (EntityPlayer)Minecraft.func_71410_x().field_71439_g) ? null : AbyssalCraftAPI.getAkloFont();
    }

    public static boolean areItemStackTagsEqual(ItemStack stackA, ItemStack stackB, int strictness) {
        switch (strictness) {
            case 0: {
                if (stackA.func_190926_b() && stackB.func_190926_b()) {
                    return true;
                }
                if (!stackA.func_190926_b() && !stackB.func_190926_b()) {
                    if (stackA.func_77978_p() == null) {
                        return true;
                    }
                    if (stackB.func_77978_p() == null) {
                        return false;
                    }
                    return APIUtils.compoundContainsCompound(stackA.func_77978_p().func_74737_b(), stackB.func_77978_p().func_74737_b());
                }
                return false;
            }
            case 1: {
                if (stackA.func_190926_b() && stackB.func_190926_b()) {
                    return true;
                }
                if (!stackA.func_190926_b() && !stackB.func_190926_b()) {
                    if (stackA.func_77978_p() == null && stackB.func_77978_p() != null) {
                        return false;
                    }
                    return stackA.func_77978_p() == null || stackA.func_77978_p().equals((Object)stackB.func_77978_p());
                }
                return false;
            }
            case 2: {
                return ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
            }
        }
        return false;
    }

    private static boolean compoundContainsCompound(NBTTagCompound tag, NBTTagCompound tag1) {
        for (String s : tag.func_150296_c()) {
            NBTBase nbtbase = tag.func_74781_a(s);
            if (nbtbase.func_74732_a() == 10) {
                if (tag1.func_150297_b(s, 10)) {
                    NBTTagCompound nbttagcompound = tag1.func_74775_l(s);
                    if (APIUtils.compoundContainsCompound((NBTTagCompound)nbtbase, nbttagcompound)) continue;
                    return false;
                }
                return false;
            }
            if (!tag1.func_74764_b(s) || tag1.func_74781_a(s).equals((Object)nbtbase)) continue;
            return false;
        }
        return true;
    }
}

