/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler.capability.wrappers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.ISpellContainer;
import vazkii.psi.api.spell.ISpellSettable;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;

public class AcceptorWrapper
implements ISpellAcceptor,
ICapabilityProvider {
    private final ItemStack stack;
    private final ISpellSettable item;
    private final ISpellContainer container;

    public AcceptorWrapper(ItemStack stack) {
        this.stack = stack;
        this.item = (ISpellSettable)stack.func_77973_b();
        this.container = this.item instanceof ISpellContainer ? (ISpellContainer)this.item : null;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CAPABILITY ? CAPABILITY.cast((Object)this) : null);
    }

    @Override
    public void setSpell(EntityPlayer player, Spell spell) {
        this.item.setSpell(player, this.stack, spell);
    }

    @Override
    public boolean castableFromSocket() {
        return this.container != null;
    }

    @Override
    @Nullable
    public Spell getSpell() {
        return this.container != null ? this.container.getSpell(this.stack) : null;
    }

    @Override
    public boolean containsSpell() {
        return this.container != null && this.container.containsSpell(this.stack);
    }

    @Override
    public void castSpell(SpellContext context) {
        if (this.container != null) {
            this.container.castSpell(this.stack, context);
        }
    }

    @Override
    public double getCostModifier() {
        return this.container != null ? this.container.getCostModifier(this.stack) : 1.0;
    }

    @Override
    public boolean isCADOnlyContainer() {
        return this.container != null && this.container.isCADOnlyContainer(this.stack);
    }
}

