/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block.tile;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import vazkii.arl.block.tile.TileSimpleInventory;
import vazkii.psi.api.cad.AssembleCADEvent;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.ICADComponent;
import vazkii.psi.api.cad.ISocketableCapability;
import vazkii.psi.api.cad.ITileCADAssembler;
import vazkii.psi.api.cad.PostCADCraftEvent;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.item.ItemCAD;

public class TileCADAssembler
extends TileSimpleInventory
implements ITileCADAssembler {
    private transient ItemStack cachedCAD;

    public void inventoryChanged(int i) {
        if (0 < i && i < 6) {
            this.clearCachedCAD();
        }
    }

    @Override
    public void clearCachedCAD() {
        this.cachedCAD = null;
    }

    @Override
    public ItemStack getCachedCAD(EntityPlayer player) {
        ItemStack cad = this.cachedCAD;
        if (cad == null) {
            ItemStack assembly = this.getStackForComponent(EnumCADComponent.ASSEMBLY);
            cad = !assembly.func_190926_b() ? ItemCAD.makeCADWithAssembly(assembly, this.inventorySlots.subList(1, 6)) : ItemStack.field_190927_a;
            AssembleCADEvent assembling = new AssembleCADEvent(cad, this, player);
            MinecraftForge.EVENT_BUS.post((Event)assembling);
            cad = assembling.isCanceled() ? ItemStack.field_190927_a : assembling.getCad();
            this.cachedCAD = cad;
        }
        return cad;
    }

    @Override
    public int getComponentSlot(EnumCADComponent componentType) {
        return componentType.ordinal() + 1;
    }

    @Override
    public ItemStack getStackForComponent(EnumCADComponent componentType) {
        return this.func_70301_a(this.getComponentSlot(componentType));
    }

    @Override
    public boolean setStackForComponent(EnumCADComponent componentType, ItemStack component) {
        ICADComponent componentItem;
        int slot = this.getComponentSlot(componentType);
        if (component.func_190926_b()) {
            this.func_70299_a(slot, component);
            return true;
        }
        if (component.func_77973_b() instanceof ICADComponent && (componentItem = (ICADComponent)component.func_77973_b()).getComponentType(component) == componentType) {
            this.func_70299_a(slot, component);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getSocketableStack() {
        return this.func_70301_a(0);
    }

    @Override
    public ISocketableCapability getSocketable() {
        return ISocketableCapability.socketable(this.getSocketableStack());
    }

    @Override
    public boolean setSocketableStack(ItemStack stack) {
        if (stack.func_190926_b() || ISocketableCapability.isSocketable(stack)) {
            this.func_70299_a(0, stack);
            return true;
        }
        return false;
    }

    @Override
    public void onCraftCAD(ItemStack cad) {
        MinecraftForge.EVENT_BUS.post((Event)new PostCADCraftEvent(cad, this));
        for (int i = 1; i < 6; ++i) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, PsiSoundHandler.cadCreate, SoundCategory.BLOCKS, 0.5f, 1.0f);
        }
    }

    @Override
    public boolean isBulletSlotEnabled(int slot) {
        ISocketableCapability socketable = this.getSocketable();
        return socketable != null && socketable.isSocketSlotAvailable(slot);
    }

    public int func_70302_i_() {
        return 6;
    }

    @Nonnull
    public String func_70005_c_() {
        return "cad_assembler";
    }

    public boolean isAutomationEnabled() {
        return false;
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return true;
        }
        if (slot == 0) {
            return ISocketableCapability.isSocketable(stack);
        }
        if (slot < 6) {
            return stack.func_77973_b() instanceof ICADComponent && ((ICADComponent)stack.func_77973_b()).getComponentType(stack) == EnumCADComponent.values()[slot - 1];
        }
        return false;
    }

    public void writeSharedNBT(NBTTagCompound tag) {
        super.writeSharedNBT(tag);
        tag.func_74768_a("version", 1);
    }

    public void readSharedNBT(NBTTagCompound tag) {
        if (this.needsToSyncInventory() && tag.func_74762_e("version") < 1) {
            NBTTagList items = tag.func_150295_c("Items", 10);
            this.func_174888_l();
            ISocketableCapability socketable = null;
            for (int i = 0; i < items.func_74745_c(); ++i) {
                if (i == 0) continue;
                ItemStack stack = new ItemStack(items.func_150305_b(i));
                if (i == 6) {
                    this.setSocketableStack(stack);
                    if (stack.func_190926_b() || !ISocketableCapability.isSocketable(stack)) continue;
                    socketable = ISocketableCapability.socketable(stack);
                    continue;
                }
                if (i == 1) {
                    this.setStackForComponent(EnumCADComponent.CORE, stack);
                    continue;
                }
                if (i == 2) {
                    this.setStackForComponent(EnumCADComponent.ASSEMBLY, stack);
                    continue;
                }
                if (i == 3) {
                    this.setStackForComponent(EnumCADComponent.SOCKET, stack);
                    continue;
                }
                if (i == 4) {
                    this.setStackForComponent(EnumCADComponent.BATTERY, stack);
                    continue;
                }
                if (i == 5) {
                    this.setStackForComponent(EnumCADComponent.DYE, stack);
                    continue;
                }
                if (socketable == null) continue;
                socketable.setBulletInSocket(i - 7, stack);
            }
        } else {
            super.readSharedNBT(tag);
        }
    }
}

