/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.asm;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.api.food.FoodEvent;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.food.IEdible;
import squeek.applecore.api.food.ItemFoodProxy;
import squeek.applecore.api.hunger.ExhaustionEvent;
import squeek.applecore.api.hunger.HealthRegenEvent;
import squeek.applecore.api.hunger.HungerRegenEvent;
import squeek.applecore.api.hunger.StarvationEvent;
import squeek.applecore.asm.util.IAppleCoreFoodStats;

public class Hooks {
    private static void verifyFoodStats(FoodStats foodStats, EntityPlayer player) {
        if (!(foodStats instanceof IAppleCoreFoodStats)) {
            String playerName = player != null ? player.func_70005_c_() : "<unknown>";
            String className = foodStats.getClass().getName();
            throw new RuntimeException("FoodStats does not implement IAppleCoreFoodStats on player '" + playerName + "' (class = " + className + "). This likely means that AppleCore has failed catastrophically in some way.");
        }
        if (((IAppleCoreFoodStats)foodStats).getPlayer() == null) {
            if (player != null) {
                ((IAppleCoreFoodStats)foodStats).setPlayer(player);
                return;
            }
            String playerName = "<unknown>";
            String className = foodStats.getClass().getName();
            throw new RuntimeException("FoodStats has a null player field (this field is added by AppleCore at runtime) on player '" + playerName + "' (class = " + className + "). This likely means that some mod has overloaded FoodStats, which is incompatible with AppleCore.");
        }
    }

    public static boolean onAppleCoreFoodStatsUpdate(FoodStats foodStats, EntityPlayer player) {
        Event.Result allowStarvationResult;
        boolean shouldDoRegen;
        Hooks.verifyFoodStats(foodStats, player);
        IAppleCoreFoodStats appleCoreFoodStats = (IAppleCoreFoodStats)foodStats;
        appleCoreFoodStats.setPrevFoodLevel(foodStats.func_75116_a());
        Event.Result allowExhaustionResult = Hooks.fireAllowExhaustionEvent(player);
        float maxExhaustion = Hooks.fireExhaustionTickEvent(player, appleCoreFoodStats.getExhaustion());
        if (allowExhaustionResult == Event.Result.ALLOW || allowExhaustionResult == Event.Result.DEFAULT && appleCoreFoodStats.getExhaustion() >= maxExhaustion) {
            ExhaustionEvent.Exhausted exhaustedEvent = Hooks.fireExhaustionMaxEvent(player, maxExhaustion, appleCoreFoodStats.getExhaustion());
            appleCoreFoodStats.setExhaustion(appleCoreFoodStats.getExhaustion() + exhaustedEvent.deltaExhaustion);
            if (!exhaustedEvent.isCanceled()) {
                appleCoreFoodStats.setSaturation(Math.max(foodStats.func_75115_e() + exhaustedEvent.deltaSaturation, 0.0f));
                foodStats.func_75114_a(Math.max(foodStats.func_75116_a() + exhaustedEvent.deltaHunger, 0));
            }
        }
        boolean hasNaturalRegen = player.field_70170_p.func_82736_K().func_82766_b("naturalRegeneration");
        Event.Result allowSaturatedRegenResult = Hooks.fireAllowSaturatedRegenEvent(player);
        boolean shouldDoSaturatedRegen = allowSaturatedRegenResult == Event.Result.ALLOW || allowSaturatedRegenResult == Event.Result.DEFAULT && hasNaturalRegen && foodStats.func_75115_e() > 0.0f && player.func_70996_bM() && foodStats.func_75116_a() >= 20;
        Event.Result allowRegenResult = shouldDoSaturatedRegen ? Event.Result.DENY : Hooks.fireAllowRegenEvent(player);
        boolean bl = shouldDoRegen = allowRegenResult == Event.Result.ALLOW || allowRegenResult == Event.Result.DEFAULT && hasNaturalRegen && foodStats.func_75116_a() >= 18 && player.func_70996_bM();
        if (shouldDoSaturatedRegen) {
            appleCoreFoodStats.setFoodTimer(appleCoreFoodStats.getFoodTimer() + 1);
            if (appleCoreFoodStats.getFoodTimer() >= Hooks.fireSaturatedRegenTickEvent(player)) {
                HealthRegenEvent.SaturatedRegen saturatedRegenEvent = Hooks.fireSaturatedRegenEvent(player);
                if (!saturatedRegenEvent.isCanceled()) {
                    player.func_70691_i(saturatedRegenEvent.deltaHealth);
                    foodStats.func_75113_a(saturatedRegenEvent.deltaExhaustion);
                }
                appleCoreFoodStats.setFoodTimer(0);
            }
        } else if (shouldDoRegen) {
            appleCoreFoodStats.setFoodTimer(appleCoreFoodStats.getFoodTimer() + 1);
            if (appleCoreFoodStats.getFoodTimer() >= Hooks.fireRegenTickEvent(player)) {
                HealthRegenEvent.Regen regenEvent = Hooks.fireRegenEvent(player);
                if (!regenEvent.isCanceled()) {
                    player.func_70691_i(regenEvent.deltaHealth);
                    foodStats.func_75113_a(regenEvent.deltaExhaustion);
                }
                appleCoreFoodStats.setFoodTimer(0);
            }
        } else {
            appleCoreFoodStats.setFoodTimer(0);
        }
        if ((allowStarvationResult = Hooks.fireAllowStarvation(player)) == Event.Result.ALLOW || allowStarvationResult == Event.Result.DEFAULT && foodStats.func_75116_a() <= 0) {
            appleCoreFoodStats.setStarveTimer(appleCoreFoodStats.getStarveTimer() + 1);
            if (appleCoreFoodStats.getStarveTimer() >= Hooks.fireStarvationTickEvent(player)) {
                StarvationEvent.Starve starveEvent = Hooks.fireStarveEvent(player);
                if (!starveEvent.isCanceled()) {
                    player.func_70097_a(DamageSource.field_76366_f, starveEvent.starveDamage);
                }
                appleCoreFoodStats.setStarveTimer(0);
            }
        } else {
            appleCoreFoodStats.setStarveTimer(0);
        }
        return true;
    }

    public static FoodValues onFoodStatsAdded(FoodStats foodStats, @Nonnull ItemFood itemFood, @Nonnull ItemStack itemStack, EntityPlayer player) {
        Hooks.verifyFoodStats(foodStats, player);
        return AppleCoreAPI.accessor.getFoodValuesForPlayer(itemStack, player);
    }

    public static void onPostFoodStatsAdded(FoodStats foodStats, @Nonnull ItemFood itemFood, @Nonnull ItemStack itemStack, FoodValues foodValues, int hungerAdded, float saturationAdded, EntityPlayer player) {
        Hooks.verifyFoodStats(foodStats, player);
        MinecraftForge.EVENT_BUS.post((Event)new FoodEvent.FoodEaten(player, itemStack, foodValues, hungerAdded, saturationAdded));
    }

    public static int getItemInUseMaxCount(EntityLivingBase entityLiving, int savedMaxDuration) {
        EnumAction useAction = entityLiving.func_184607_cu().func_77975_n();
        if (useAction == EnumAction.EAT || useAction == EnumAction.DRINK) {
            return savedMaxDuration;
        }
        return entityLiving.func_184607_cu().func_77988_m();
    }

    public static void onBlockFoodEaten(Block block, World world, EntityPlayer player) {
        IEdible edibleBlock = (IEdible)block;
        ItemStack itemStack = new ItemStack(AppleCoreAPI.registry.getItemFromEdibleBlock(block));
        new ItemFoodProxy(edibleBlock).onEaten(itemStack, player);
    }

    public static Event.Result fireAllowExhaustionEvent(EntityPlayer player) {
        ExhaustionEvent.AllowExhaustion event = new ExhaustionEvent.AllowExhaustion(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getResult();
    }

    public static float fireExhaustionTickEvent(EntityPlayer player, float foodExhaustionLevel) {
        return AppleCoreAPI.accessor.getMaxExhaustion(player);
    }

    public static ExhaustionEvent.Exhausted fireExhaustionMaxEvent(EntityPlayer player, float maxExhaustionLevel, float foodExhaustionLevel) {
        ExhaustionEvent.Exhausted event = new ExhaustionEvent.Exhausted(player, maxExhaustionLevel, foodExhaustionLevel);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static Event.Result fireAllowRegenEvent(EntityPlayer player) {
        HealthRegenEvent.AllowRegen event = new HealthRegenEvent.AllowRegen(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getResult();
    }

    public static Event.Result fireAllowSaturatedRegenEvent(EntityPlayer player) {
        HealthRegenEvent.AllowSaturatedRegen event = new HealthRegenEvent.AllowSaturatedRegen(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getResult();
    }

    public static int fireRegenTickEvent(EntityPlayer player) {
        return AppleCoreAPI.accessor.getHealthRegenTickPeriod(player);
    }

    public static int fireSaturatedRegenTickEvent(EntityPlayer player) {
        return AppleCoreAPI.accessor.getSaturatedHealthRegenTickPeriod(player);
    }

    public static HealthRegenEvent.Regen fireRegenEvent(EntityPlayer player) {
        HealthRegenEvent.Regen event = new HealthRegenEvent.Regen(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static HealthRegenEvent.SaturatedRegen fireSaturatedRegenEvent(EntityPlayer player) {
        HealthRegenEvent.SaturatedRegen event = new HealthRegenEvent.SaturatedRegen(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static HealthRegenEvent.PeacefulRegen firePeacefulRegenEvent(EntityPlayer player) {
        HealthRegenEvent.PeacefulRegen event = new HealthRegenEvent.PeacefulRegen(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static HungerRegenEvent.PeacefulRegen firePeacefulHungerRegenEvent(EntityPlayer player) {
        HungerRegenEvent.PeacefulRegen event = new HungerRegenEvent.PeacefulRegen(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static Event.Result fireAllowStarvation(EntityPlayer player) {
        StarvationEvent.AllowStarvation event = new StarvationEvent.AllowStarvation(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getResult();
    }

    public static int fireStarvationTickEvent(EntityPlayer player) {
        return AppleCoreAPI.accessor.getStarveDamageTickPeriod(player);
    }

    public static StarvationEvent.Starve fireStarveEvent(EntityPlayer player) {
        StarvationEvent.Starve event = new StarvationEvent.Starve(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static boolean fireFoodStatsAdditionEvent(EntityPlayer player, FoodValues foodValuesToBeAdded) {
        FoodEvent.FoodStatsAddition event = new FoodEvent.FoodStatsAddition(player, foodValuesToBeAdded);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.isCancelable() && event.isCanceled();
    }

    public static boolean needFood(FoodStats foodStats) {
        Hooks.verifyFoodStats(foodStats, null);
        return foodStats.func_75116_a() < Hooks.getMaxHunger(foodStats);
    }

    public static int getMaxHunger(FoodStats foodStats) {
        Hooks.verifyFoodStats(foodStats, null);
        EntityPlayer player = ((IAppleCoreFoodStats)foodStats).getPlayer();
        return AppleCoreAPI.accessor.getMaxHunger(player);
    }

    @SideOnly(value=Side.CLIENT)
    public static int getHungerForDisplay(FoodStats foodStats) {
        if (!(foodStats instanceof IAppleCoreFoodStats)) {
            return foodStats.func_75116_a();
        }
        EntityPlayer player = ((IAppleCoreFoodStats)foodStats).getPlayer();
        float scale = 20.0f / (float)AppleCoreAPI.accessor.getMaxHunger(player);
        int realHunger = foodStats.func_75116_a();
        if (realHunger == 0) {
            return 0;
        }
        int scaledHunger = MathHelper.func_76141_d((float)((float)realHunger * scale));
        return Math.max(scaledHunger, 1);
    }

    public static float onExhaustionAdded(FoodStats foodStats, float deltaExhaustion) {
        Hooks.verifyFoodStats(foodStats, null);
        EntityPlayer player = ((IAppleCoreFoodStats)foodStats).getPlayer();
        ExhaustionEvent.ExhaustionAddition event = new ExhaustionEvent.ExhaustionAddition(player, deltaExhaustion);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.deltaExhaustion;
    }

    public static float fireExhaustingActionEvent(EntityPlayer player, ExhaustionEvent.ExhaustingActions source, float deltaExhaustion) {
        ExhaustionEvent.ExhaustingAction event = new ExhaustionEvent.ExhaustingAction(player, source, deltaExhaustion);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.deltaExhaustion;
    }
}

