/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.config;

import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.google.gson.JsonElement;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class ConfigNBT
extends ConfigValue {
    public static final String ID = "nbt";
    private NBTTagCompound value;

    public ConfigNBT(@Nullable NBTTagCompound nbt) {
        this.value = nbt;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getString() {
        return this.value == null ? "null" : this.value.toString();
    }

    @Nullable
    public NBTTagCompound getNBT() {
        return this.value;
    }

    public void setNBT(@Nullable NBTTagCompound nbt) {
        this.value = nbt;
    }

    @Override
    public boolean getBoolean() {
        this.value = this.getNBT();
        return this.value != null && !this.value.func_82582_d();
    }

    @Override
    public int getInt() {
        this.value = this.getNBT();
        return this.value == null ? 0 : this.value.func_186856_d();
    }

    @Override
    public ConfigNBT copy() {
        this.value = this.getNBT();
        return new ConfigNBT(this.value == null ? null : this.value.func_74737_b());
    }

    @Override
    public ITextComponent getStringForGUI() {
        return new TextComponentString(this.getNBT() == null ? "null" : "{...}");
    }

    @Override
    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        if (string.equals("null")) {
            if (!simulate) {
                this.setNBT(null);
            }
            return true;
        }
        try {
            this.value = JsonToNBT.func_180713_a((String)string);
            if (!simulate) {
                this.setNBT(this.value);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void addInfo(ConfigValueInstance inst, List<String> list) {
        list.add(TextFormatting.AQUA + "Value: " + TextFormatting.RESET + NBTUtils.getColoredNBTString((NBTBase)this.getNBT()));
        if (inst.getCanEdit() && inst.getDefaultValue() instanceof ConfigNBT) {
            list.add(TextFormatting.AQUA + "Default: " + TextFormatting.RESET + NBTUtils.getColoredNBTString((NBTBase)((ConfigNBT)inst.getDefaultValue()).getNBT()));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String key) {
        this.value = this.getNBT();
        if (this.value != null) {
            nbt.func_74782_a(key, (NBTBase)this.value);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String key) {
        this.value = nbt.func_74764_b(key) ? nbt.func_74775_l(key) : null;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeNBT(this.getNBT());
    }

    @Override
    public void readData(DataIn data) {
        this.setNBT(data.readNBT());
    }

    @Override
    public boolean isEmpty() {
        this.value = this.getNBT();
        return this.value == null || this.value.func_82582_d();
    }

    @Override
    public void setValueFromOtherValue(ConfigValue value) {
        if (value instanceof ConfigNBT) {
            NBTTagCompound nbt = ((ConfigNBT)value).getNBT();
            this.setNBT(nbt == null ? null : nbt.func_74737_b());
        } else {
            super.setValueFromOtherValue(value);
        }
    }

    @Override
    public void setValueFromJson(JsonElement json) {
        if (json.isJsonObject()) {
            this.setNBT((NBTTagCompound)JsonUtils.toNBT(json));
        }
    }
}

