/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TierHandler {
    public static final Tier BLANK_TIER = new Tier(0, 0, true, false, false, 0, 0);
    public static Map<Integer, Tier> tiers = new HashMap<Integer, Tier>();
    public static int maxTier = 0;

    public static Tier getTier(int tier) {
        return tiers.get(tier) == null ? BLANK_TIER : tiers.get(tier);
    }

    public static int getMinKills(int tier) {
        return TierHandler.getTier(tier).getMinKills();
    }

    public static int getMaxKills(int tier) {
        return TierHandler.getTier(tier).getMaxKills();
    }

    public static int getSpawnAmount(int tier) {
        return TierHandler.getTier(tier).getSpawnAmount();
    }

    public static int getCooldown(int tier) {
        return TierHandler.getTier(tier).getCooldown();
    }

    public static boolean checksPlayer(int tier) {
        return TierHandler.getTier(tier).isCheckPlayer();
    }

    public static boolean checksLight(int tier) {
        return TierHandler.getTier(tier).isCheckLight();
    }

    public static boolean checksRedstone(int tier) {
        return TierHandler.getTier(tier).isCheckRedstone();
    }

    public static class Tier {
        private final int minKills;
        private final int maxKills;
        private final boolean checkPlayer;
        private final boolean checkLight;
        private final boolean checkRedstone;
        private final int spawnAmount;
        private final int cooldown;

        public Tier(int minKills, int maxKills, boolean checkPlayer, boolean checkLight, boolean checkRedstone, int spawnAmount, int cooldown) {
            this.minKills = minKills;
            this.maxKills = maxKills;
            this.checkPlayer = checkPlayer;
            this.checkLight = checkLight;
            this.checkRedstone = checkRedstone;
            this.spawnAmount = spawnAmount;
            this.cooldown = cooldown;
        }

        public int getMinKills() {
            return this.minKills;
        }

        public int getMaxKills() {
            return this.maxKills;
        }

        public boolean isCheckPlayer() {
            return this.checkPlayer;
        }

        public boolean isCheckLight() {
            return this.checkLight;
        }

        public boolean isCheckRedstone() {
            return this.checkRedstone;
        }

        public int getSpawnAmount() {
            return this.spawnAmount;
        }

        public int getCooldown() {
            return this.cooldown;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("minKills", this.minKills).append("maxKills", this.maxKills).append("checkPlayer", this.checkPlayer).append("checkLight", this.checkLight).append("checkRedstone", this.checkRedstone).append("spawnAmount", this.spawnAmount).append("cooldown", this.cooldown).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Tier)) {
                return false;
            }
            Tier tier = (Tier)o;
            if (this.minKills != tier.minKills) {
                return false;
            }
            if (this.maxKills != tier.maxKills) {
                return false;
            }
            if (this.checkPlayer != tier.checkPlayer) {
                return false;
            }
            if (this.checkLight != tier.checkLight) {
                return false;
            }
            if (this.checkRedstone != tier.checkRedstone) {
                return false;
            }
            if (this.spawnAmount != tier.spawnAmount) {
                return false;
            }
            return this.cooldown == tier.cooldown;
        }

        public int hashCode() {
            int result = this.minKills;
            result = 31 * result + this.maxKills;
            result = 31 * result + (this.checkPlayer ? 1 : 0);
            result = 31 * result + (this.checkLight ? 1 : 0);
            result = 31 * result + (this.checkRedstone ? 1 : 0);
            result = 31 * result + this.spawnAmount;
            result = 31 * result + this.cooldown;
            return result;
        }
    }
}

