/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.item;

import com.google.common.collect.Lists;
import com.whammich.sstow.ConfigHandler;
import com.whammich.sstow.SoulShardsTOW;
import com.whammich.sstow.api.ISoulShard;
import com.whammich.sstow.api.ShardHelper;
import com.whammich.sstow.api.SoulShardsAPI;
import com.whammich.sstow.util.EntityMapper;
import com.whammich.sstow.util.TierHandler;
import com.whammich.sstow.util.Utils;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class ItemSoulShard
extends Item
implements ISoulShard {
    public static List<Pair<BlockPos, IBlockState>> multiblock = Lists.newArrayList();
    public static IBlockState originBlock = null;

    public ItemSoulShard() {
        this.func_77655_b("soulshardstow.shard");
        this.func_77637_a(SoulShardsTOW.TAB_SS);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        ItemStack stack = player.func_184586_b(hand);
        if (!Utils.hasMaxedKills(stack) && (tile = world.func_175625_s(pos)) instanceof TileEntityMobSpawner) {
            if (ConfigHandler.allowSpawnerAbsorption) {
                WeightedSpawnerEntity spawnerEntity = (WeightedSpawnerEntity)ReflectionHelper.getPrivateValue(MobSpawnerBaseLogic.class, (Object)((TileEntityMobSpawner)tile).func_145881_a(), (String[])new String[]{"field_98282_f", "spawnData", "randomEntity"});
                ResourceLocation name = new ResourceLocation(spawnerEntity.func_185277_b().func_74779_i("id"));
                EntityLiving ent = (EntityLiving)EntityList.func_188429_b((ResourceLocation)name, (World)world);
                if (ent == null) {
                    return EnumActionResult.FAIL;
                }
                if (!EntityMapper.isEntityValid(name) || SoulShardsAPI.isEntityBlacklisted(ent)) {
                    return EnumActionResult.FAIL;
                }
                if (ShardHelper.isBound(stack) && ShardHelper.getBoundEntity(stack).equals((Object)name)) {
                    if (!world.field_72995_K) {
                        Utils.increaseShardKillCount(stack, ConfigHandler.spawnerAbsorptionBonus);
                    }
                    world.func_175655_b(pos, false);
                    return EnumActionResult.SUCCESS;
                }
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.sstow.absorb.disabled", new Object[0]), true);
            }
        }
        return EnumActionResult.FAIL;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ConfigHandler.displayDurabilityBar && ShardHelper.getKillsFromShard(stack) < TierHandler.getMaxKills(TierHandler.tiers.size() - 1);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        TierHandler.Tier maxTier = TierHandler.getTier(TierHandler.tiers.size() - 1);
        return 1.0 - (double)ShardHelper.getKillsFromShard(stack) / (double)maxTier.getMinKills();
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + (ShardHelper.isBound(stack) ? "" : ".unbound");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return Utils.hasMaxedKills(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tabs, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tabs)) {
            return;
        }
        for (int i = 0; i <= TierHandler.tiers.size() - 1; ++i) {
            ItemStack stack = new ItemStack((Item)this);
            ShardHelper.setKillsForShard(stack, TierHandler.getMinKills(i));
            ShardHelper.setTierForShard(stack, i);
            list.add((Object)stack);
        }
        if (ConfigHandler.addShardsForAllMobs) {
            for (ResourceLocation ent : EntityMapper.entityList) {
                if (!ConfigHandler.ignoreBlacklistForTab && !EntityMapper.isEntityValid(ent)) continue;
                ItemStack stack = new ItemStack((Item)this);
                Utils.setMaxedKills(stack);
                ShardHelper.setTierForShard(stack, TierHandler.tiers.size() - 1);
                ShardHelper.setBoundEntity(stack, ent);
                list.add((Object)stack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag advanced) {
        if (ShardHelper.isBound(stack)) {
            ResourceLocation boundEnt = ShardHelper.getBoundEntity(stack);
            boolean disabled = !ConfigHandler.entityList.contains(boundEnt);
            list.add((disabled ? TextFormatting.RED.toString() : "") + I18n.func_135052_a((String)"tooltip.soulshardstow.bound", (Object[])new Object[]{Utils.getEntityNameTranslated(boundEnt)}));
        }
        if (ShardHelper.getKillsFromShard(stack) >= 0) {
            list.add(I18n.func_135052_a((String)"tooltip.soulshardstow.kills", (Object[])new Object[]{ShardHelper.getKillsFromShard(stack)}));
        }
        list.add(I18n.func_135052_a((String)"tooltip.soulshardstow.tier", (Object[])new Object[]{ShardHelper.getTierFromShard(stack)}));
    }

    public static void buildMultiblock() {
        originBlock = Blocks.field_150426_aN.func_176223_P();
        multiblock.clear();
        multiblock.add((Pair<BlockPos, IBlockState>)Pair.of((Object)new BlockPos(0, 0, 0), (Object)Blocks.field_150426_aN.func_176223_P()));
        multiblock.add((Pair<BlockPos, IBlockState>)Pair.of((Object)new BlockPos(1, 0, 0), (Object)Blocks.field_150371_ca.func_176223_P()));
        multiblock.add((Pair<BlockPos, IBlockState>)Pair.of((Object)new BlockPos(-1, 0, 0), (Object)Blocks.field_150371_ca.func_176223_P()));
        multiblock.add((Pair<BlockPos, IBlockState>)Pair.of((Object)new BlockPos(0, 0, 1), (Object)Blocks.field_150371_ca.func_176223_P()));
        multiblock.add((Pair<BlockPos, IBlockState>)Pair.of((Object)new BlockPos(0, 0, -1), (Object)Blocks.field_150371_ca.func_176223_P()));
        multiblock.add((Pair<BlockPos, IBlockState>)Pair.of((Object)new BlockPos(1, 0, 1), (Object)Blocks.field_150343_Z.func_176223_P()));
        multiblock.add((Pair<BlockPos, IBlockState>)Pair.of((Object)new BlockPos(1, 0, -1), (Object)Blocks.field_150343_Z.func_176223_P()));
        multiblock.add((Pair<BlockPos, IBlockState>)Pair.of((Object)new BlockPos(-1, 0, 1), (Object)Blocks.field_150343_Z.func_176223_P()));
        multiblock.add((Pair<BlockPos, IBlockState>)Pair.of((Object)new BlockPos(-1, 0, -1), (Object)Blocks.field_150343_Z.func_176223_P()));
    }
}

