/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util.styledstring;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Shorts;
import com.pau101.fairylights.util.styledstring.Style;
import com.pau101.fairylights.util.styledstring.StyledString;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

public final class StyledStringBuilder
implements Appendable,
CharSequence {
    private final StringBuilder strBldr;
    private final List<Short> styling;
    private short currentStyle;

    public StyledStringBuilder(String str) {
        this();
        this.append(str);
    }

    public StyledStringBuilder() {
        this(16);
    }

    public StyledStringBuilder(int capacity) {
        this.strBldr = new StringBuilder(capacity);
        this.styling = new ArrayList<Short>(capacity);
        this.currentStyle = Style.getStylingAsShort(TextFormatting.WHITE);
    }

    private StyledStringBuilder(String str, List<Short> styling, short currentStyling) {
        this.strBldr = new StringBuilder(str);
        this.styling = styling;
        this.currentStyle = currentStyling;
    }

    public StyledStringBuilder setStyle(short style) {
        this.currentStyle = (short)(style & 0x1FF);
        return this;
    }

    public StyledStringBuilder setColor(TextFormatting color) {
        Preconditions.checkArgument((boolean)color.func_96302_c(), (Object)"Must be a color");
        this.currentStyle = (short)(this.currentStyle & 0xFFFFFFF0 | Style.getStylingAsShort(color));
        return this;
    }

    public StyledStringBuilder setBold(boolean bold) {
        return this.setFlag(0, bold);
    }

    public StyledStringBuilder setStrikethrough(boolean strikethrough) {
        return this.setFlag(1, strikethrough);
    }

    public StyledStringBuilder setUnderline(boolean underline) {
        return this.setFlag(2, underline);
    }

    public StyledStringBuilder setItalic(boolean italic) {
        return this.setFlag(3, italic);
    }

    private StyledStringBuilder setFlag(int idx, boolean value) {
        this.currentStyle = value ? (short)(this.currentStyle | 1 << idx + 4) : (short)(this.currentStyle & ~(1 << idx + 4));
        return this;
    }

    @Override
    public int length() {
        return this.strBldr.length();
    }

    @Override
    public char charAt(int index) {
        return this.strBldr.charAt(index);
    }

    @Override
    public StyledStringBuilder subSequence(int start, int end) {
        return new StyledStringBuilder(this.strBldr.substring(start, end), new ArrayList<Short>(this.styling).subList(start, end), this.currentStyle);
    }

    public StyledStringBuilder insert(int index, String str) {
        this.strBldr.insert(0, str);
        for (int i = str.length(); i > 0; --i) {
            this.styling.add(index, this.currentStyle);
        }
        return this;
    }

    public StyledStringBuilder insert(int index, StyledString str) {
        this.strBldr.insert(0, str.toUnstyledString());
        short[] styling = str.getStyling();
        for (int i = styling.length - 1; i >= 0; --i) {
            this.styling.add(index, styling[i]);
        }
        return this;
    }

    public StyledStringBuilder append(StyledString str) {
        this.strBldr.append(str.toUnstyledString());
        for (short s : str.getStyling()) {
            this.styling.add(s);
        }
        return this;
    }

    public StyledStringBuilder append(CharSequence csq, short style) {
        this.strBldr.append(csq);
        style = (short)(style & 0x1FF);
        int s = style & 0x1FF;
        for (int i = 0; i < csq.length(); ++i) {
            this.styling.add(style);
        }
        return this;
    }

    @Override
    public StyledStringBuilder append(CharSequence csq) {
        this.strBldr.append(csq);
        for (int i = 0; i < csq.length(); ++i) {
            this.styling.add(this.currentStyle);
        }
        return this;
    }

    @Override
    public StyledStringBuilder append(CharSequence csq, int start, int end) {
        return this.append(csq.subSequence(start, end));
    }

    @Override
    public StyledStringBuilder append(char c) {
        return this.append(c, this.currentStyle);
    }

    public StyledStringBuilder append(char c, short s) {
        this.strBldr.append(c);
        this.styling.add(s);
        return this;
    }

    @Override
    public String toString() {
        return this.strBldr.toString();
    }

    public StyledString toStyledString() {
        return new StyledString(this.strBldr.toString(), Shorts.toArray(this.styling));
    }
}

