/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util;

import java.util.Objects;
import java.util.function.ToIntFunction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public final class Mth {
    public static final float PI = (float)Math.PI;
    public static final float HALF_PI = 1.5707964f;
    public static final float TAU = (float)Math.PI * 2;
    public static final float DEG_TO_RAD = (float)Math.PI / 180;
    public static final float RAD_TO_DEG = 57.29578f;

    private Mth() {
    }

    public static int mod(int a, int b) {
        return (a % b + b) % b;
    }

    public static float mod(float a, float b) {
        return (a % b + b) % b;
    }

    public static double mod(double a, double b) {
        return (a % b + b) % b;
    }

    public static float transform(float x, float domainMin, float domainMax, float rangeMin, float rangeMax) {
        if (x <= domainMin) {
            return rangeMin;
        }
        if (x >= domainMax) {
            return rangeMax;
        }
        return (rangeMax - rangeMin) * (x - domainMin) / (domainMax - domainMin) + rangeMin;
    }

    public static double transform(double x, double domainMin, double domainMax, double rangeMin, double rangeMax) {
        if (x <= domainMin) {
            return rangeMin;
        }
        if (x >= domainMax) {
            return rangeMax;
        }
        return (rangeMax - rangeMin) * (x - domainMin) / (domainMax - domainMin) + rangeMin;
    }

    public static float[] toEulerYZX(float x, float y, float z, float angle) {
        float s = MathHelper.func_76126_a((float)angle);
        float c = MathHelper.func_76134_b((float)angle);
        float t = 1.0f - c;
        float magnitude = MathHelper.func_76129_c((float)(x * x + y * y + z * z));
        if (magnitude == 0.0f) {
            throw new IllegalArgumentException("Ubiquitous vector!");
        }
        if ((x /= magnitude) * (y /= magnitude) * t + (z /= magnitude) * s > 0.998f) {
            float pitch = (float)(2.0 * Math.atan2((double)x * Math.sin(angle / 2.0f), Math.cos(angle / 2.0f)));
            float yaw = 1.5707964f;
            float roll = 0.0f;
            return new float[]{roll, pitch, yaw};
        }
        if (x * y * t + z * s < -0.998f) {
            float pitch = (float)(-2.0 * Math.atan2((double)x * Math.sin(angle / 2.0f), Math.cos(angle / 2.0f)));
            float yaw = -1.5707964f;
            float roll = 0.0f;
            return new float[]{roll, pitch, yaw};
        }
        float pitch = (float)Math.atan2(y * s - x * z * t, 1.0f - (y * y + z * z) * t);
        float yaw = (float)Math.asin(x * y * t + z * s);
        float roll = (float)Math.atan2(x * s - y * z * t, 1.0f - (x * x + z * z) * t);
        return new float[]{roll, pitch, yaw};
    }

    public static int hash(int x) {
        x = (x >> 16 ^ x) * 73244475;
        x = (x >> 16 ^ x) * 73244475;
        x = x >> 16 ^ x;
        return x;
    }

    public static Vec3d negate(Vec3d vector) {
        return new Vec3d(-Objects.requireNonNull(vector, (String)"vector").field_72450_a, -vector.field_72448_b, -vector.field_72449_c);
    }

    public static Vec3d lerp(Vec3d a, Vec3d b, double t) {
        Objects.requireNonNull(a, "a vector");
        Objects.requireNonNull(b, "b vector");
        double x = a.field_72450_a + (b.field_72450_a - a.field_72450_a) * t;
        double y = a.field_72448_b + (b.field_72448_b - a.field_72448_b) * t;
        double z = a.field_72449_c + (b.field_72449_c - a.field_72449_c) * t;
        return new Vec3d(x, y, z);
    }

    public static Vec3d lerpAngles(Vec3d a, Vec3d b, double t) {
        Objects.requireNonNull(a, "a vector");
        Objects.requireNonNull(b, "b vector");
        double x = Mth.lerpAngle(a.field_72450_a, b.field_72450_a, t);
        double y = Mth.lerpAngle(a.field_72448_b, b.field_72448_b, t);
        double z = Mth.lerpAngle(a.field_72449_c, b.field_72449_c, t);
        return new Vec3d(x, y, z);
    }

    public static double lerpAngle(double a, double b, double t) {
        return a + t * Mth.angleDifference(a, b);
    }

    public static double angleDifference(double a, double b) {
        return Mth.mod(b - a + Math.PI, 6.2831854820251465) - Math.PI;
    }

    public static int floorInterval(int x, int n) {
        return x / n * n;
    }

    public static double min(double a, double b, double c) {
        return Math.min(Math.min(a, b), c);
    }

    public static double max(double a, double b, double c) {
        return Math.max(Math.max(a, b), c);
    }

    public static int log2(int n) {
        if (n <= 0) {
            throw new ArithmeticException("Negative infinity: " + n);
        }
        int r = 0;
        while ((n >>= 1) > 0) {
            ++r;
        }
        return r;
    }

    public static int lcm(int a, int b) {
        return Math.abs(a * b) / Mth.gcd(a, b);
    }

    public static int gcd(int a, int b) {
        while (b != 0) {
            int n = a;
            a = b;
            b = Mth.mod(n, a);
        }
        return a;
    }

    public static double angle(Vec3d a, Vec3d b) {
        Objects.requireNonNull(a, "a vector");
        Objects.requireNonNull(b, "b vector");
        double theta = a.func_72430_b(b) / (a.func_72433_c() * b.func_72433_c());
        if (theta > 1.0) {
            return 0.0;
        }
        if (theta < -1.0) {
            return Math.PI;
        }
        return Math.acos(theta);
    }

    public static <T> int[] invertMap(T[] map, ToIntFunction<T> asInt) {
        for (T v : map) {
            int vp = asInt.applyAsInt(v);
            if (vp >= 0 && vp < map.length) continue;
            throw new IllegalArgumentException("Must be a perfect map, " + v + " out of range with " + vp);
        }
        int[] inverse = new int[map.length];
        for (int i = 0; i < map.length; ++i) {
            inverse[asInt.applyAsInt(map[i])] = i;
        }
        return inverse;
    }
}

