/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.integration.valkyrienwarfare;

import com.pau101.fairylights.server.fastener.BlockView;
import com.pau101.fairylights.server.fastener.CollectFastenersEvent;
import com.pau101.fairylights.server.fastener.CreateBlockViewEvent;
import com.pau101.fairylights.util.matrix.Matrix;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.math.Quaternion;
import valkyrienwarfare.physics.TransformType;
import valkyrienwarfare.physics.management.PhysicsObject;
import valkyrienwarfare.physics.management.PhysicsWrapperEntity;
import valkyrienwarfare.util.RealMethods;

public class ValkyrienWarfare {
    @SubscribeEvent
    public static void onCollectFasteners(CollectFastenersEvent event) {
        event.getWorld().field_72996_f.stream().filter(PhysicsWrapperEntity.class::isInstance).map(PhysicsWrapperEntity.class::cast).map(PhysicsWrapperEntity::getPhysicsObject).forEach(obj -> {
            int minX = obj.ownedChunks.getMinX();
            int maxX = obj.ownedChunks.getMaxX();
            int minZ = obj.ownedChunks.getMinZ();
            int maxZ = obj.ownedChunks.getMaxZ();
            for (int x = minX; x < maxX; ++x) {
                for (int z = minZ; z < maxZ; ++z) {
                    event.accept(obj.shipChunks.getChunkAt(x, z));
                }
            }
        });
    }

    @SubscribeEvent
    public static void onCreateBlockView(CreateBlockViewEvent event) {
        event.setView(new VWView(event.getView()));
    }

    private static class VWView
    implements BlockView {
        private final BlockView parent;

        private VWView(BlockView parent) {
            this.parent = parent;
        }

        @Override
        public boolean isMoving(World world, BlockPos source) {
            return new RealMethods().isBlockPartOfShip(world, source) || this.parent.isMoving(world, source);
        }

        @Override
        public Vec3d getPosition(World world, BlockPos source, Vec3d pos) {
            PhysicsWrapperEntity entity = new RealMethods().getShipEntityManagingPos(world, source);
            if (entity != null) {
                Vector p = new Vector(pos);
                entity.getPhysicsObject().coordTransform.fromLocalToGlobal(p);
                return p.toVec3d();
            }
            return this.parent.getPosition(world, source, pos);
        }

        @Override
        public void unrotate(World world, BlockPos source, Matrix matrix, float delta) {
            this.parent.unrotate(world, source, matrix, delta);
            PhysicsWrapperEntity entity = new RealMethods().getShipEntityManagingPos(world, source);
            if (entity != null) {
                Quaternion rot = this.getRotation(entity.getPhysicsObject(), delta);
                double[] radians = rot.toRadians();
                float pitch = (float)Math.toDegrees(radians[0]);
                float yaw = (float)Math.toDegrees(radians[1]);
                float roll = (float)Math.toDegrees(radians[2]);
                matrix.rotate(pitch, 1.0f, 0.0f, 0.0f);
                matrix.rotate(yaw, 0.0f, 1.0f, 0.0f);
                matrix.rotate(roll, 0.0f, 0.0f, 1.0f);
            }
        }

        private Quaternion getRotation(PhysicsObject object, float delta) {
            Quaternion prevRotation = object.coordTransform.getPrevTickTransform().createRotationQuaternion(TransformType.GLOBAL_TO_LOCAL);
            Quaternion rotation = object.coordTransform.getCurrentTickTransform().createRotationQuaternion(TransformType.GLOBAL_TO_LOCAL);
            return Quaternion.slerpInterpolate((Quaternion)prevRotation, (Quaternion)rotation, (double)delta);
        }
    }
}

