/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.client.model.connection;

import com.pau101.fairylights.client.model.AdvancedModelRenderer;
import com.pau101.fairylights.client.model.connection.ModelConnection;
import com.pau101.fairylights.client.model.lights.ModelLight;
import com.pau101.fairylights.client.model.lights.ModelLightFairy;
import com.pau101.fairylights.client.model.lights.ModelLightFlower;
import com.pau101.fairylights.client.model.lights.ModelLightGhost;
import com.pau101.fairylights.client.model.lights.ModelLightIcicle;
import com.pau101.fairylights.client.model.lights.ModelLightJackOLantern;
import com.pau101.fairylights.client.model.lights.ModelLightLuxoBall;
import com.pau101.fairylights.client.model.lights.ModelLightMeteor;
import com.pau101.fairylights.client.model.lights.ModelLightOil;
import com.pau101.fairylights.client.model.lights.ModelLightOrb;
import com.pau101.fairylights.client.model.lights.ModelLightOrnate;
import com.pau101.fairylights.client.model.lights.ModelLightPaper;
import com.pau101.fairylights.client.model.lights.ModelLightSkull;
import com.pau101.fairylights.client.model.lights.ModelLightSnowflake;
import com.pau101.fairylights.client.model.lights.ModelLightSpider;
import com.pau101.fairylights.client.model.lights.ModelLightWitch;
import com.pau101.fairylights.server.fastener.Fastener;
import com.pau101.fairylights.server.fastener.connection.type.hanginglights.ConnectionHangingLights;
import com.pau101.fairylights.server.fastener.connection.type.hanginglights.Light;
import com.pau101.fairylights.util.Mth;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public final class ModelConnectionHangingLights
extends ModelConnection<ConnectionHangingLights> {
    private AdvancedModelRenderer cordModel;
    private ModelLight[] lightModels = new ModelLight[]{new ModelLightFairy(), new ModelLightPaper(), new ModelLightOrb(), new ModelLightFlower(), new ModelLightOrnate(), new ModelLightOil(), new ModelLightLuxoBall(), new ModelLightJackOLantern(), new ModelLightSkull(), new ModelLightGhost(), new ModelLightSpider(), new ModelLightWitch(), new ModelLightSnowflake(), new ModelLightIcicle(), new ModelLightMeteor()};

    public ModelConnectionHangingLights() {
        this.cordModel = new AdvancedModelRenderer(this, 0, 0).addBox(-1.0f, -1.0f, 0.0f, 2, 2, 1);
    }

    @Override
    public void render(Fastener<?> fastener, ConnectionHangingLights hangingLights, World world, int skylight, int moonlight, float delta) {
        super.render(fastener, hangingLights, world, skylight, moonlight, delta);
        Light[] lights = (Light[])hangingLights.getFeatures();
        Light[] prevLights = (Light[])hangingLights.getPrevFeatures();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        int count = Math.min(lights.length, prevLights.length);
        for (int i = 0; i < count; ++i) {
            Light light = lights[i];
            Vec3d color = light.getLight();
            Vec3d point = Mth.lerp(prevLights[i].getPoint(), light.getPoint(), delta);
            Vec3d rotation = light.getRotation(delta);
            float brightness = light.getBrightness(delta);
            ModelLight model = this.lightModels[light.getVariant().ordinal()];
            model.setOffsets(point.field_72450_a / 16.0, point.field_72448_b / 16.0, point.field_72449_c / 16.0);
            boolean vert = Math.abs(Math.abs(rotation.field_72448_b) - 1.5707963705062866) < (double)1.0E-6f;
            model.setAfts(0.0f, -0.1375f, 0.0f);
            model.setRotationAngles(light.getVariant().parallelsCord() ? rotation.field_72448_b : (vert ? (double)0.3f : 0.0), rotation.field_72450_a, rotation.field_72449_c);
            model.setScale(1.0f);
            model.render(world, light, 0.0625f, color, moonlight, skylight, brightness, i, delta);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
    }

    @Override
    protected void renderSegment(ConnectionHangingLights fairylights, int index, double angleX, double angleY, double length, double x, double y, double z, float delta) {
        this.cordModel.field_78795_f = (float)angleX;
        this.cordModel.field_78796_g = (float)angleY;
        this.cordModel.scaleZ = (float)length;
        this.cordModel.setRotationPoint(x, y, z);
        this.cordModel.func_78785_a(0.0625f);
    }
}

