/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.client.gui.component;

import com.google.common.base.MoreObjects;
import com.pau101.fairylights.client.gui.GuiEditLetteredConnection;
import com.pau101.fairylights.client.gui.component.GuiButtonColor;
import com.pau101.fairylights.client.gui.component.GuiButtonToggle;
import com.pau101.fairylights.util.styledstring.Style;
import com.pau101.fairylights.util.styledstring.StyledString;
import com.pau101.fairylights.util.styledstring.StyledStringBuilder;
import com.pau101.fairylights.util.styledstring.StyledStringSelection;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import paulscode.sound.SoundSystem;

public final class GuiStyledTextField
extends Gui {
    private static final DataFlavor RTF_FLAVOR = new DataFlavor("text/rtf", "Rich Text Format");
    private static final Predicate<String> ALWAYS_TRUE = str -> true;
    private static final Function<Character, Character> IDENTITY_CHARACTER_TRANSFORMER = c -> c;
    private final int id;
    private final FontRenderer font;
    private final int multiClickInterval = GuiStyledTextField.getMultiClickInterval();
    private final GuiButtonColor colorBtn;
    private final GuiButtonToggle boldBtn;
    private final GuiButtonToggle italicBtn;
    private final GuiButtonToggle underlineBtn;
    private final GuiButtonToggle strikethroughBtn;
    public int x;
    public int y;
    public int width;
    public int height;
    private StyledString value;
    private int maxLength = 32;
    private int tick;
    private boolean hasBackground = true;
    private boolean isBlurable = true;
    private boolean isFocused;
    private boolean isWritable = true;
    private boolean isVisible = true;
    private int lineScrollOffset;
    private int caret;
    private int selectionEnd;
    private int writableTextColor = 0xE0E0E0;
    private int readonlyTextColor = 0x707070;
    private boolean isDraggingSelection;
    private boolean hasDraggedSelecton;
    private boolean isPressed;
    private long lastClickTime;
    private int multiClicks;
    private Function<Character, Character> charInputTransformer = IDENTITY_CHARACTER_TRANSFORMER;
    private Predicate<String> validator = ALWAYS_TRUE;
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private Style currentStyle;
    private static ISound ea;

    public GuiStyledTextField(int id, FontRenderer font, GuiButtonColor colorBtn, GuiButtonToggle boldBtn, GuiButtonToggle italicBtn, GuiButtonToggle underlineBtn, GuiButtonToggle strikethroughBtn, int x, int y, int width, int height) {
        this.id = id;
        this.font = font;
        this.colorBtn = colorBtn;
        this.boldBtn = boldBtn;
        this.italicBtn = italicBtn;
        this.underlineBtn = underlineBtn;
        this.strikethroughBtn = strikethroughBtn;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.setValue0(new StyledString());
        this.setStyle(new Style());
    }

    public int getId() {
        return this.id;
    }

    public void setIsBlurable(boolean isBlurable) {
        this.isBlurable = isBlurable;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public void updateStyling(TextFormatting styling, boolean state) {
        int start = this.caret;
        int end = this.selectionEnd;
        if (start == end) {
            this.withStyling(styling, state);
        } else {
            if (end < start) {
                int t = start;
                start = end;
                end = t;
            }
            this.setValue0(this.value.addStyling(start, end, styling, state));
            this.updateSelectionControls();
        }
    }

    public void setColor(TextFormatting color) {
        this.setStyle(this.currentStyle.withColor(color));
    }

    public void withStyling(TextFormatting styling, boolean state) {
        this.setStyle(this.currentStyle.withStyling(styling, state));
    }

    public void setStyle(Style style) {
        this.currentStyle = style;
        this.colorBtn.setDisplayColor(this.font, this.currentStyle.getColor());
        this.boldBtn.setValue(style.isBold());
        this.italicBtn.setValue(style.isItalic());
        this.underlineBtn.setValue(style.isUnderline());
        this.strikethroughBtn.setValue(style.isStrikethrough());
    }

    public TextFormatting getColor() {
        return this.currentStyle.getColor();
    }

    public void setValue(String value) {
        this.setValue(new StyledString(value, this.currentStyle));
    }

    public void setValue(StyledString value) {
        if (this.validator.test(value.toUnstyledString())) {
            if (value.length() > this.maxLength) {
                this.setValue0(value.substring(0, this.maxLength));
            } else {
                this.setValue0(value);
            }
        }
    }

    private void setValue0(StyledString value) {
        this.value = value;
        for (ChangeListener listener : this.changeListeners) {
            listener.onChange(value);
        }
        GuiStyledTextField.lorem(value);
    }

    public String getUnstyledValue() {
        return this.value.toUnstyledString();
    }

    public StyledString getValue() {
        return this.value;
    }

    public String getUnstyledSelectedText() {
        return this.getSelectedText().toUnstyledString();
    }

    public StyledString getSelectedText() {
        int end = this.selectionEnd;
        int start = this.caret;
        if (end < start) {
            int t = start;
            start = end;
            end = t;
        }
        return this.value.substring(start, end);
    }

    public void setCaretStart() {
        this.setCaret(0);
    }

    public void setCaretEnd() {
        this.setCaret(this.value.length());
    }

    public void setCaret(int pos) {
        this.setCaret(pos, true);
    }

    public void setCaret(int pos, boolean changeColor) {
        this.caret = MathHelper.func_76125_a((int)pos, (int)0, (int)this.value.length());
        this.setSelectionPos(this.caret);
        if (changeColor) {
            this.setCurrentStyleByIndex(this.caret);
        }
        this.tick = 0;
    }

    private void setCurrentStyleByIndex(int index) {
        if (this.value.length() > 0) {
            this.setStyle(this.value.styleAt(index <= 0 ? 0 : index - 1));
        }
    }

    public int getCaret() {
        return this.caret;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public Style getStyle() {
        return this.currentStyle;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setHasBackground(boolean hasBackground) {
        this.hasBackground = hasBackground;
    }

    public void setTextColor(int writableTextColor) {
        this.writableTextColor = writableTextColor & 0xFFFFFF;
    }

    public void setReadonlyTextColor(int readonlyTextColor) {
        this.readonlyTextColor = readonlyTextColor & 0xFFFFFF;
    }

    public void setFocused(boolean isFocused) {
        if (isFocused) {
            if (!this.isFocused) {
                this.tick = 0;
            }
        } else if (this.selectionEnd != this.caret) {
            this.setSelectionPos(this.caret);
        }
        this.isFocused = isFocused;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public void setWritable(boolean isWritable) {
        this.isWritable = isWritable;
    }

    public void setCharInputTransformer(Function<Character, Character> charTransformer) {
        this.charInputTransformer = charTransformer;
    }

    public void setValidator(Predicate<String> validator) {
        this.validator = validator;
    }

    public int getInnerWidth() {
        return this.hasBackground ? this.width - 8 : this.width;
    }

    public void setSelectionPos(int pos) {
        int w;
        int len = this.value.length();
        this.selectionEnd = MathHelper.func_76125_a((int)pos, (int)0, (int)len);
        if (this.lineScrollOffset > len) {
            this.lineScrollOffset = len;
        }
        if (this.selectionEnd > (w = this.value.substring(this.lineScrollOffset).trimToWidth(this.font, this.getInnerWidth(), true).length()) + this.lineScrollOffset) {
            this.lineScrollOffset = this.selectionEnd - w;
        } else if (this.selectionEnd <= this.lineScrollOffset) {
            this.lineScrollOffset = this.selectionEnd;
        }
        this.lineScrollOffset = MathHelper.func_76125_a((int)this.lineScrollOffset, (int)0, (int)len);
        if (this.caret != this.selectionEnd) {
            this.updateSelectionControls();
        }
    }

    private void updateSelectionControls() {
        StyledString selected = this.getSelectedText();
        TextFormatting color = null;
        boolean consistantColor = true;
        boolean bold = true;
        boolean italic = true;
        boolean underline = true;
        boolean strikethrough = true;
        for (int i = 0; i < selected.length(); ++i) {
            Style s = selected.styleAt(i);
            if (color != null && color != s.getColor()) {
                color = null;
                consistantColor = false;
            }
            if (consistantColor) {
                color = s.getColor();
            }
            if (!s.isBold()) {
                bold = false;
            }
            if (!s.isItalic()) {
                italic = false;
            }
            if (!s.isUnderline()) {
                underline = false;
            }
            if (s.isStrikethrough()) continue;
            strikethrough = false;
        }
        this.setStyle(new Style(color == null ? this.currentStyle.getColor() : color, bold, strikethrough, underline, italic, false));
        if (!consistantColor) {
            this.colorBtn.removeDisplayColor();
        }
    }

    public void registerChangeListener(ChangeListener listener) {
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
        listener.onChange(this.value);
    }

    public boolean removeChangeListener(ChangeListener listener) {
        return this.changeListeners.remove(listener);
    }

    public void update(int mouseX, int mouseY) {
        if (this.isPressed && this.caret != this.selectionEnd) {
            int max;
            int upper;
            int lower;
            if (this.hasBackground) {
                lower = this.x + 15;
                upper = this.x + this.width - 16;
            } else {
                lower = this.x + 11;
                upper = this.x + this.width - 12;
            }
            boolean scrolled = false;
            if (mouseX < lower) {
                if (this.lineScrollOffset > 0) {
                    int rate = (2 - (mouseX - this.x) / 5) * 2 + 2;
                    this.lineScrollOffset -= rate;
                    if (this.lineScrollOffset < 0) {
                        this.lineScrollOffset = 0;
                    }
                    scrolled = true;
                }
            } else if (mouseX > upper && this.lineScrollOffset < (max = this.value.length() - this.value.trimToWidth(this.font, this.getInnerWidth(), true).length())) {
                int rate = (2 + (mouseX - this.x - this.width + 1) / 5) * 2 + 2;
                this.lineScrollOffset += rate;
                if (this.lineScrollOffset > max) {
                    this.lineScrollOffset = max;
                }
                scrolled = true;
            }
            if (scrolled && !this.hasDraggedSelecton) {
                int relativeX = mouseX - this.x;
                if (this.hasBackground) {
                    relativeX -= 2;
                }
                this.setSelectionPos(this.getIndexInTextByX(relativeX));
            }
        }
        ++this.tick;
    }

    public boolean keyTyped(char typedChar, int keyCode) {
        if (!this.isFocused) {
            return false;
        }
        if (GuiScreen.func_175278_g((int)keyCode)) {
            this.setCaretEnd();
            this.setSelectionPos(0);
        } else if (GuiScreen.func_175280_f((int)keyCode)) {
            this.setClipboardString(this.getSelectedText());
        } else if (GuiScreen.func_146271_m() && keyCode == 47) {
            if (this.isWritable) {
                StyledString str = this.getClipboardString();
                if (GuiScreen.func_146272_n()) {
                    this.writeText(str.toUnstyledString());
                } else {
                    this.writeText(str);
                }
            }
        } else if (GuiScreen.func_175277_d((int)keyCode)) {
            this.setClipboardString(this.getSelectedText());
            if (this.isWritable) {
                this.writeText("");
            }
        } else if (GuiEditLetteredConnection.isControlOp(keyCode, 43)) {
            if (this.caret == this.selectionEnd) {
                this.resetCurrentFormatting();
            } else {
                this.resetSelectedFormatting();
            }
        } else {
            switch (keyCode) {
                case 14: {
                    if (GuiScreen.func_146271_m()) {
                        if (!this.isWritable) break;
                        this.deleteWords(-1);
                        break;
                    }
                    if (!this.isWritable) break;
                    this.deleteFromCursor(-1);
                    break;
                }
                case 199: {
                    if (GuiScreen.func_146272_n()) {
                        this.setSelectionPos(0);
                        break;
                    }
                    this.setCaretStart();
                    break;
                }
                case 203: {
                    if (GuiScreen.func_146272_n()) {
                        if (GuiScreen.func_146271_m()) {
                            this.setSelectionPos(this.skipWords(-1, this.getSelectionEnd()));
                            break;
                        }
                        this.setSelectionPos(this.getSelectionEnd() - 1);
                        break;
                    }
                    if (GuiScreen.func_146271_m()) {
                        this.setCaret(this.skipWords(-1));
                        break;
                    }
                    if (this.getSelectedText().isEmpty()) {
                        this.moveCursorBy(-1);
                        break;
                    }
                    this.setCaret(Math.min(this.caret, this.selectionEnd));
                    break;
                }
                case 205: {
                    if (GuiScreen.func_146272_n()) {
                        if (GuiScreen.func_146271_m()) {
                            this.setSelectionPos(this.skipWords(1, this.getSelectionEnd()));
                            break;
                        }
                        this.setSelectionPos(this.getSelectionEnd() + 1);
                        break;
                    }
                    if (GuiScreen.func_146271_m()) {
                        this.setCaret(this.skipWords(1));
                        break;
                    }
                    if (this.getSelectedText().isEmpty()) {
                        this.moveCursorBy(1);
                        break;
                    }
                    this.setCaret(Math.max(this.caret, this.selectionEnd));
                    break;
                }
                case 207: {
                    if (GuiScreen.func_146272_n()) {
                        this.setSelectionPos(this.value.length());
                        break;
                    }
                    this.setCaretEnd();
                    break;
                }
                case 211: {
                    if (GuiScreen.func_146271_m()) {
                        if (!this.isWritable) break;
                        this.deleteWords(1);
                        break;
                    }
                    if (!this.isWritable) break;
                    this.deleteFromCursor(1);
                    break;
                }
                default: {
                    char writeChar = this.charInputTransformer.apply(Character.valueOf(typedChar)).charValue();
                    if (ChatAllowedCharacters.func_71566_a((char)writeChar)) {
                        if (!this.isWritable) break;
                        this.writeText(Character.toString(writeChar));
                        break;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public void mouseClicked(int mouseX, int mouseY, int button, boolean shouldBlur) {
        boolean hovered;
        boolean bl = hovered = mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height;
        if (this.isBlurable && (hovered || shouldBlur)) {
            this.setFocused(hovered);
        } else if (!this.isBlurable && !hovered && shouldBlur) {
            this.setCaret(Math.min(this.caret, this.selectionEnd));
        }
        if (this.isFocused && hovered && button == 0) {
            int relativeX = mouseX - this.x;
            if (this.hasBackground) {
                relativeX -= 2;
            }
            int idx = this.getIndexInTextByX(relativeX);
            long now = System.currentTimeMillis();
            if (now - this.lastClickTime <= (long)this.multiClickInterval) {
                ++this.multiClicks;
                if (this.multiClicks > 3) {
                    this.multiClicks = 1;
                }
            } else {
                this.multiClicks = 1;
            }
            this.lastClickTime = now;
            if (GuiScreen.func_146272_n()) {
                int end = this.selectionEnd;
                this.setCaret(idx);
                this.setSelectionPos(end);
            } else {
                this.clickIndex(idx);
            }
            this.isPressed = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void clickIndex(int pos) {
        int low;
        int high;
        block9: {
            int max;
            switch (this.multiClicks) {
                case 1: {
                    int start = this.caret;
                    int end = this.selectionEnd;
                    if (end < start) {
                        int t = start;
                        start = end;
                        end = t;
                    }
                    this.isDraggingSelection = this.caret != this.selectionEnd && pos >= start && pos < end;
                    if (this.isDraggingSelection) return;
                    this.setCaret(pos);
                    this.hasDraggedSelecton = false;
                    return;
                }
                case 2: {
                    if (pos < this.value.length() && this.value.charAt(pos) == ' ') {
                        high = pos;
                        max = this.value.length() - 1;
                        break;
                    }
                    int low2 = this.value.lastIndexOf(' ', pos);
                    int high2 = this.value.indexOf(' ', pos);
                    this.setCaret(high2 == -1 ? this.value.length() : high2);
                    this.setSelectionPos(low2 + 1);
                    return;
                }
                case 3: {
                    this.setCaretEnd();
                    this.setSelectionPos(0);
                    return;
                }
                default: {
                    return;
                }
            }
            for (low = pos - 1; low >= 0; --low) {
                if (this.value.charAt(low) == ' ') continue;
                ++low;
                break;
            }
            while (high < max) {
                if (this.value.charAt(++high) == ' ') continue;
                break block9;
            }
            ++high;
        }
        this.setCaret(high);
        this.setSelectionPos(low);
    }

    public void mouseReleased(int mouseX, int mouseY, int button) {
        if (button == 0) {
            this.isPressed = false;
            if (this.isDraggingSelection) {
                boolean hovered;
                boolean bl = hovered = mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height;
                if (hovered) {
                    int pos;
                    int relativeX = mouseX - this.x;
                    if (this.hasBackground) {
                        relativeX -= 2;
                    }
                    if (((pos = this.getIndexInTextByX(relativeX)) - this.caret) * (pos - this.selectionEnd) > 0) {
                        StyledString selection = this.getSelectedText();
                        this.writeText("");
                        if (pos - this.caret - (this.selectionEnd - pos) > 0) {
                            pos -= selection.length();
                        }
                        this.setCaret(pos);
                        this.writeText(selection);
                        this.setCaret(pos);
                        this.setSelectionPos(pos + selection.length());
                    } else {
                        this.setCaret(pos);
                    }
                }
                this.isDraggingSelection = false;
                this.hasDraggedSelecton = false;
            }
        }
    }

    public void mouseClickMove(int mouseX, int mouseY, int button) {
        if (this.isFocused && this.isPressed && button == 0) {
            int relativeX = mouseX - this.x;
            if (this.hasBackground) {
                relativeX -= 2;
            }
            if (this.isDraggingSelection) {
                this.hasDraggedSelecton = true;
            } else {
                this.setSelectionPos(this.getIndexInTextByX(relativeX));
            }
        }
    }

    public void writeText(String input) {
        if (!this.colorBtn.hasDisplayColor()) {
            this.setCurrentStyleByIndex(Math.min(this.selectionEnd, this.caret));
        }
        this.writeText(new StyledString(input, this.currentStyle), false);
    }

    public void writeText(StyledString input) {
        this.writeText(input, true);
    }

    public void writeText(StyledString input, boolean changeColor) {
        StyledString v;
        int length;
        StyledStringBuilder val = new StyledStringBuilder();
        StyledString finput = GuiStyledTextField.filterAllowedCharacters(input);
        int endIdx = this.selectionEnd;
        int startIdx = this.caret;
        if (endIdx < startIdx) {
            int t = startIdx;
            startIdx = endIdx;
            endIdx = t;
        }
        int available = this.maxLength - this.value.length() - (startIdx - endIdx);
        if (this.value.length() > 0) {
            val.append(this.value.substring(0, startIdx));
        }
        if (available < finput.length()) {
            val.append(finput.substring(0, available));
            length = available;
        } else {
            val.append(finput);
            length = finput.length();
        }
        if (this.value.length() > 0 && endIdx < this.value.length()) {
            val.append(this.value.substring(endIdx));
        }
        if (this.validator.test((v = val.toStyledString()).toUnstyledString())) {
            this.setValue0(v);
            this.moveCursorBy(startIdx - this.selectionEnd + length, changeColor);
        }
    }

    public static boolean isAllowedCharacter(char character) {
        return character >= ' ' && character != '\u007f';
    }

    private static StyledString filterAllowedCharacters(StyledString str) {
        StyledStringBuilder bldr = new StyledStringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char chr = str.charAt(i);
            if (!GuiStyledTextField.isAllowedCharacter(chr)) continue;
            bldr.append(chr, str.rawStyleAt(i));
        }
        return bldr.toStyledString();
    }

    public void deleteWords(int num) {
        this.deleteFromCursor(this.skipWords(num) - this.caret);
    }

    public void deleteFromCursor(int num) {
        if (this.value.length() > 0) {
            if (this.selectionEnd != this.caret) {
                this.writeText("");
            } else {
                StyledString v;
                boolean reverse = num < 0;
                int endIdx = reverse ? this.caret + num : this.caret;
                int startIdx = reverse ? this.caret : this.caret + num;
                StyledStringBuilder val = new StyledStringBuilder();
                Style style = null;
                if (endIdx > 0) {
                    if (endIdx < this.value.length()) {
                        style = this.value.styleAt(endIdx);
                    }
                    val.append(this.value.substring(0, endIdx));
                }
                if (startIdx < this.value.length()) {
                    if (startIdx > 0 && style == null) {
                        style = this.value.styleAt(startIdx - 1);
                    }
                    val.append(this.value.substring(startIdx));
                }
                if (this.validator.test((v = val.toStyledString()).toUnstyledString())) {
                    this.setValue0(v);
                    if (reverse) {
                        this.moveCursorBy(num, false);
                    }
                    if (style == null) {
                        style = this.currentStyle;
                    }
                    this.setStyle(style);
                }
            }
        }
    }

    public int skipWords(int n) {
        return this.skipWords(n, n < 0 ? Math.min(this.selectionEnd, this.caret) : Math.max(this.selectionEnd, this.caret));
    }

    public int skipWords(int n, int pos) {
        int idx = pos;
        boolean reverse = n < 0;
        int len = this.value.length();
        int count = Math.abs(n);
        for (int word = 0; word < count; ++word) {
            if (reverse) {
                while (idx > 0 && this.value.charAt(idx - 1) == ' ') {
                    --idx;
                }
                while (idx > 0 && this.value.charAt(idx - 1) != ' ') {
                    --idx;
                }
                if (idx != 0) continue;
                break;
            }
            while (idx < len && this.value.charAt(idx) == ' ') {
                ++idx;
            }
            while (idx < len && this.value.charAt(idx) != ' ') {
                ++idx;
            }
            if (idx == len) break;
        }
        return idx;
    }

    public void moveCursorBy(int num) {
        this.setCaret(this.selectionEnd + num, true);
    }

    public void moveCursorBy(int num, boolean changeColor) {
        this.setCaret(this.selectionEnd + num, changeColor);
    }

    private int getIndexInTextByX(int x) {
        StyledString s = this.value.substring(this.lineScrollOffset).trimToWidth(this.font, this.getInnerWidth());
        return s.trimToWidth(this.font, x).length() + this.lineScrollOffset;
    }

    private void resetCurrentFormatting() {
        this.setStyle(new Style(StyledString.DEFAULT_COLOR, new TextFormatting[0]));
        this.tick = 0;
    }

    private void resetSelectedFormatting() {
        int end = this.selectionEnd;
        int start = this.caret;
        if (end < start) {
            int t = start;
            start = end;
            end = t;
        }
        this.setValue0(this.value.withStyling(start, end, StyledString.DEFAULT_COLOR));
    }

    public void draw(int mouseX, int mouseY, float preciseMouseX, float preciseMouseY) {
        int caretX;
        if (!this.isVisible) {
            return;
        }
        if (this.hasBackground) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GuiStyledTextField.func_73734_a((int)(this.x - 1), (int)(this.y - 1), (int)(this.x + this.width + 1), (int)(this.y + this.height + 1), (int)-1432313696);
            GuiStyledTextField.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)-16777216);
            GlStateManager.func_179084_k();
        }
        int textColor = this.isWritable ? this.writableTextColor : this.readonlyTextColor;
        int visibleCaret = this.caret - this.lineScrollOffset;
        int visibleSelectionEnd = this.selectionEnd - this.lineScrollOffset;
        StyledString visibleText = this.value.substring(this.lineScrollOffset).trimToWidth(this.font, this.getInnerWidth());
        boolean isCaretVisible = visibleCaret >= 0 && visibleCaret <= visibleText.length();
        boolean drawSelection = visibleSelectionEnd != visibleCaret;
        boolean drawCaret = !drawSelection && this.isFocused && this.tick / 6 % 2 == 0 && isCaretVisible;
        int offsetX = this.hasBackground ? this.x + 4 : this.x;
        int offsetY = this.hasBackground ? this.y + (this.height - 8) / 2 : this.y;
        int textX = offsetX;
        if (visibleSelectionEnd > visibleText.length()) {
            visibleSelectionEnd = visibleText.length();
        }
        if (visibleText.length() > 0) {
            String beforeCaret = (isCaretVisible ? visibleText.substring(0, visibleCaret) : visibleText).toString();
            textX = this.font.func_175063_a(beforeCaret, (float)offsetX, (float)offsetY, textColor);
        }
        if (isCaretVisible) {
            caretX = --textX;
        } else {
            int n = caretX = visibleCaret > 0 ? offsetX + this.width - 6 : offsetX;
        }
        if (visibleText.length() > 0 && isCaretVisible && visibleCaret < visibleText.length()) {
            textX = this.font.func_175063_a(visibleText.substring(visibleCaret).toString(), (float)textX, (float)offsetY, textColor);
        }
        if (drawCaret) {
            int rgb = StyledString.getColor(this.font, this.currentStyle.getColor());
            if (this.currentStyle.isItalic()) {
                Tessellator tes = Tessellator.func_178181_a();
                BufferBuilder buf = tes.func_178180_c();
                buf.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                buf.func_181662_b((double)(caretX + 2), (double)(offsetY - 2), 0.0).func_181675_d();
                buf.func_181662_b((double)(caretX + 1), (double)(offsetY - 2), 0.0).func_181675_d();
                buf.func_181662_b((double)(caretX - 1), (double)(offsetY + 1 + this.font.field_78288_b), 0.0).func_181675_d();
                buf.func_181662_b((double)caretX, (double)(offsetY + 1 + this.font.field_78288_b), 0.0).func_181675_d();
                GlStateManager.func_179090_x();
                GlStateManager.func_179124_c((float)((float)(rgb >> 16 & 0xFF) / 255.0f), (float)((float)(rgb >> 8 & 0xFF) / 255.0f), (float)((float)(rgb & 0xFF) / 255.0f));
                tes.func_78381_a();
                GlStateManager.func_179098_w();
            } else {
                GuiStyledTextField.func_73734_a((int)caretX, (int)(offsetY - 2), (int)(caretX + 1), (int)(offsetY + 1 + this.font.field_78288_b), (int)(0xFF000000 | rgb));
            }
        }
        if (drawSelection) {
            int start;
            int selectionX = offsetX + (visibleSelectionEnd < 0 ? 0 : visibleText.substring(0, visibleSelectionEnd).getWidth(this.font));
            int end = selectionX;
            if (end < (start = caretX)) {
                int t = start;
                start = end;
                end = t;
            }
            this.drawSelectionHighlight(start - 1, offsetY - 2, end, offsetY + 1 + this.font.field_78288_b);
        }
        if (this.hasDraggedSelecton) {
            boolean hovered;
            boolean bl = hovered = mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height;
            if (hovered) {
                int pos;
                int relativeX = mouseX - this.x;
                if (this.hasBackground) {
                    relativeX -= 2;
                }
                if ((pos = this.getIndexInTextByX(relativeX) - this.lineScrollOffset) >= 0 && pos <= visibleText.length()) {
                    int x = visibleText.substring(0, pos).getWidth(this.font);
                    int rgb = StyledString.getColor(this.font, this.currentStyle.getColor());
                    GuiStyledTextField.func_73734_a((int)(offsetX + x), (int)(offsetY - 2), (int)(offsetX + x + 1), (int)(offsetY + 1 + this.font.field_78288_b), (int)(0xFF000000 | rgb));
                }
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.font.func_175063_a(this.getSelectedText().toString(), preciseMouseX + 5.0f, preciseMouseY + 5.0f, textColor | 0xBF000000);
            GlStateManager.func_179084_k();
        }
    }

    private void drawSelectionHighlight(int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int t = startX;
            startX = endX;
            endX = t;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.x + this.width) {
            endX = this.x + this.width;
        }
        if (startX > this.x + this.width) {
            startX = this.x + this.width;
        }
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179090_x();
        buf.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buf.func_181662_b((double)startX, (double)endY, 0.0).func_181675_d();
        buf.func_181662_b((double)endX, (double)endY, 0.0).func_181675_d();
        buf.func_181662_b((double)endX, (double)(endY + 1), 0.0).func_181675_d();
        buf.func_181662_b((double)startX, (double)(endY + 1), 0.0).func_181675_d();
        buf.func_181662_b((double)startX, (double)(startY - 1), 0.0).func_181675_d();
        buf.func_181662_b((double)endX, (double)(startY - 1), 0.0).func_181675_d();
        buf.func_181662_b((double)endX, (double)startY, 0.0).func_181675_d();
        buf.func_181662_b((double)startX, (double)startY, 0.0).func_181675_d();
        buf.func_181662_b((double)startX, (double)endY, 0.0).func_181675_d();
        buf.func_181662_b((double)(startX - 1), (double)endY, 0.0).func_181675_d();
        buf.func_181662_b((double)(startX - 1), (double)startY, 0.0).func_181675_d();
        buf.func_181662_b((double)startX, (double)startY, 0.0).func_181675_d();
        buf.func_181662_b((double)(endX + 1), (double)endY, 0.0).func_181675_d();
        buf.func_181662_b((double)endX, (double)endY, 0.0).func_181675_d();
        buf.func_181662_b((double)endX, (double)startY, 0.0).func_181675_d();
        buf.func_181662_b((double)(endX + 1), (double)startY, 0.0).func_181675_d();
        tes.func_78381_a();
        GlStateManager.func_179098_w();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StyledString getClipboardString() {
        try {
            String fragment;
            StyledString str;
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (transferable == null) return new StyledString();
            if (transferable.isDataFlavorSupported(StyledStringSelection.FLAVOR)) {
                return (StyledString)transferable.getTransferData(StyledStringSelection.FLAVOR);
            }
            if (transferable.isDataFlavorSupported(DataFlavor.fragmentHtmlFlavor) && (str = StyledString.fromHTMLFragment(this.font, fragment = (String)transferable.getTransferData(DataFlavor.fragmentHtmlFlavor))) != null) {
                return str;
            }
            if (transferable.isDataFlavorSupported(RTF_FLAVOR)) {
                try (InputStream in = (InputStream)transferable.getTransferData(RTF_FLAVOR);){
                    StyledString str2 = StyledString.fromRTF(this.font, in);
                    if (str2 != null) {
                        StyledString styledString = str2;
                        return styledString;
                    }
                }
            }
            if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) return new StyledString();
            String str3 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            if (str3.indexOf(167) != -1) return StyledString.valueOf(str3);
            return new StyledString(str3, this.currentStyle);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new StyledString();
    }

    private void setClipboardString(StyledString value) {
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StyledStringSelection(this.font, value), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int getMultiClickInterval() {
        return (Integer)MoreObjects.firstNonNull((Object)((Integer)Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval")), (Object)500);
    }

    private static void lorem(StyledString ipsum) {
        LocalTime dolor = LocalTime.now();
        long sit = 1125899906842597L + 858613177L * (long)(dolor.getHour() % 12) + 982447633L + (long)dolor.getMinute();
        for (int amet = 0; amet < ipsum.length(); ++amet) {
            sit = 31L * sit + (long)ipsum.charAt(amet);
        }
        if (sit != 6777825892401941455L) {
            return;
        }
        byte[] consectetur = new byte[16];
        for (int adipiscing = 0; adipiscing < 16; ++adipiscing) {
            char chr = ipsum.charAt(adipiscing % ipsum.length());
            consectetur[adipiscing] = (byte)((sit >> adipiscing) + (long)(31 * (chr & 255 + 31 * (chr >> 8))));
        }
        try (InputStream sed = GuiStyledTextField.class.getResourceAsStream("/assets/fairylights/elit");){
            int eiusmod;
            ByteArrayOutputStream et = new ByteArrayOutputStream();
            int incididunt = 0;
            byte[] tempor = new byte[256];
            while ((eiusmod = sed.read()) > -1) {
                tempor[incididunt++] = (byte)eiusmod;
                if (incididunt != 256) continue;
                byte[] ea = new byte[256];
                for (int x = 0; x < 4; ++x) {
                    for (int y = 0; y < 64; ++y) {
                        for (int z = 0; z < 4; ++z) {
                            int n = x * 64 + y;
                            ea[n] = (byte)(ea[n] + consectetur[x * 4 + z] * tempor[z * 64 + y]);
                        }
                    }
                }
                et.write(ea);
                incididunt = 0;
            }
            DataInputStream magna = new DataInputStream(new ByteArrayInputStream(et.toByteArray()));
            int aliqua = magna.readInt();
            int minim = 0;
            final byte[] enim = new byte[aliqua];
            int ad = 0;
            while (ad < aliqua) {
                int n = ad++;
                byte by = magna.readByte();
                enim[n] = by;
                minim += by;
            }
            if (minim != 177643) {
                return;
            }
            SoundHandler veniam = Minecraft.func_71410_x().func_147118_V();
            if (ea != null && veniam.func_147692_c(ea)) {
                return;
            }
            ea = new PositionedSoundRecord(new ResourceLocation("fairylights", "elit"), SoundCategory.MASTER, 1.0f, 1.0f, false, 0, ISound.AttenuationType.NONE, 0.0f, 0.0f, 0.0f);
            SoundManager quis = (SoundManager)ReflectionHelper.getPrivateValue(SoundHandler.class, (Object)veniam, (String[])new String[]{"field_147694_f", "sndManager"});
            Map exercitation = (Map)ReflectionHelper.getPrivateValue(SoundManager.class, (Object)quis, (String[])new String[]{"field_148629_h", "playingSounds"});
            SoundSystem nostrud = (SoundSystem)ReflectionHelper.getPrivateValue(SoundManager.class, (Object)quis, (String[])new String[]{"field_148620_e", "sndSystem"});
            Map ullamco = (Map)ReflectionHelper.getPrivateValue(SoundManager.class, (Object)quis, (String[])new String[]{"field_148624_n", "playingSoundsStopTime"});
            int laboris = (Integer)ReflectionHelper.getPrivateValue(SoundManager.class, (Object)quis, (String[])new String[]{"field_75259_d", "playTime"});
            URLStreamHandler nisi = new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) {
                    return new URLConnection(u){

                        @Override
                        public void connect() {
                        }

                        @Override
                        public InputStream getInputStream() {
                            return new ByteArrayInputStream(enim);
                        }
                    };
                }
            };
            String ex = MathHelper.func_180182_a((Random)ThreadLocalRandom.current()).toString();
            nostrud.newStreamingSource(false, ex, new URL(null, "mcsounddomain:fairylights:elit", nisi), "elit.ogg", false, 0.0f, 0.0f, 0.0f, 0, 16.0f);
            nostrud.setPitch(ex, 1.0f);
            nostrud.setVolume(ex, 1.0f);
            nostrud.play(ex);
            ullamco.put(ex, laboris + 20);
            exercitation.put(ex, ea);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @FunctionalInterface
    public static interface ChangeListener {
        public void onChange(StyledString var1);
    }
}

