/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.capabilities.shield;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import twilightforest.capabilities.shield.IShieldCapability;
import twilightforest.network.PacketUpdateShield;
import twilightforest.network.TFPacketHandler;

public class ShieldCapabilityHandler
implements IShieldCapability {
    private int temporaryShields;
    private int permamentShields;
    private EntityLivingBase host;
    private int timer = 0;

    @Override
    public void setEntity(EntityLivingBase entity) {
        this.host = entity;
    }

    @Override
    public void update() {
        if (!(this.host.field_70170_p.field_72995_K || this.shieldsLeft() <= 0 || this.timer-- > 0 || this.host instanceof EntityPlayer && ((EntityPlayer)this.host).func_184812_l_())) {
            this.breakShield();
        }
    }

    @Override
    public int shieldsLeft() {
        return this.temporaryShields + this.permamentShields;
    }

    @Override
    public int temporaryShieldsLeft() {
        return this.temporaryShields;
    }

    @Override
    public int permamentShieldsLeft() {
        return this.permamentShields;
    }

    @Override
    public void breakShield() {
        if (this.temporaryShields > 0) {
            --this.temporaryShields;
            this.timer = 240;
        } else if (this.permamentShields > 0) {
            --this.permamentShields;
        }
        this.host.field_70170_p.func_184133_a(null, this.host.func_180425_c(), SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 1.0f, ((this.host.func_70681_au().nextFloat() - this.host.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
        this.sendUpdatePacket();
    }

    @Override
    public void replenishShields() {
        this.setShields(5, true);
        this.host.field_70170_p.func_184133_a(null, this.host.func_180425_c(), SoundEvents.field_187665_Y, SoundCategory.PLAYERS, 1.0f, (this.host.func_70681_au().nextFloat() - this.host.func_70681_au().nextFloat()) * 0.2f + 1.0f);
    }

    @Override
    public void setShields(int amount, boolean temp) {
        if (temp) {
            this.temporaryShields = Math.max(amount, 0);
            this.timer = 240;
        } else {
            this.permamentShields = Math.max(amount, 0);
        }
        this.sendUpdatePacket();
    }

    @Override
    public void addShields(int amount, boolean temp) {
        if (temp) {
            if (this.temporaryShields <= 0) {
                this.timer = 240;
            }
            this.temporaryShields += amount;
        } else {
            this.permamentShields += amount;
        }
        this.sendUpdatePacket();
    }

    private void sendUpdatePacket() {
        if (!this.host.field_70170_p.field_72995_K) {
            PacketUpdateShield message = new PacketUpdateShield((Entity)this.host, (IShieldCapability)this);
            TFPacketHandler.CHANNEL.sendToAllTracking((IMessage)message, (Entity)this.host);
            if (this.host instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)this.host;
                if (player.field_71135_a != null) {
                    TFPacketHandler.CHANNEL.sendTo((IMessage)message, player);
                }
            }
        }
    }
}

