/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class IMCHandler {
    private static final ImmutableSet.Builder<IBlockState> BLACKLIST_BUILDER = ImmutableSet.builder();
    private static final ImmutableList.Builder<IBlockState> ORE_BLOCKS_BUILDER = ImmutableList.builder();
    private static final ImmutableList.Builder<ItemStack> LOADING_ICONS_BUILDER = ImmutableList.builder();
    private static final ImmutableMultimap.Builder<IBlockState, IBlockState> CRUMBLE_BLOCKS_BUILDER = ImmutableMultimap.builder();

    public static void onIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (message.isNBTMessage()) {
                NBTTagCompound imcCompound = message.getNBTValue();
                IMCHandler.deserializeBlockstatesFromTagList(imcCompound.func_150295_c("Blacklist", 10), BLACKLIST_BUILDER);
                IMCHandler.deserializeBlockstatesFromTagList(imcCompound.func_150295_c("Ore_Blocks", 10), ORE_BLOCKS_BUILDER);
                IMCHandler.deserializeBlockstatesFromTagList(imcCompound.func_150295_c("Crumbling", 10), CRUMBLE_BLOCKS_BUILDER);
            }
            if (!message.isItemStackMessage() || !message.key.equals("Loading_Icon")) continue;
            LOADING_ICONS_BUILDER.add((Object)message.getItemStackValue());
        }
    }

    private static void deserializeBlockstatesFromTagList(NBTTagList list, ImmutableMultimap.Builder<IBlockState, IBlockState> builder) {
        for (int blockAt = 0; blockAt < list.func_74745_c(); ++blockAt) {
            NBTTagCompound main = list.func_150305_b(blockAt);
            IBlockState key = NBTUtil.func_190008_d((NBTTagCompound)main);
            if (key.func_177230_c() == Blocks.field_150350_a) continue;
            NBTTagList crumbles = main.func_150295_c("Crumbling", 10);
            for (int crumble = 0; crumble < crumbles.func_74745_c(); ++crumble) {
                IBlockState value = NBTUtil.func_190008_d((NBTTagCompound)crumbles.func_150305_b(crumble));
                builder.put((Object)key, (Object)value);
            }
        }
    }

    private static void deserializeBlockstatesFromTagList(NBTTagList list, ImmutableCollection.Builder<IBlockState> builder) {
        for (int blockAt = 0; blockAt < list.func_74745_c(); ++blockAt) {
            IBlockState state = NBTUtil.func_190008_d((NBTTagCompound)list.func_150305_b(blockAt));
            if (state.func_177230_c() == Blocks.field_150350_a) continue;
            builder.add((Object)state);
        }
    }

    public static ImmutableSet<IBlockState> getBlacklistedBlocks() {
        return BLACKLIST_BUILDER.build();
    }

    public static ImmutableList<IBlockState> getOreBlocks() {
        return ORE_BLOCKS_BUILDER.build();
    }

    public static ImmutableList<ItemStack> getLoadingIconStacks() {
        return LOADING_ICONS_BUILDER.build();
    }

    public static ImmutableMultimap<IBlockState, IBlockState> getCrumblingBlocks() {
        return CRUMBLE_BLOCKS_BUILDER.build();
    }
}

