/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.booklet.page;

import de.ellpeck.actuallyadditions.api.booklet.internal.GuiBookletBase;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.booklet.gui.GuiBooklet;
import de.ellpeck.actuallyadditions.mod.booklet.page.BookletPage;
import de.ellpeck.actuallyadditions.mod.booklet.page.PageTextOnly;
import de.ellpeck.actuallyadditions.mod.util.RefHelp;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import de.ellpeck.actuallyadditions.mod.util.crafting.BlankRecipe;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class PageCrafting
extends BookletPage {
    private final List<IRecipe> recipes;
    private int recipeAt;
    private String recipeTypeLocKey;
    private boolean isWildcard;

    public PageCrafting(int localizationKey, int priority, List<IRecipe> recipes) {
        super(localizationKey, priority);
        this.recipes = recipes;
    }

    public PageCrafting(int localizationKey, List<IRecipe> recipes) {
        this(localizationKey, 0, recipes);
    }

    public PageCrafting(int localizationKey, IRecipe ... recipes) {
        this(localizationKey, 0, recipes);
    }

    public PageCrafting(int localizationKey, int priority, IRecipe ... recipes) {
        this(localizationKey, priority, Arrays.asList(recipes));
    }

    public BookletPage setWildcard() {
        this.isWildcard = true;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawScreenPre(GuiBookletBase gui, int startX, int startY, int mouseX, int mouseY, float partialTicks) {
        super.drawScreenPre(gui, startX, startY, mouseX, mouseY, partialTicks);
        gui.field_146297_k.func_110434_K().func_110577_a(GuiBooklet.RES_LOC_GADGETS);
        GuiUtils.drawTexturedModalRect((int)(startX + 5), (int)(startY + 6), (int)20, (int)0, (int)116, (int)54, (float)0.0f);
        gui.renderScaledAsciiString("(" + StringUtil.localize(this.recipeTypeLocKey) + ")", startX + 6, startY + 65, 0, false, gui.getMediumFontSize());
        PageTextOnly.renderTextToPage(gui, this, startX + 6, startY + 80);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateScreen(GuiBookletBase gui, int startX, int startY, int pageTimer) {
        super.updateScreen(gui, startX, startY, pageTimer);
        if (pageTimer % 20 == 0) {
            this.findRecipe(gui, startX, startY);
        }
    }

    private void findRecipe(GuiBookletBase gui, int startX, int startY) {
        if (!this.recipes.isEmpty()) {
            IRecipe recipe = this.recipes.get(this.recipeAt);
            if (recipe != null) {
                this.setupRecipe(gui, recipe, startX, startY);
            }
            ++this.recipeAt;
            if (this.recipeAt >= this.recipes.size()) {
                this.recipeAt = 0;
            }
        }
    }

    @Override
    public void initGui(GuiBookletBase gui, int startX, int startY) {
        super.initGui(gui, startX, startY);
        this.findRecipe(gui, startX, startY);
    }

    @Override
    public void getItemStacksForPage(List<ItemStack> list) {
        super.getItemStacksForPage(list);
        if (!this.recipes.isEmpty()) {
            for (IRecipe recipe : this.recipes) {
                ItemStack output;
                if (recipe == null || !StackUtil.isValid(output = recipe.func_77571_b())) continue;
                ItemStack copy = output.func_77946_l();
                if (this.isWildcard) {
                    copy.func_77964_b(Short.MAX_VALUE);
                }
                list.add(copy);
            }
        }
    }

    private void setupRecipe(GuiBookletBase gui, IRecipe recipe, int startX, int startY) {
        int i;
        ShapelessRecipes shapeless;
        ShapedRecipes shaped;
        Ingredient[] ings = new Ingredient[9];
        int width = 3;
        int height = 3;
        if (recipe instanceof BlankRecipe) {
            this.recipeTypeLocKey = "tooltip.actuallyadditions.disabled";
            gui.addOrModifyItemRenderer(recipe.func_77571_b(), startX + 100, startY + 25, 1.0f, false);
            return;
        }
        if (recipe instanceof ShapedRecipes) {
            shaped = (ShapedRecipes)recipe;
            width = shaped.field_77576_b;
            height = shaped.field_77577_c;
            ings = (Ingredient[])shaped.field_77574_d.toArray((Object[])new Ingredient[shaped.field_77574_d.size()]);
            this.recipeTypeLocKey = "booklet.actuallyadditions.shapedRecipe";
        } else if (recipe instanceof ShapelessRecipes) {
            shapeless = (ShapelessRecipes)recipe;
            for (i = 0; i < shapeless.field_77579_b.size(); ++i) {
                ings[i] = (Ingredient)shapeless.field_77579_b.get(i);
            }
            this.recipeTypeLocKey = "booklet.actuallyadditions.shapelessRecipe";
        } else if (recipe instanceof ShapedOreRecipe) {
            shaped = (ShapedOreRecipe)recipe;
            try {
                width = (Integer)RefHelp.getPrivateValue(ShapedOreRecipe.class, shaped, 4);
                height = (Integer)RefHelp.getPrivateValue(ShapedOreRecipe.class, shaped, 5);
            }
            catch (Exception e) {
                ActuallyAdditions.LOGGER.error("Something went wrong trying to get the Crafting Recipe in the booklet to display!", (Throwable)e);
            }
            for (i = 0; i < shaped.func_192400_c().size(); ++i) {
                ings[i] = (Ingredient)shaped.func_192400_c().get(i);
            }
            this.recipeTypeLocKey = "booklet.actuallyadditions.shapedOreRecipe";
        } else if (recipe instanceof ShapelessOreRecipe) {
            shapeless = (ShapelessOreRecipe)recipe;
            for (i = 0; i < shapeless.func_192400_c().size(); ++i) {
                ings[i] = (Ingredient)shapeless.func_192400_c().get(i);
            }
            this.recipeTypeLocKey = "booklet.actuallyadditions.shapelessOreRecipe";
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                ItemStack stack;
                ItemStack[] stacks;
                Ingredient ing = ings[y * width + x];
                if (ing == null || (stacks = ing.func_193365_a()) == null || stacks.length <= 0 || !StackUtil.isValid(stack = stacks[0])) continue;
                ItemStack copy = stack.func_77946_l();
                copy.func_190920_e(1);
                if (copy.func_77952_i() == Short.MAX_VALUE) {
                    copy.func_77964_b(0);
                }
                gui.addOrModifyItemRenderer(copy, startX + 6 + x * 18, startY + 7 + y * 18, 1.0f, true);
            }
        }
        gui.addOrModifyItemRenderer(recipe.func_77571_b(), startX + 100, startY + 25, 1.0f, false);
    }
}

