/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import java.awt.Color;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL20;
import teamroots.embers.EventManager;
import teamroots.embers.util.EmberGenUtil;
import teamroots.embers.util.Misc;
import teamroots.embers.util.NoiseGenUtil;
import teamroots.embers.util.ShaderUtil;
import teamroots.embers.util.StructUV;

public class RenderUtil {
    public static int lightx = 0xF000F0;
    public static int lighty = 0xF000F0;
    public static final float root2over2 = (float)Math.sqrt(2.0) / 2.0f;
    public static final Pattern COLOR_CODE_MATCHER = Pattern.compile("\u00c2\u00a7[0-9a-f]");

    public static void renderWavyEmberLine(BufferBuilder b, double x1, double y1, double x2, double y2, double thickness) {
        RenderUtil.renderWavyEmberLine(b, x1, y1, x2, y2, thickness, 1.0, new Color(255, 64, 16));
    }

    public static void renderWavyEmberLine(BufferBuilder b, double x1, double y1, double x2, double y2, double thickness, double density, Color color) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double angleRads = Math.atan2(y2 - y1, x2 - x1);
        double dist = Math.sqrt(dx * dx + dy * dy);
        double orthoX = Math.cos(angleRads + 1.5707963267948966);
        double orthoY = Math.sin(angleRads + 1.5707963267948966);
        double rayX = Math.cos(angleRads);
        double rayY = Math.sin(angleRads);
        for (int i = 0; i <= 10; ++i) {
            float coeff = (float)i / 10.0f;
            double thickCoeff = Math.min(1.0, (double)(1.4f * MathHelper.func_76129_c((float)(2.0f * (0.5f - Math.abs(coeff - 0.5f))))));
            double tx = x1 * (double)(1.0f - coeff) + x2 * (double)coeff;
            double ty = NoiseGenUtil.interpolate((float)y1, (float)y2, coeff);
            float tick = Minecraft.func_71410_x().func_184121_ak() + (float)EventManager.ticks;
            int offX = (int)(6.0f * tick);
            int offZ = (int)(6.0f * tick);
            float sine = (float)Math.sin((double)coeff * Math.PI * 2.0 + (double)(0.25f * tick)) + 0.25f * (float)Math.sin((double)coeff * Math.PI * (double)3.47f + (double)(0.25f * tick));
            float sineOff = (4.0f + (float)thickness) / 3.0f;
            float densityCoeff = (float)(0.5 + 0.5 * Math.sin((double)coeff * Math.PI * 2.0 * dist * 0.01 + (double)tick * 0.2));
            float minusDensity = (float)density * densityCoeff * EmberGenUtil.getEmberDensity(1L, offX + (int)(tx - thickness * orthoX * thickCoeff), offZ + (int)(ty - thickness * orthoY * thickCoeff));
            float plusDensity = (float)density * densityCoeff * EmberGenUtil.getEmberDensity(1L, offX + (int)(tx - thickness * orthoX * thickCoeff), offZ + (int)(ty - thickness * orthoY * thickCoeff));
            b.func_181662_b(tx - thickness * (double)(0.5f + minusDensity) * orthoX * thickCoeff - thickCoeff * orthoX * (double)sine * (double)sineOff, ty - thickness * (double)(0.5f + minusDensity) * orthoY * thickCoeff - thickCoeff * orthoY * (double)sine * (double)sineOff, 0.0).func_181666_a((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)Math.pow(0.5f * (float)Math.max(0.0, thickCoeff - (double)0.4f) * minusDensity, 1.0)).func_181675_d();
            b.func_181662_b(tx + thickness * (double)(0.5f + plusDensity) * orthoX * thickCoeff - thickCoeff * orthoX * (double)sine * (double)sineOff, ty + thickness * (double)(0.5f + plusDensity) * orthoY * thickCoeff - thickCoeff * orthoY * (double)sine * (double)sineOff, 0.0).func_181666_a((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)Math.pow(0.5f * (float)Math.max(0.0, thickCoeff - (double)0.4f) * plusDensity, 1.0)).func_181675_d();
        }
    }

    public static void renderHighlightCircle(BufferBuilder b, double x1, double y1, double thickness) {
        RenderUtil.renderHighlightCircle(b, x1, y1, thickness, 0.0, new Color(255, 64, 16));
    }

    public static void renderHighlightCircle(BufferBuilder b, double x1, double y1, double thickness, double z, Color color) {
        for (int i = 0; i < 40; ++i) {
            float coeff = (float)i / 40.0f;
            int i2 = i + 1;
            if (i2 == 40) {
                i2 = 0;
            }
            float coeff2 = (float)i2 / 40.0f;
            double angle = Math.PI * 2 * (double)coeff;
            double angle2 = Math.PI * 2 * (double)coeff2;
            float tick = Minecraft.func_71410_x().func_184121_ak() + (float)EventManager.ticks;
            double calcAngle2 = angle2;
            float density1 = EmberGenUtil.getEmberDensity(4L, (int)x1 + (int)(480.0 * angle), (int)y1 + 4 * (int)tick + (int)(4.0 * thickness));
            float density2 = EmberGenUtil.getEmberDensity(4L, (int)x1 + (int)(480.0 * calcAngle2), (int)y1 + 4 * (int)tick + (int)(4.0 * thickness));
            double tx = x1 + Math.sin(angle + (double)(0.03125f * tick)) * (thickness - thickness * 0.5 * (double)density1);
            double ty = y1 + Math.cos(angle + (double)(0.03125f * tick)) * (thickness - thickness * 0.5 * (double)density1);
            double tx2 = x1 + Math.sin(angle2 + (double)(0.03125f * tick)) * (thickness - thickness * 0.5 * (double)density2);
            double ty2 = y1 + Math.cos(angle2 + (double)(0.03125f * tick)) * (thickness - thickness * 0.5 * (double)density2);
            b.func_181662_b(x1, y1, z).func_181666_a((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f).func_181675_d();
            b.func_181662_b(tx, ty, z).func_181666_a((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.0f).func_181675_d();
            b.func_181662_b(tx2, ty2, z).func_181666_a((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.0f).func_181675_d();
        }
    }

    public static void renderRadiantCircle(BufferBuilder b, double x, double y, double radius) {
        for (int i = 0; i < 20; ++i) {
            double angle = Math.PI * 2 * (double)i / 20.0;
            double angle2 = Math.PI * 2 * (double)(i + 1) / 20.0;
            float tick = Minecraft.func_71410_x().func_184121_ak() + (float)EventManager.ticks;
            double radiusBonus = EmberGenUtil.getEmberDensity(4L, (int)(20.0 * angle), (int)tick);
            double tx = x + Math.cos(angle) * 40.0;
            double ty = y + Math.sin(angle) * 40.0;
            double tx2 = x + Math.cos(angle2) * 40.0;
            double ty2 = y + Math.sin(angle2) * 40.0;
            b.func_181662_b(x, y, 0.0).func_181666_a(1.0f, 0.25f, 0.0625f, 1.0f).func_181675_d();
            b.func_181662_b(tx, ty, 0.0).func_181666_a(1.0f, 0.25f, 0.0625f, 1.0f).func_181675_d();
            b.func_181662_b(tx2, ty2, 0.0).func_181666_a(1.0f, 0.25f, 0.0625f, 1.0f).func_181675_d();
        }
    }

    public static void renderBeam(BufferBuilder buf, double x1, double y1, double z1, double x2, double y2, double z2, float r, float g, float b, float a, float radius, double angle) {
        double yaw = Misc.yawDegreesBetweenPoints(x1, y1, z1, x2, y2, z2);
        double pitch = Misc.pitchDegreesBetweenPoints(x1, y1, z1, x2, y2, z2);
        float yawCos = MathHelper.func_76134_b((float)((float)Math.toRadians(yaw)));
        float yawSin = MathHelper.func_76126_a((float)((float)Math.toRadians(yaw)));
        float pitchCos = MathHelper.func_76134_b((float)((float)Math.toRadians(pitch)));
        float pitchSin = MathHelper.func_76126_a((float)((float)Math.toRadians(pitch)));
        float angCos = MathHelper.func_76134_b((float)((float)Math.toRadians(angle)));
        float angSin = MathHelper.func_76126_a((float)((float)Math.toRadians(angle)));
        float dxh = radius * yawCos * pitchCos;
        float dyh = 0.0f;
        float dzh = radius * -yawSin * pitchCos;
        float dxv = radius * 0.5f * -yawSin * pitchSin;
        float dyv = radius * 0.5f * pitchCos;
        float dzv = radius * 0.5f * -yawCos * pitchSin;
        float dx = dxh * angCos + dxv * angSin;
        float dy = dyh * angCos + dyv * angSin;
        float dz = dzh * angCos + dzv * angSin;
        float dx2 = dxh * -angSin + dxv * angCos;
        float dy2 = dyh * -angSin + dyv * angCos;
        float dz2 = dzh * -angSin + dzv * angCos;
        double distX = x2 - x1;
        double distY = y2 - y1;
        double distZ = z2 - z1;
        buf.func_181662_b(x1 - (double)dx, y1 - (double)dy, z1 - (double)dz).func_187315_a(0.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, 0.0f).func_181675_d();
        buf.func_181662_b(x1 + (double)dx, y1 + (double)dy, z1 + (double)dz).func_187315_a(0.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, 0.0f).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.1f + (double)dx, y1 + distY * (double)0.1f + (double)dy, z1 + distZ * (double)0.1f + (double)dz).func_187315_a(1.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.1f - (double)dx, y1 + distY * (double)0.1f - (double)dy, z1 + distZ * (double)0.1f - (double)dz).func_187315_a(1.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 - (double)dx2, y1 - (double)dy2, z1 - (double)dz2).func_187315_a(0.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, 0.0f).func_181675_d();
        buf.func_181662_b(x1 + (double)dx2, y1 + (double)dy2, z1 + (double)dz2).func_187315_a(0.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, 0.0f).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.1f + (double)dx2, y1 + distY * (double)0.1f + (double)dy2, z1 + distZ * (double)0.1f + (double)dz2).func_187315_a(1.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.1f - (double)dx2, y1 + distY * (double)0.1f - (double)dy2, z1 + distZ * (double)0.1f - (double)dz2).func_187315_a(1.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.1f - (double)dx, y1 + distY * (double)0.1f - (double)dy, z1 + distZ * (double)0.1f - (double)dz).func_187315_a(0.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.1f + (double)dx, y1 + distY * (double)0.1f + (double)dy, z1 + distZ * (double)0.1f + (double)dz).func_187315_a(0.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.9f + (double)dx, y1 + distY * (double)0.9f + (double)dy, z1 + distZ * (double)0.9f + (double)dz).func_187315_a(1.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.9f - (double)dx, y1 + distY * (double)0.9f - (double)dy, z1 + distZ * (double)0.9f - (double)dz).func_187315_a(1.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.1f - (double)dx2, y1 + distY * (double)0.1f - (double)dy2, z1 + distZ * (double)0.1f - (double)dz2).func_187315_a(0.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.1f + (double)dx2, y1 + distY * (double)0.1f + (double)dy2, z1 + distZ * (double)0.1f + (double)dz2).func_187315_a(0.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.9f + (double)dx2, y1 + distY * (double)0.9f + (double)dy2, z1 + distZ * (double)0.9f + (double)dz2).func_187315_a(1.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.9f - (double)dx2, y1 + distY * (double)0.9f - (double)dy2, z1 + distZ * (double)0.9f - (double)dz2).func_187315_a(1.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.9f - (double)dx, y1 + distY * (double)0.9f - (double)dy, z1 + distZ * (double)0.9f - (double)dz).func_187315_a(0.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.9f + (double)dx, y1 + distY * (double)0.9f + (double)dy, z1 + distZ * (double)0.9f + (double)dz).func_187315_a(0.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX + (double)dx, y1 + distY + (double)dy, z1 + distZ + (double)dz).func_187315_a(1.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, 0.0f).func_181675_d();
        buf.func_181662_b(x1 + distX - (double)dx, y1 + distY - (double)dy, z1 + distZ - (double)dz).func_187315_a(1.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, 0.0f).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.9f - (double)dx2, y1 + distY * (double)0.9f - (double)dy2, z1 + distZ * (double)0.9f - (double)dz2).func_187315_a(0.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.9f + (double)dx2, y1 + distY * (double)0.9f + (double)dy2, z1 + distZ * (double)0.9f + (double)dz2).func_187315_a(0.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX + (double)dx2, y1 + distY + (double)dy2, z1 + distZ + (double)dz2).func_187315_a(1.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, 0.0f).func_181675_d();
        buf.func_181662_b(x1 + distX - (double)dx2, y1 + distY - (double)dy2, z1 + distZ - (double)dz2).func_187315_a(1.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, 0.0f).func_181675_d();
    }

    public static void renderAlchemyCircle(BufferBuilder buf, double x, double y, double z, float r, float g, float b, float a, double radius, double angle) {
        double sign = 1.0;
        if (Minecraft.func_71410_x().field_71439_g.field_70163_u + (double)Minecraft.func_71410_x().field_71439_g.func_70047_e() < y) {
            sign = -1.0;
        }
        int lightx = 0xF000F0;
        int lighty = 0xF000F0;
        for (double i = 0.0; i < 360.0; i += 10.0) {
            double tx = Math.sin(Math.toRadians(i + angle));
            double tz = Math.cos(Math.toRadians(i + angle));
            double tx2 = Math.sin(Math.toRadians(i + angle + 10.0));
            double tz2 = Math.cos(Math.toRadians(i + angle + 10.0));
            buf.func_181662_b(x + radius * tx, y, z + radius * tz).func_187315_a(0.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
            buf.func_181662_b(x + (radius + 0.25) * tx, y, z + (radius + 0.25) * tz).func_187315_a(0.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
            buf.func_181662_b(x + (radius + 0.25) * tx2, y, z + (radius + 0.25) * tz2).func_187315_a(1.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
            buf.func_181662_b(x + radius * tx2, y, z + radius * tz2).func_187315_a(1.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        }
        double ax = (radius + 0.24) * Math.sin(Math.toRadians(0.0 + angle));
        double az = (radius + 0.24) * Math.cos(Math.toRadians(0.0 + angle));
        double adx = 0.1875 * Math.cos(Math.toRadians(0.0 + angle));
        double adz = 0.1875 * -Math.sin(Math.toRadians(0.0 + angle));
        double bx = (radius + 0.24) * Math.sin(Math.toRadians(120.0 + angle));
        double bz = (radius + 0.24) * Math.cos(Math.toRadians(120.0 + angle));
        double bdx = 0.1875 * Math.cos(Math.toRadians(120.0 + angle));
        double bdz = 0.1875 * -Math.sin(Math.toRadians(120.0 + angle));
        double cx = (radius + 0.24) * Math.sin(Math.toRadians(240.0 + angle));
        double cz = (radius + 0.24) * Math.cos(Math.toRadians(240.0 + angle));
        double cdx = 0.1875 * Math.cos(Math.toRadians(240.0 + angle));
        double cdz = 0.1875 * -Math.sin(Math.toRadians(240.0 + angle));
        buf.func_181662_b(x + (ax - adx), y + 5.0E-5 * sign, z + (az - adz)).func_187315_a(0.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x + (ax + adx), y + 5.0E-5 * sign, z + (az + adz)).func_187315_a(0.0, 1.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x + (bx - bdx), y + 5.0E-5 * sign, z + (bz - bdz)).func_187315_a(1.0, 1.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x + (bx + bdx), y + 5.0E-5 * sign, z + (bz + bdz)).func_187315_a(1.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x + (bx - bdx), y + 1.0E-4 * sign, z + (bz - bdz)).func_187315_a(0.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x + (bx + bdx), y + 1.0E-4 * sign, z + (bz + bdz)).func_187315_a(0.0, 1.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x + (cx - cdx), y + 1.0E-4 * sign, z + (cz - cdz)).func_187315_a(1.0, 1.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x + (cx + cdx), y + 1.0E-4 * sign, z + (cz + cdz)).func_187315_a(1.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x + (ax - adx), y + 1.5E-4 * sign, z + (az - adz)).func_187315_a(0.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x + (ax + adx), y + 1.5E-4 * sign, z + (az + adz)).func_187315_a(0.0, 1.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x + (cx - cdx), y + 1.5E-4 * sign, z + (cz - cdz)).func_187315_a(1.0, 1.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x + (cx + cdx), y + 1.5E-4 * sign, z + (cz + cdz)).func_187315_a(1.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
    }

    public static void addBox(BufferBuilder b, double x1, double y1, double z1, double x2, double y2, double z2, StructUV[] textures, int[] inversions) {
        b.func_181662_b(x1, y1, z1).func_187315_a(textures[0].minU, textures[0].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
        b.func_181662_b(x1, y1, z2).func_187315_a(textures[0].maxU, textures[0].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
        b.func_181662_b(x2, y1, z2).func_187315_a(textures[0].maxU, textures[0].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
        b.func_181662_b(x2, y1, z1).func_187315_a(textures[0].minU, textures[0].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
        b.func_181662_b(x1, y2, z1).func_187315_a(textures[1].minU, textures[1].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
        b.func_181662_b(x1, y2, z2).func_187315_a(textures[1].maxU, textures[1].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
        b.func_181662_b(x2, y2, z2).func_187315_a(textures[1].maxU, textures[1].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
        b.func_181662_b(x2, y2, z1).func_187315_a(textures[1].minU, textures[1].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
        b.func_181662_b(x1, y1, z1).func_187315_a(textures[2].minU, textures[2].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
        b.func_181662_b(x2, y1, z1).func_187315_a(textures[2].maxU, textures[2].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
        b.func_181662_b(x2, y2, z1).func_187315_a(textures[2].maxU, textures[2].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
        b.func_181662_b(x1, y2, z1).func_187315_a(textures[2].minU, textures[2].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
        b.func_181662_b(x1, y1, z2).func_187315_a(textures[3].minU, textures[3].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
        b.func_181662_b(x2, y1, z2).func_187315_a(textures[3].maxU, textures[3].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
        b.func_181662_b(x2, y2, z2).func_187315_a(textures[3].maxU, textures[3].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
        b.func_181662_b(x1, y2, z2).func_187315_a(textures[3].minU, textures[3].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
        b.func_181662_b(x1, y1, z1).func_187315_a(textures[4].minU, textures[4].minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x1, y1, z2).func_187315_a(textures[4].maxU, textures[4].minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x1, y2, z2).func_187315_a(textures[4].maxU, textures[4].maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x1, y2, z1).func_187315_a(textures[4].minU, textures[4].maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x2, y1, z1).func_187315_a(textures[5].minU, textures[5].minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x2, y1, z2).func_187315_a(textures[5].maxU, textures[5].minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x2, y2, z2).func_187315_a(textures[5].maxU, textures[5].maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x2, y2, z1).func_187315_a(textures[5].minU, textures[5].maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
    }

    public static void addBoxWithSprite(BufferBuilder b, double x1, double y1, double z1, double x2, double y2, double z2, TextureAtlasSprite sprite, StructUV[] textures, int[] inversions) {
        float spriteW = sprite.func_94212_f() - sprite.func_94209_e();
        float spriteH = sprite.func_94210_h() - sprite.func_94206_g();
        b.func_181662_b(x1, y1, z1).func_187315_a((double)sprite.func_94209_e() + textures[0].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[0].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
        b.func_181662_b(x1, y1, z2).func_187315_a((double)sprite.func_94209_e() + textures[0].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[0].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
        b.func_181662_b(x2, y1, z2).func_187315_a((double)sprite.func_94209_e() + textures[0].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[0].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
        b.func_181662_b(x2, y1, z1).func_187315_a((double)sprite.func_94209_e() + textures[0].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[0].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
        b.func_181662_b(x1, y2, z1).func_187315_a((double)sprite.func_94209_e() + textures[1].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[1].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
        b.func_181662_b(x1, y2, z2).func_187315_a((double)sprite.func_94209_e() + textures[1].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[1].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
        b.func_181662_b(x2, y2, z2).func_187315_a((double)sprite.func_94209_e() + textures[1].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[1].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
        b.func_181662_b(x2, y2, z1).func_187315_a((double)sprite.func_94209_e() + textures[1].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[1].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
        b.func_181662_b(x1, y1, z1).func_187315_a((double)sprite.func_94209_e() + textures[2].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[2].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
        b.func_181662_b(x2, y1, z1).func_187315_a((double)sprite.func_94209_e() + textures[2].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[2].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
        b.func_181662_b(x2, y2, z1).func_187315_a((double)sprite.func_94209_e() + textures[2].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[2].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
        b.func_181662_b(x1, y2, z1).func_187315_a((double)sprite.func_94209_e() + textures[2].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[2].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
        b.func_181662_b(x1, y1, z2).func_187315_a((double)sprite.func_94209_e() + textures[3].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[3].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
        b.func_181662_b(x2, y1, z2).func_187315_a((double)sprite.func_94209_e() + textures[3].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[3].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
        b.func_181662_b(x2, y2, z2).func_187315_a((double)sprite.func_94209_e() + textures[3].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[3].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
        b.func_181662_b(x1, y2, z2).func_187315_a((double)sprite.func_94209_e() + textures[3].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[3].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
        b.func_181662_b(x1, y1, z1).func_187315_a((double)sprite.func_94209_e() + textures[4].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[4].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x1, y1, z2).func_187315_a((double)sprite.func_94209_e() + textures[4].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[4].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x1, y2, z2).func_187315_a((double)sprite.func_94209_e() + textures[4].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[4].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x1, y2, z1).func_187315_a((double)sprite.func_94209_e() + textures[4].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[4].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x2, y1, z1).func_187315_a((double)sprite.func_94209_e() + textures[5].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[5].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x2, y1, z2).func_187315_a((double)sprite.func_94209_e() + textures[5].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[5].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x2, y2, z2).func_187315_a((double)sprite.func_94209_e() + textures[5].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[5].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x2, y2, z1).func_187315_a((double)sprite.func_94209_e() + textures[5].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[5].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
    }

    public static void addBoxExt(BufferBuilder b, double x1, double y1, double z1, double x2, double y2, double z2, StructUV[] textures, int[] inversions, boolean[] faceToggles) {
        if (faceToggles[0]) {
            b.func_181662_b(x1, y1, z1).func_187315_a(textures[0].minU, textures[0].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
            b.func_181662_b(x1, y1, z2).func_187315_a(textures[0].maxU, textures[0].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
            b.func_181662_b(x2, y1, z2).func_187315_a(textures[0].maxU, textures[0].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
            b.func_181662_b(x2, y1, z1).func_187315_a(textures[0].minU, textures[0].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
        }
        if (faceToggles[1]) {
            b.func_181662_b(x1, y2, z1).func_187315_a(textures[1].minU, textures[1].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
            b.func_181662_b(x1, y2, z2).func_187315_a(textures[1].maxU, textures[1].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
            b.func_181662_b(x2, y2, z2).func_187315_a(textures[1].maxU, textures[1].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
            b.func_181662_b(x2, y2, z1).func_187315_a(textures[1].minU, textures[1].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
        }
        if (faceToggles[2]) {
            b.func_181662_b(x1, y1, z1).func_187315_a(textures[2].minU, textures[2].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
            b.func_181662_b(x2, y1, z1).func_187315_a(textures[2].maxU, textures[2].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
            b.func_181662_b(x2, y2, z1).func_187315_a(textures[2].maxU, textures[2].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
            b.func_181662_b(x1, y2, z1).func_187315_a(textures[2].minU, textures[2].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
        }
        if (faceToggles[3]) {
            b.func_181662_b(x1, y1, z2).func_187315_a(textures[3].minU, textures[3].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
            b.func_181662_b(x2, y1, z2).func_187315_a(textures[3].maxU, textures[3].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
            b.func_181662_b(x2, y2, z2).func_187315_a(textures[3].maxU, textures[3].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
            b.func_181662_b(x1, y2, z2).func_187315_a(textures[3].minU, textures[3].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
        }
        if (faceToggles[4]) {
            b.func_181662_b(x1, y1, z1).func_187315_a(textures[4].minU, textures[4].minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
            b.func_181662_b(x1, y1, z2).func_187315_a(textures[4].maxU, textures[4].minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
            b.func_181662_b(x1, y2, z2).func_187315_a(textures[4].maxU, textures[4].maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
            b.func_181662_b(x1, y2, z1).func_187315_a(textures[4].minU, textures[4].maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
        }
        if (faceToggles[5]) {
            b.func_181662_b(x2, y1, z1).func_187315_a(textures[5].minU, textures[5].minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
            b.func_181662_b(x2, y1, z2).func_187315_a(textures[5].maxU, textures[5].minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
            b.func_181662_b(x2, y2, z2).func_187315_a(textures[5].maxU, textures[5].maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
            b.func_181662_b(x2, y2, z1).func_187315_a(textures[5].minU, textures[5].maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawQuadGui(BufferBuilder BufferBuilder2, double zLevel, double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, double minU, double minV, double maxU, double maxV) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        BufferBuilder2.func_181662_b(x1 + 0.0, y1 + 0.0, zLevel).func_187315_a(minU, maxV).func_181675_d();
        BufferBuilder2.func_181662_b(x2 + 0.0, y2 + 0.0, zLevel).func_187315_a(maxU, maxV).func_181675_d();
        BufferBuilder2.func_181662_b(x3 + 0.0, y3 + 0.0, zLevel).func_187315_a(maxU, minV).func_181675_d();
        BufferBuilder2.func_181662_b(x4 + 0.0, y4 + 0.0, zLevel).func_187315_a(minU, minV).func_181675_d();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawTexturedModalRect(int x, int y, double zLevel, double minU, double minV, double maxU, double maxV, int widthIn, int heightIn) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder BufferBuilder2 = tessellator.func_178180_c();
        BufferBuilder2.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        BufferBuilder2.func_181662_b((double)(x + 0), (double)(y + heightIn), zLevel).func_187315_a(minU, maxV).func_181675_d();
        BufferBuilder2.func_181662_b((double)(x + widthIn), (double)(y + heightIn), zLevel).func_187315_a(maxU, maxV).func_181675_d();
        BufferBuilder2.func_181662_b((double)(x + widthIn), (double)(y + 0), zLevel).func_187315_a(maxU, minV).func_181675_d();
        BufferBuilder2.func_181662_b((double)(x + 0), (double)(y + 0), zLevel).func_187315_a(minU, minV).func_181675_d();
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawTexturedModalRectBatched(BufferBuilder BufferBuilder2, int x, int y, double zLevel, double minU, double minV, double maxU, double maxV, int widthIn, int heightIn) {
        BufferBuilder2.func_181662_b((double)(x + 0), (double)(y + heightIn), zLevel).func_187315_a(minU, maxV).func_181675_d();
        BufferBuilder2.func_181662_b((double)(x + widthIn), (double)(y + heightIn), zLevel).func_187315_a(maxU, maxV).func_181675_d();
        BufferBuilder2.func_181662_b((double)(x + widthIn), (double)(y + 0), zLevel).func_187315_a(maxU, minV).func_181675_d();
        BufferBuilder2.func_181662_b((double)(x + 0), (double)(y + 0), zLevel).func_187315_a(minU, minV).func_181675_d();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawColorRectBatched(BufferBuilder BufferBuilder2, double x, double y, double zLevel, double widthIn, double heightIn, float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2, float r3, float g3, float b3, float a3, float r4, float g4, float b4, float a4) {
        BufferBuilder2.func_181662_b(x + 0.0, y + heightIn, zLevel).func_181666_a(r1, g1, b1, a1).func_181675_d();
        BufferBuilder2.func_181662_b(x + widthIn, y + heightIn, zLevel).func_181666_a(r2, g2, b2, a2).func_181675_d();
        BufferBuilder2.func_181662_b(x + widthIn, y + 0.0, zLevel).func_181666_a(r3, g3, b3, a3).func_181675_d();
        BufferBuilder2.func_181662_b(x + 0.0, y + 0.0, zLevel).func_181666_a(r4, g4, b4, a4).func_181675_d();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawQuadGuiExt(BufferBuilder BufferBuilder2, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, int minU, int minV, int maxU, int maxV, int texW, int texH, float r, float g, float b, float a) {
        float mU = (float)minU / (float)texW;
        float mV = (float)minV / (float)texH;
        float xU = (float)maxU / (float)texW;
        float xV = (float)maxV / (float)texH;
        BufferBuilder2.func_181662_b((double)(x1 + 0.0f), (double)(y1 + 0.0f), 0.0).func_187315_a((double)mU, (double)xV).func_181666_a(r, g, b, a).func_181675_d();
        BufferBuilder2.func_181662_b((double)(x2 + 0.0f), (double)(y2 + 0.0f), 0.0).func_187315_a((double)xU, (double)xV).func_181666_a(r, g, b, a).func_181675_d();
        BufferBuilder2.func_181662_b((double)(x3 + 0.0f), (double)(y3 + 0.0f), 0.0).func_187315_a((double)xU, (double)mV).func_181666_a(r, g, b, a).func_181675_d();
        BufferBuilder2.func_181662_b((double)(x4 + 0.0f), (double)(y4 + 0.0f), 0.0).func_187315_a((double)mU, (double)mV).func_181666_a(r, g, b, a).func_181675_d();
    }

    public static void drawTextRGBA(FontRenderer font, String s, int x, int y, int r, int g, int b, int a) {
        font.func_78276_b(s, x, y, (a << 24) + (r << 16) + (g << 8) + b);
    }

    public static void renderChunkUniforms(RenderChunk c) {
        if (ShaderUtil.currentProgram == ShaderUtil.lightProgram) {
            BlockPos pos = c.func_178568_j();
            int chunkX = GL20.glGetUniformLocation((int)ShaderUtil.lightProgram, (CharSequence)"chunkX");
            int chunkY = GL20.glGetUniformLocation((int)ShaderUtil.lightProgram, (CharSequence)"chunkY");
            int chunkZ = GL20.glGetUniformLocation((int)ShaderUtil.lightProgram, (CharSequence)"chunkZ");
            GL20.glUniform1i((int)chunkX, (int)pos.func_177958_n());
            GL20.glUniform1i((int)chunkY, (int)pos.func_177956_o());
            GL20.glUniform1i((int)chunkZ, (int)pos.func_177952_p());
        }
    }

    public static void renderFluidCuboid(FluidStack fluid, BlockPos pos, double w, double h, double d) {
        double wd = (1.0 - w) / 2.0;
        double hd = (1.0 - h) / 2.0;
        double dd = (1.0 - d) / 2.0;
        RenderUtil.renderFluidCuboid(fluid, pos, wd, hd, dd, 1.0 - wd, 1.0 - hd, 1.0 - dd);
    }

    public static void renderFluidCuboid(FluidStack fluid, BlockPos pos, double x1, double y1, double z1, double x2, double y2, double z2) {
        int color = fluid.getFluid().getColor(fluid);
        RenderUtil.renderFluidCuboid(fluid, pos, x1, y1, z1, x2, y2, z2, color);
    }

    public static void renderFluidCuboid(FluidStack fluid, BlockPos pos, double x1, double y1, double z1, double x2, double y2, double z2, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        int brightness = Minecraft.func_71410_x().field_71441_e.func_175626_b(pos, fluid.getFluid().getLuminosity());
        TextureAtlasSprite still = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluid.getFluid().getStill(fluid).toString());
        TextureAtlasSprite flowing = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluid.getFluid().getFlowing(fluid).toString());
        RenderUtil.putTexturedQuad(renderer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.DOWN, color, brightness, false);
        RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness, true);
        RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.EAST, color, brightness, true);
        RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.SOUTH, color, brightness, true);
        RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.WEST, color, brightness, true);
        RenderUtil.putTexturedQuad(renderer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.UP, color, brightness, false);
        tessellator.func_78381_a();
    }

    public static void putTexturedQuad(BufferBuilder renderer, TextureAtlasSprite sprite, double x, double y, double z, double w, double h, double d, EnumFacing face, int color, int brightness, boolean flowing) {
        int l1 = brightness >> 16 & 0xFFFF;
        int l2 = brightness & 0xFFFF;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        RenderUtil.putTexturedQuad(renderer, sprite, x, y, z, w, h, d, face, r, g, b, a, l1, l2, flowing);
    }

    public static void putTexturedQuad(BufferBuilder renderer, TextureAtlasSprite sprite, double x, double y, double z, double w, double h, double d, EnumFacing face, int r, int g, int b, int a, int light1, int light2, boolean flowing) {
        double maxV;
        double minV;
        double maxU;
        double minU;
        double zt2;
        double yt2;
        double xt2;
        if (sprite == null) {
            return;
        }
        double size = 16.0;
        if (flowing) {
            size = 8.0;
        }
        double x1 = x;
        double x2 = x + w;
        double y1 = y;
        double y2 = y + h;
        double z1 = z;
        double z2 = z + d;
        double xt1 = x1 % 1.0;
        for (xt2 = xt1 + w; xt2 > 1.0; xt2 -= 1.0) {
        }
        double yt1 = y1 % 1.0;
        for (yt2 = yt1 + h; yt2 > 1.0; yt2 -= 1.0) {
        }
        double zt1 = z1 % 1.0;
        for (zt2 = zt1 + d; zt2 > 1.0; zt2 -= 1.0) {
        }
        if (flowing) {
            double tmp = 1.0 - yt1;
            yt1 = 1.0 - yt2;
            yt2 = tmp;
        }
        switch (face) {
            case DOWN: 
            case UP: {
                minU = sprite.func_94214_a(xt1 * size);
                maxU = sprite.func_94214_a(xt2 * size);
                minV = sprite.func_94207_b(zt1 * size);
                maxV = sprite.func_94207_b(zt2 * size);
                break;
            }
            case NORTH: 
            case SOUTH: {
                minU = sprite.func_94214_a(xt2 * size);
                maxU = sprite.func_94214_a(xt1 * size);
                minV = sprite.func_94207_b(yt1 * size);
                maxV = sprite.func_94207_b(yt2 * size);
                break;
            }
            case WEST: 
            case EAST: {
                minU = sprite.func_94214_a(zt2 * size);
                maxU = sprite.func_94214_a(zt1 * size);
                minV = sprite.func_94207_b(yt1 * size);
                maxV = sprite.func_94207_b(yt2 * size);
                break;
            }
            default: {
                minU = sprite.func_94209_e();
                maxU = sprite.func_94212_f();
                minV = sprite.func_94206_g();
                maxV = sprite.func_94210_h();
            }
        }
        switch (face) {
            case DOWN: {
                renderer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y1, z1).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y1, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y1, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case UP: {
                renderer.func_181662_b(x1, y2, z1).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y2, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z1).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case NORTH: {
                renderer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y2, z1).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z1).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y1, z1).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case SOUTH: {
                renderer.func_181662_b(x1, y1, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y1, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y2, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case WEST: {
                renderer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y1, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y2, z2).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y2, z1).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case EAST: {
                renderer.func_181662_b(x2, y1, z1).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z1).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y1, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
            }
        }
    }
}

