/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.upgrade;

import java.util.List;
import net.minecraft.tileentity.TileEntity;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.event.UpgradeEvent;
import teamroots.embers.api.tile.IMechanicallyPowered;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.tileentity.TileEntityMiniBoiler;
import teamroots.embers.util.DefaultUpgradeProvider;

public class UpgradeMiniBoiler
extends DefaultUpgradeProvider {
    boolean active;
    double heat;

    public UpgradeMiniBoiler(TileEntity tile) {
        super("mini_boiler", tile);
    }

    @Override
    public int getLimit(TileEntity tile) {
        return tile instanceof IMechanicallyPowered ? 0 : 4;
    }

    @Override
    public void throwEvent(TileEntity tile, UpgradeEvent event) {
        if (event instanceof EmberEvent) {
            this.setHeat(((EmberEvent)event).getAmount());
        }
    }

    public void setHeat(double heat) {
        this.heat = heat;
        this.active = true;
    }

    @Override
    public boolean doWork(TileEntity tile, List<IUpgradeProvider> upgrades) {
        if (this.active) {
            if (this.tile instanceof TileEntityMiniBoiler) {
                ((TileEntityMiniBoiler)this.tile).boil(this.heat);
            }
            this.active = false;
        }
        return false;
    }
}

