/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.RegistryManager;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.event.DialInformationEvent;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.event.MachineRecipeEvent;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.tile.IBin;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.api.tile.IMechanicallyPowered;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.block.BlockStamper;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageStamperFX;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.recipe.ItemStampingRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityStampBase;
import teamroots.embers.util.Misc;

public class TileEntityStamper
extends TileEntity
implements ITileEntityBase,
ITickable,
IMechanicallyPowered,
IExtraDialInformation,
IExtraCapabilityInformation {
    public static final double EMBER_COST = 80.0;
    public static final int STAMP_TIME = 70;
    public static final int RETRACT_TIME = 10;
    public IEmberCapability capability = new DefaultEmberCapability();
    public boolean prevPowered = false;
    public boolean powered = false;
    public long ticksExisted = 0L;
    Random random = new Random();
    public ItemStackHandler stamp = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityStamper.this.func_70296_d();
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private List<IUpgradeProvider> upgrades = new ArrayList<IUpgradeProvider>();

    public TileEntityStamper() {
        this.capability.setEmberCapacity(8000.0);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("powered", this.powered);
        this.capability.writeToNBT(tag);
        tag.func_74782_a("stamp", (NBTBase)this.stamp.serializeNBT());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.powered = tag.func_74767_n("powered");
        this.capability.readFromNBT(tag);
        this.stamp.deserializeNBT(tag.func_74775_l("stamp"));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b()) {
            if (this.stamp.getStackInSlot(0).func_190926_b()) {
                player.func_184611_a(hand, this.stamp.insertItem(0, heldItem.func_77946_l(), false));
                this.func_70296_d();
                return true;
            }
        } else if (!this.stamp.getStackInSlot(0).func_190926_b() && !world.field_72995_K) {
            world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.stamp.getStackInSlot(0)));
            this.stamp.setStackInSlot(0, ItemStack.field_190927_a);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.stamp);
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        this.prevPowered = this.powered;
        EnumFacing face = (EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockStamper.facing);
        if (this.func_145831_w().func_180495_p(this.func_174877_v().func_177967_a(face, 2)).func_177230_c() == RegistryManager.stamp_base) {
            this.upgrades = UpgradeUtil.getUpgrades(this.field_145850_b, this.field_174879_c, EnumFacing.field_176754_o);
            UpgradeUtil.verifyUpgrades(this, this.upgrades);
            if (UpgradeUtil.doTick(this, this.upgrades)) {
                return;
            }
            TileEntityStampBase stamp = (TileEntityStampBase)this.func_145831_w().func_175625_s(this.func_174877_v().func_177967_a(face, 2));
            FluidStack fluid = null;
            IFluidHandler handler = stamp.getTank();
            if (handler != null) {
                fluid = handler.drain(stamp.getCapacity(), false);
            }
            ItemStampingRecipe recipe = this.getRecipe(stamp.inputs.getStackInSlot(0), fluid, this.stamp.getStackInSlot(0));
            if (!this.func_145831_w().field_72995_K && (recipe != null || this.powered)) {
                boolean cancel = UpgradeUtil.doWork(this, this.upgrades);
                int stampTime = UpgradeUtil.getWorkTime(this, 70, this.upgrades);
                int retractTime = UpgradeUtil.getWorkTime(this, 10, this.upgrades);
                if (!cancel && !this.powered && this.ticksExisted >= (long)stampTime && recipe != null) {
                    double emberCost = UpgradeUtil.getTotalEmberConsumption(this, 80.0, this.upgrades);
                    if (this.capability.getEmber() >= emberCost) {
                        UpgradeUtil.throwEvent(this, new EmberEvent(this, EmberEvent.EnumType.CONSUME, emberCost), this.upgrades);
                        this.capability.removeAmount(emberCost, true);
                        if (!this.field_145850_b.field_72995_K) {
                            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageStamperFX((float)this.func_174877_v().func_177967_a(face, 2).func_177958_n() + 0.5f, (float)this.func_174877_v().func_177967_a(face, 2).func_177956_o() + 1.0f, (float)this.func_174877_v().func_177967_a(face, 2).func_177952_p() + 0.5f));
                        }
                        this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() - 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundManager.STAMPER_DOWN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        this.powered = true;
                        this.ticksExisted = 0L;
                        ArrayList results = Lists.newArrayList((Object[])new ItemStack[]{recipe.getResult(this, stamp.inputs.getStackInSlot(0), stamp.getFluid() != null ? new FluidStack(stamp.getFluid(), stamp.getAmount()) : null, this.stamp.getStackInSlot(0))});
                        UpgradeUtil.transformOutput((TileEntity)this, results, this.upgrades);
                        stamp.inputs.extractItem(0, recipe.getInputConsumed(), false);
                        if (recipe.getFluid() != null) {
                            stamp.getTank().drain(recipe.getFluid(), true);
                        }
                        BlockPos middlePos = this.func_174877_v().func_177967_a(face, 1);
                        BlockPos outputPos = this.func_174877_v().func_177967_a(face, 3);
                        TileEntity outputTile = this.func_145831_w().func_175625_s(outputPos);
                        for (ItemStack remainder : results) {
                            if (outputTile instanceof IBin) {
                                remainder = ((IBin)outputTile).getInventory().insertItem(0, remainder, false);
                            }
                            if (remainder.func_190926_b() || this.func_145831_w().field_72995_K) continue;
                            this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), (double)middlePos.func_177958_n() + 0.5, (double)middlePos.func_177956_o() + 0.5, (double)middlePos.func_177952_p() + 0.5, remainder));
                        }
                        stamp.func_70296_d();
                    }
                    this.func_70296_d();
                } else if (!cancel && this.powered && this.ticksExisted >= (long)retractTime) {
                    this.retract();
                }
            }
        } else if (this.powered) {
            this.retract();
        }
    }

    private void retract() {
        this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() - 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundManager.STAMPER_UP, SoundCategory.BLOCKS, 1.0f, 1.0f);
        this.powered = false;
        this.ticksExisted = 0L;
        this.func_70296_d();
    }

    private ItemStampingRecipe getRecipe(ItemStack input, FluidStack fluid, ItemStack stamp) {
        ItemStampingRecipe recipe = RecipeRegistry.getStampingRecipe(input, fluid, stamp);
        MachineRecipeEvent<ItemStampingRecipe> event = new MachineRecipeEvent<ItemStampingRecipe>(this, recipe);
        UpgradeUtil.throwEvent(this, event, this.upgrades);
        return event.getRecipe();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.stamp;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    @Override
    public double getMechanicalSpeed(double power) {
        return Misc.getDiminishedPower(power, 20.0, 0.075);
    }

    @Override
    public double getNominalSpeed() {
        return 1.0;
    }

    @Override
    public double getMinimumPower() {
        return 10.0;
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        UpgradeUtil.throwEvent(this, new DialInformationEvent(this, information, dialType), this.upgrades);
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.BOTH, "embers.tooltip.goggles.item", I18n.func_135052_a((String)"embers.tooltip.goggles.item.stamp", (Object[])new Object[0])));
        }
    }
}

