/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberActivationFX;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityCatalyzer;
import teamroots.embers.tileentity.TileEntityCombustor;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityReactor
extends TileEntity
implements ITileEntityBase,
ITickable,
ISoundController,
IExtraDialInformation,
IExtraCapabilityInformation {
    public static final float BASE_MULTIPLIER = 1.0f;
    public static final int PROCESS_TIME = 20;
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public void onContentsChanged() {
            TileEntityReactor.this.func_70296_d();
        }
    };
    Random random = new Random();
    int progress = -1;
    public static final int SOUND_HAS_EMBER = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityReactor.this.func_70296_d();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (EmbersAPI.getEmberValue(stack) == 0.0) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    private double catalyzerMult;
    private double combustorMult;

    public TileEntityReactor() {
        this.capability.setEmberCapacity(64000.0);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        this.capability.writeToNBT(tag);
        tag.func_74768_a("progress", this.progress);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        this.capability.readFromNBT(tag);
        if (tag.func_74764_b("progress")) {
            this.progress = tag.func_74762_e("progress");
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        Misc.spawnInventoryInWorld(this.func_145831_w(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.inventory);
        world.func_175690_a(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        boolean cancel;
        List<IUpgradeProvider> upgrades = UpgradeUtil.getUpgrades(this.field_145850_b, this.field_174879_c, EnumFacing.field_176754_o);
        UpgradeUtil.verifyUpgrades(this, upgrades);
        if (this.func_145831_w().field_72995_K) {
            this.handleSound();
        }
        if (!(cancel = UpgradeUtil.doWork(this, upgrades)) && !this.inventory.getStackInSlot(0).func_190926_b()) {
            ++this.progress;
            if (this.progress > UpgradeUtil.getWorkTime(this, 20, upgrades)) {
                this.catalyzerMult = 0.0;
                this.combustorMult = 0.0;
                float multiplier = 1.0f;
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(facing).func_177977_b());
                    if (tile instanceof TileEntityCatalyzer) {
                        this.catalyzerMult += ((TileEntityCatalyzer)tile).multiplier;
                    }
                    if (!(tile instanceof TileEntityCombustor)) continue;
                    this.combustorMult += ((TileEntityCombustor)tile).multiplier;
                }
                if (Math.max(this.combustorMult, this.catalyzerMult) < 2.0 * Math.min(this.combustorMult, this.catalyzerMult)) {
                    ItemStack emberStack;
                    double emberValue;
                    double ember;
                    multiplier = (float)((double)multiplier + this.combustorMult);
                    multiplier = (float)((double)multiplier + this.catalyzerMult);
                    this.progress = 0;
                    int i = 0;
                    if (this.inventory != null && (ember = UpgradeUtil.getTotalEmberProduction(this, (double)multiplier * (emberValue = EmbersAPI.getEmberValue(emberStack = this.inventory.getStackInSlot(i))), upgrades)) > 0.0 && this.capability.getEmber() + ember <= this.capability.getEmberCapacity()) {
                        if (!this.field_145850_b.field_72995_K) {
                            this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundManager.IGNEM_REACTOR, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberActivationFX((float)this.func_174877_v().func_177958_n() + 0.5f, (float)this.func_174877_v().func_177956_o() + 0.5f, (float)this.func_174877_v().func_177952_p() + 0.5f));
                        }
                        UpgradeUtil.throwEvent(this, new EmberEvent(this, EmberEvent.EnumType.PRODUCE, ember), upgrades);
                        this.capability.addAmount(ember, true);
                        this.inventory.extractItem(i, 1, false);
                        this.func_70296_d();
                    }
                }
            }
            this.func_70296_d();
        }
        if (this.capability.getEmber() > 0.0 && this.func_145831_w().field_72995_K) {
            double catalyzerRatio = 0.0;
            if (this.catalyzerMult > 0.0 || this.combustorMult > 0.0) {
                catalyzerRatio = this.catalyzerMult / (this.catalyzerMult + this.combustorMult);
            }
            int r = (int)MathHelper.func_151238_b((double)255.0, (double)255.0, (double)catalyzerRatio);
            int g = (int)MathHelper.func_151238_b((double)64.0, (double)64.0, (double)catalyzerRatio);
            int b = (int)MathHelper.func_151238_b((double)16.0, (double)64.0, (double)catalyzerRatio);
            int i = 0;
            while ((double)i < Math.ceil(this.capability.getEmber() / 500.0)) {
                float vx = (float)MathHelper.func_151238_b((double)0.0, (double)(((double)this.random.nextFloat() - 0.5) * (double)0.1f), (double)catalyzerRatio);
                float vy = (float)MathHelper.func_151238_b((double)(this.random.nextFloat() * 0.05f), (double)(((double)this.random.nextFloat() - 0.5) * (double)0.2f), (double)catalyzerRatio);
                float vz = (float)MathHelper.func_151238_b((double)0.0, (double)(((double)this.random.nextFloat() - 0.5) * (double)0.1f), (double)catalyzerRatio);
                float size = (float)MathHelper.func_151238_b((double)4.0, (double)2.0, (double)catalyzerRatio);
                int lifetime = 16 + this.random.nextInt(16);
                ParticleUtil.spawnParticleGlow(this.func_145831_w(), (float)this.func_174877_v().func_177958_n() + 0.25f + this.random.nextFloat() * 0.5f, (float)this.func_174877_v().func_177956_o() + 0.25f + this.random.nextFloat() * 0.5f, (float)this.func_174877_v().func_177952_p() + 0.25f + this.random.nextFloat() * 0.5f, vx, vy, vz, r, g, b, size, lifetime);
                ++i;
            }
        }
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                Embers.proxy.playMachineSound(this, 1, SoundManager.GENERATOR_LOOP, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1 && this.capability.getEmber() > 0.0;
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        if ("ember".equals(dialType) && Math.max(this.combustorMult, this.catalyzerMult) < 2.0 * Math.min(this.combustorMult, this.catalyzerMult)) {
            DecimalFormat multiplierFormat = Embers.proxy.getDecimalFormat("embers.decimal_format.ember_multiplier");
            double multiplier = 1.0 + this.combustorMult + this.catalyzerMult;
            information.add(I18n.func_135052_a((String)"embers.tooltip.dial.ember_multiplier", (Object[])new Object[]{multiplierFormat.format(multiplier)}));
        }
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return true;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.item", I18n.func_135052_a((String)"embers.tooltip.goggles.item.ember", (Object[])new Object[0])));
        }
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.OUTPUT, "embers.tooltip.goggles.ember", null));
        }
    }
}

