/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.List;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import teamroots.embers.block.BlockVacuum;
import teamroots.embers.tileentity.IItemPipeConnectable;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.EnumPipeConnection;

public class TileEntityItemVacuum
extends TileEntity
implements ITileEntityBase,
ITickable,
IItemPipeConnectable {
    Random random = new Random();

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockVacuum.facing);
        TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing.func_176734_d()));
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_175640_z(this.func_174877_v()) && tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            List nearestItems;
            IItemHandler inventory = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
            Vec3i vec = facing.func_176730_m();
            AxisAlignedBB suckBB = new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 6 + vec.func_177958_n() * 6), (double)(this.func_174877_v().func_177956_o() - 6 + vec.func_177956_o() * 6), (double)(this.func_174877_v().func_177952_p() - 6 + vec.func_177952_p() * 6), (double)(this.func_174877_v().func_177958_n() + 7 + vec.func_177958_n() * 6), (double)(this.func_174877_v().func_177956_o() + 7 + vec.func_177956_o() * 6), (double)(this.func_174877_v().func_177952_p() + 7 + vec.func_177952_p() * 6));
            List items = this.field_145850_b.func_175647_a(EntityItem.class, suckBB, entity -> this.getInsertedSlot(entity.func_92059_d(), inventory) != -1);
            if (items.size() > 0) {
                for (EntityItem item : items) {
                    Vec3d v = new Vec3d(item.field_70165_t - ((double)this.func_174877_v().func_177958_n() + 0.5), item.field_70163_u - ((double)this.func_174877_v().func_177956_o() + 0.5), item.field_70161_v - ((double)this.func_174877_v().func_177952_p() + 0.5));
                    v.func_72432_b();
                    item.field_70159_w = -v.field_72450_a * 0.25 * (double)0.2f + item.field_70159_w * (double)0.8f;
                    item.field_70181_x = -v.field_72448_b * 0.25 * (double)0.2f + item.field_70181_x * (double)0.8f;
                    item.field_70179_y = -v.field_72449_c * 0.25 * (double)0.2f + item.field_70179_y * (double)0.8f;
                }
            }
            if ((nearestItems = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n() - 0.25, (double)this.func_174877_v().func_177956_o() - 0.25, (double)this.func_174877_v().func_177952_p() - 0.25, (double)this.func_174877_v().func_177958_n() + 1.25, (double)this.func_174877_v().func_177956_o() + 1.25, (double)this.func_174877_v().func_177952_p() + 1.25))).size() > 0) {
                for (EntityItem item : nearestItems) {
                    int slot;
                    if (item.field_70128_L || (slot = this.getInsertedSlot(item.func_92059_d(), inventory)) == -1) continue;
                    item.func_92058_a(inventory.insertItem(slot, item.func_92059_d(), false));
                    if (!item.func_92059_d().func_190926_b()) continue;
                    item.func_70106_y();
                }
            }
        }
    }

    int getInsertedSlot(ItemStack stack, IItemHandler inventory) {
        int slot = -1;
        for (int j = 0; j < inventory.getSlots() && slot == -1; ++j) {
            ItemStack added = inventory.insertItem(j, stack, true);
            if (added.func_190916_E() >= stack.func_190916_E() && added.func_77969_a(stack)) continue;
            slot = j;
        }
        return slot;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    @Override
    public EnumPipeConnection getConnection(EnumFacing facing) {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)BlockVacuum.facing);
        return face.func_176734_d() == facing ? EnumPipeConnection.PIPE : EnumPipeConnection.NONE;
    }
}

