/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.ItemUtil;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityAlchemyPedestal
extends TileEntity
implements ITileEntityBase,
ITickable,
ISoundController,
IExtraCapabilityInformation {
    int angle = 0;
    int turnRate = 0;
    int progress = 0;
    int ash = 0;
    int stackAsh = 0;
    int stackItem = 1;
    public ItemStackHandler inventory;
    IItemHandler externalInventory;
    Random random = new Random();
    public static final int SOUND_PROCESS = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();
    int active = 0;

    public TileEntityAlchemyPedestal() {
        this.inventory = new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                TileEntityAlchemyPedestal.this.func_70296_d();
            }

            public int getSlotLimit(int slot) {
                return slot == TileEntityAlchemyPedestal.this.stackItem ? 1 : super.getSlotLimit(slot);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return super.extractItem(slot, amount, simulate);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return slot == TileEntityAlchemyPedestal.this.stackAsh && !ItemUtil.matchesOreDict(stack, "dustAsh") ? this.insertItem(slot + 1, stack, simulate) : super.insertItem(slot, stack, simulate);
            }
        };
        this.externalInventory = Misc.makeBlockedItemHandler((IItemHandler)this.inventory, this::isNotActive, this::isNotActive);
    }

    private boolean isNotActive() {
        return !this.isActive();
    }

    public boolean isActive() {
        return this.active > 0;
    }

    public void setActive(int time) {
        this.active = time;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("progress", 0);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.ash = tag.func_74762_e("ash");
        this.progress = tag.func_74762_e("progress");
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.externalInventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b()) {
            boolean isAsh = ItemUtil.matchesOreDict(heldItem, "dustAsh");
            if (isAsh) {
                player.func_184611_a(hand, this.externalInventory.insertItem(this.stackAsh, heldItem, false));
            } else {
                player.func_184611_a(hand, this.externalInventory.insertItem(this.stackItem, heldItem, false));
            }
            this.func_70296_d();
            return true;
        }
        ItemStack ashStack = this.externalInventory.getStackInSlot(this.stackAsh);
        ItemStack itemStack = this.externalInventory.getStackInSlot(this.stackItem);
        if (!ashStack.func_190926_b()) {
            if (!world.field_72995_K) {
                player.func_184611_a(hand, this.externalInventory.extractItem(this.stackAsh, ashStack.func_190916_E(), false));
                this.func_70296_d();
            }
            return true;
        }
        if (!itemStack.func_190926_b()) {
            if (!world.field_72995_K) {
                player.func_184611_a(hand, this.externalInventory.extractItem(this.stackItem, itemStack.func_190916_E(), false));
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.inventory);
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        this.turnRate = 1;
        this.angle += this.turnRate;
        if (this.func_145831_w().field_72995_K) {
            this.handleSound();
        }
        --this.active;
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                Embers.proxy.playMachineSound(this, 1, SoundManager.PEDESTAL_LOOP, SoundCategory.BLOCKS, true, 0.1f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 1.0f, (float)this.field_174879_c.func_177952_p() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1 && this.isActive();
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.BOTH, "embers.tooltip.goggles.item", I18n.func_135052_a((String)"embers.tooltip.goggles.item.ash", (Object[])new Object[0])));
        }
    }
}

