/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.itemmod;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.SoundManager;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.itemmod.ItemModUtil;
import teamroots.embers.api.itemmod.ModifierBase;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessagePlayerJetFX;
import teamroots.embers.util.EmberInventoryUtil;

public class ModifierCinderJet
extends ModifierBase {
    public static Map<UUID, Boolean> sprinting = new HashMap<UUID, Boolean>();

    public ModifierCinderJet() {
        super(ModifierBase.EnumType.ARMOR, "jet_augment", 2.0, true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public float addDash(ItemStack stack) {
        if (ItemModUtil.hasHeat(stack)) {
            int level = ItemModUtil.getModifierLevel(stack, EmbersAPI.JET_AUGMENT);
            return (float)(0.5 * (Math.atan(0.6 * (double)level) / 1.25));
        }
        return 0.0f;
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (entity instanceof EntityPlayer && !world.field_72995_K) {
            UUID id = entity.func_110124_au();
            if (sprinting.containsKey(id)) {
                int level;
                float dashStrength;
                if (entity.func_70051_ag() && !sprinting.get(id).booleanValue() && (dashStrength = (float)(2.0 * (Math.atan(0.6 * (double)(level = ItemModUtil.getArmorModifierLevel((EntityLivingBase)((EntityPlayer)entity), EmbersAPI.JET_AUGMENT))) / 1.25))) > 0.0f && entity.field_70122_E && EmberInventoryUtil.getEmberTotal((EntityPlayer)entity) > this.cost) {
                    EmberInventoryUtil.removeEmber((EntityPlayer)entity, this.cost);
                    entity.field_70133_I = true;
                    entity.field_70159_w += 2.0 * entity.func_70040_Z().field_72450_a * (double)dashStrength;
                    entity.field_70181_x += 0.4;
                    entity.field_70179_y += 2.0 * entity.func_70040_Z().field_72449_c * (double)dashStrength;
                    entity.func_130014_f_().func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundManager.CINDER_JET, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    if (!entity.func_130014_f_().field_72995_K) {
                        PacketHandler.INSTANCE.sendToAll((IMessage)new MessagePlayerJetFX(entity.func_110124_au()));
                    }
                }
                sprinting.replace(id, entity.func_70051_ag());
            } else {
                sprinting.put(id, entity.func_70051_ag());
            }
        }
    }
}

