/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item;

import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.event.EmberProjectileEvent;
import teamroots.embers.api.event.ItemVisualEvent;
import teamroots.embers.api.item.IProjectileWeapon;
import teamroots.embers.api.projectile.EffectArea;
import teamroots.embers.api.projectile.EffectDamage;
import teamroots.embers.api.projectile.IProjectilePreset;
import teamroots.embers.api.projectile.ProjectileFireball;
import teamroots.embers.damage.DamageEmber;
import teamroots.embers.item.ItemBase;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.util.EmberInventoryUtil;
import teamroots.embers.util.Misc;

public class ItemCinderStaff
extends ItemBase
implements IProjectileWeapon {
    public static final double EMBER_COST = 25.0;
    public static final int COOLDOWN = 10;
    public static boolean soundPlaying = false;

    public ItemCinderStaff() {
        super("staff_ember", true);
        this.func_77625_d(1);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        if (!world.field_72995_K) {
            double charge = (double)Math.min(60, 72000 - timeLeft) / 60.0 * 17.0;
            float spawnDistance = 2.0f;
            double posX = entity.field_70165_t + entity.func_70040_Z().field_72450_a * (double)spawnDistance;
            double posY = entity.field_70163_u + (double)entity.func_70047_e() + entity.func_70040_Z().field_72448_b * (double)spawnDistance;
            double posZ = entity.field_70161_v + entity.func_70040_Z().field_72449_c * (double)spawnDistance;
            double value = Math.max(charge, 0.5);
            float aoeSize = (float)value * 0.125f;
            int lifetime = charge >= 1.0 ? 160 : 5;
            EffectArea effect = new EffectArea(new EffectDamage((float)value, DamageEmber.EMBER_DAMAGE_SOURCE_FACTORY, 1, 1.0), aoeSize, false);
            ProjectileFireball fireball = new ProjectileFireball((Entity)entity, new Vec3d(posX, posY, posZ), new Vec3d(entity.func_70040_Z().field_72450_a * 0.85, entity.func_70040_Z().field_72448_b * 0.85, entity.func_70040_Z().field_72449_c * 0.85), value, lifetime, effect);
            EmberProjectileEvent event = new EmberProjectileEvent(entity, stack, charge, fireball);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                for (IProjectilePreset projectile : event.getProjectiles()) {
                    projectile.shoot(world);
                }
            }
            SoundEvent sound = charge >= 10.0 ? SoundManager.FIREBALL_BIG : (charge >= 1.0 ? SoundManager.FIREBALL : SoundManager.CINDER_STAFF_FAIL);
            world.func_184148_a(null, posX, posY, posZ, sound, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        entity.func_184609_a(entity.func_184600_cs());
        stack.func_77978_p().func_74768_a("cooldown", 10);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.func_77973_b() != oldStack.func_77973_b();
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("cooldown", 0);
        } else if (stack.func_77978_p().func_74762_e("cooldown") > 0) {
            stack.func_77978_p().func_74768_a("cooldown", stack.func_77978_p().func_74762_e("cooldown") - 1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        double charge;
        if (stack.func_77978_p().func_74762_e("cooldown") > 0) {
            player.func_184602_cy();
        }
        boolean fullCharge = (charge = (double)Math.min(60, 72000 - count) / 60.0 * 15.0) >= 15.0;
        ItemVisualEvent event = new ItemVisualEvent(player, Misc.handToSlot(player.func_184600_cs()), stack, new Color(255, 64, 16), (SoundEvent)(fullCharge ? SoundManager.CINDER_STAFF_LOOP : null), 1.0f, 1.0f, "charge");
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (player.field_70170_p.field_72995_K) {
            if (event.hasSound()) {
                if (!soundPlaying) {
                    Embers.proxy.playItemSound(player, this, event.getSound(), SoundCategory.PLAYERS, true, event.getVolume(), event.getPitch());
                    soundPlaying = true;
                }
            } else {
                soundPlaying = false;
            }
        }
        if (event.hasParticles()) {
            for (int i = 0; i < 4; ++i) {
                float spawnDistance = 2.0f;
                Color color = event.getColor();
                ParticleUtil.spawnParticleGlow(player.func_130014_f_(), (float)player.field_70165_t + spawnDistance * (float)player.func_70040_Z().field_72450_a + (field_77697_d.nextFloat() * 0.1f - 0.05f), (float)player.field_70163_u + player.func_70047_e() + spawnDistance * (float)player.func_70040_Z().field_72448_b + (field_77697_d.nextFloat() * 0.1f - 0.05f), (float)player.field_70161_v + spawnDistance * (float)player.func_70040_Z().field_72449_c + (field_77697_d.nextFloat() * 0.1f - 0.05f), 0.0f, 0.0f, 0.0f, color.getRed(), color.getGreen(), color.getBlue(), (float)charge / 1.75f, 24);
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (EmberInventoryUtil.getEmberTotal(player) >= 25.0 && stack.func_77978_p().func_74762_e("cooldown") <= 0 || player.field_71075_bZ.field_75098_d) {
            EmberInventoryUtil.removeEmber(player, 25.0);
            player.func_184598_c(hand);
            if (world.field_72995_K) {
                Embers.proxy.playItemSound((EntityLivingBase)player, this, SoundManager.CINDER_STAFF_CHARGE, SoundCategory.PLAYERS, false, 1.0f, 1.0f);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }
}

