/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.api.projectile;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.api.projectile.IProjectileEffect;
import teamroots.embers.api.projectile.IProjectilePreset;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageCannonBeamFX;
import teamroots.embers.util.Misc;

public class ProjectileRay
implements IProjectilePreset {
    private static final Predicate<Entity> VALID_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity.func_70067_L();
        }
    }});
    Vec3d pos;
    Vec3d velocity;
    IProjectileEffect effect;
    Entity shooter;
    boolean pierceEntities;
    Color color = new Color(255, 64, 16);

    public ProjectileRay(Entity shooter, Vec3d start, Vec3d end, boolean pierceEntities, IProjectileEffect effect) {
        this.pos = start;
        this.velocity = end.func_178788_d(start);
        this.effect = effect;
        this.shooter = shooter;
        this.pierceEntities = pierceEntities;
    }

    @Override
    public Vec3d getPos() {
        return this.pos;
    }

    @Override
    public void setPos(Vec3d pos) {
        this.pos = pos;
    }

    @Override
    public Vec3d getVelocity() {
        return this.velocity;
    }

    @Override
    public void setVelocity(Vec3d velocity) {
        this.velocity = velocity;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public IProjectileEffect getEffect() {
        return this.effect;
    }

    @Override
    public void setEffect(IProjectileEffect effect) {
        this.effect = effect;
    }

    public boolean canPierceEntities() {
        return this.pierceEntities;
    }

    public void setPierceEntities(boolean pierceEntities) {
        this.pierceEntities = pierceEntities;
    }

    @Override
    @Nullable
    public Entity getEntity() {
        return null;
    }

    @Override
    @Nullable
    public Entity getShooter() {
        return this.shooter;
    }

    @Override
    public void shoot(World world) {
        double startX = this.getPos().field_72450_a;
        double startY = this.getPos().field_72448_b;
        double startZ = this.getPos().field_72449_c;
        double dX = this.getVelocity().field_72450_a;
        double dY = this.getVelocity().field_72448_b;
        double dZ = this.getVelocity().field_72449_c;
        double impactDist = Double.POSITIVE_INFINITY;
        boolean doContinue = true;
        Vec3d currPosVec = this.getPos();
        Vec3d newPosVector = this.getPos().func_178787_e(this.getVelocity());
        RayTraceResult blockTrace = world.func_147447_a(currPosVec, newPosVector, false, true, false);
        List<RayTraceResult> entityTraces = Misc.findEntitiesOnPath(world, null, this.shooter, new AxisAlignedBB(startX - 0.3, startY - 0.3, startZ - 0.3, startX + 0.3, startY + 0.3, startZ + 0.3), currPosVec, newPosVector, VALID_TARGETS);
        double distBlock = blockTrace != null ? this.getPos().func_72436_e(blockTrace.field_72307_f) : Double.POSITIVE_INFINITY;
        for (RayTraceResult entityTraceFirst : entityTraces) {
            if (!doContinue || entityTraceFirst == null || !(this.getPos().func_72436_e(entityTraceFirst.field_72307_f) < distBlock)) continue;
            this.effect.onHit(world, entityTraceFirst, this);
            if (this.pierceEntities) continue;
            impactDist = this.getPos().func_72438_d(entityTraceFirst.field_72307_f);
            doContinue = false;
        }
        if (doContinue && blockTrace != null) {
            this.effect.onHit(world, blockTrace, this);
            impactDist = this.getPos().func_72438_d(blockTrace.field_72307_f);
            doContinue = false;
        }
        if (doContinue) {
            this.effect.onFizzle(world, newPosVector, this);
            impactDist = this.getPos().func_72438_d(newPosVector);
        }
        if (!world.field_72995_K) {
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageCannonBeamFX(startX, startY, startZ, dX, dY, dZ, impactDist, this.color.getRGB()));
        }
    }
}

