/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.item;

import biomesoplenty.common.util.biome.BiomeUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.text.WordUtils;

public class ItemBiomeFinder
extends Item {
    public ItemBiomeFinder() {
        this.func_185043_a(new ResourceLocation("frame"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, World world, EntityLivingBase entity) {
                if (entity == null) {
                    return 0.0f;
                }
                NBTTagCompound nbt = stack.func_77978_p();
                if (nbt != null && nbt.func_74764_b("biomeIDToFind")) {
                    if (nbt.func_74764_b("searchStarted")) {
                        return this.getFlashingFrame(entity);
                    }
                    if (nbt.func_74767_n("found")) {
                        int posX = nbt.func_74762_e("posX");
                        int posZ = nbt.func_74762_e("posZ");
                        return this.getFrameForPositionRelativeToPlayer(entity, posX, posZ);
                    }
                    return 0.09f;
                }
                return 0.08f;
            }

            private float getFlashingFrame(EntityLivingBase entity) {
                return entity.field_70173_aa % 2 == 0 ? 0.1f : 0.11f;
            }

            private float getFrameForPositionRelativeToPlayer(EntityLivingBase entity, int biomePosX, int biomePosZ) {
                double xDiff = (double)biomePosX - entity.field_70165_t;
                double zDiff = (double)biomePosZ - entity.field_70161_v;
                double angleDiff = Math.atan2(zDiff, xDiff) * 180.0 / Math.PI + 270.0 - (double)entity.field_70177_z;
                int sector = (int)Math.floor((angleDiff + 22.5) / 45.0);
                return (float)((sector % 8 + 8) % 8) / 100.0f;
            }
        });
        this.func_77625_d(1);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        NBTTagCompound nbt;
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((nbt = stack.func_77978_p()) == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (nbt.func_74767_n("found")) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (nbt.func_74764_b("searchStarted") && world.func_72820_D() - nbt.func_74763_f("searchStarted") < 100L) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (!nbt.func_74764_b("biomeIDToFind")) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        Biome biomeToFind = Biome.func_150568_d((int)nbt.func_74762_e("biomeIDToFind"));
        ItemBiomeFinder.writeNBTSearching(nbt, world);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (biomeToFind != null && biomeToFind.getRegistryName() != null) {
            String biomeName = WordUtils.capitalize((String)biomeToFind.getRegistryName().func_110623_a());
            ItemBiomeFinder.sendChatMessage(player, "biome_finder.searching", biomeName, TextFormatting.DARK_PURPLE);
            BlockPos pos = BiomeUtils.spiralOutwardsLookingForBiome(world, biomeToFind, player.field_70165_t, player.field_70161_v);
            if (pos == null) {
                ItemBiomeFinder.sendChatMessage(player, "biome_finder.not_found", biomeName, TextFormatting.RED);
                ItemBiomeFinder.writeNBTNotFound(nbt);
            } else {
                ItemBiomeFinder.sendChatMessage(player, "biome_finder.found", biomeName, TextFormatting.GREEN);
                ItemBiomeFinder.writeNBTFound(nbt, pos);
            }
            return new ActionResult(EnumActionResult.PASS, (Object)stack.func_77946_l());
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private static void sendChatMessage(EntityPlayer player, String msg, Object format, TextFormatting color) {
        TextComponentTranslation chatComponent = new TextComponentTranslation(msg, new Object[]{format});
        chatComponent.func_150256_b().func_150238_a(color);
        player.func_145747_a((ITextComponent)chatComponent);
    }

    private static void writeNBTSearching(NBTTagCompound nbt, World world) {
        nbt.func_74757_a("found", false);
        nbt.func_74772_a("searchStarted", world.func_72820_D());
        nbt.func_82580_o("posX");
        nbt.func_82580_o("posZ");
    }

    private static void writeNBTFound(NBTTagCompound nbt, BlockPos pos) {
        nbt.func_74757_a("found", true);
        nbt.func_82580_o("searchStarted");
        nbt.func_74768_a("posX", pos.func_177958_n());
        nbt.func_74768_a("posZ", pos.func_177952_p());
    }

    private static void writeNBTNotFound(NBTTagCompound nbt) {
        nbt.func_74757_a("found", false);
        nbt.func_82580_o("searchStarted");
        nbt.func_82580_o("posX");
        nbt.func_82580_o("posZ");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        Biome biomeToFind;
        if (!itemStack.func_77942_o()) {
            return;
        }
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("biomeIDToFind") && (biomeToFind = Biome.func_150568_d((int)nbt.func_74762_e("biomeIDToFind"))) != null) {
            tooltip.add(biomeToFind.func_185359_l());
        }
    }
}

