/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.items.INetGUIItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemKey
extends Item
implements INetGUIItem {
    public static final String[] types = new String[]{"blank_key", "key", "key_ring"};
    public static final String ITEM_NAME = "key";

    public ItemKey() {
        this.func_77655_b("industrialwires.key");
        this.func_77627_a(true);
        this.func_77637_a(IndustrialWires.creativeTab);
        this.func_77625_d(64);
        this.setRegistryName(new ResourceLocation("industrialwires", ITEM_NAME));
        IndustrialWires.items.add(this);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(@Nonnull ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("name") && !nbt.func_74779_i("name").trim().isEmpty()) {
            return I18n.func_135052_a((String)"item.industrialwires.key.key_named.name", (Object[])new Object[0]) + " " + nbt.func_74779_i("name");
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77960_j() == 2 && stack.func_77978_p() != null) {
            NBTTagList keys = stack.func_77978_p().func_150295_c("ringkeys", 10);
            for (int i = 0; i < keys.func_74745_c() - 1; ++i) {
                tooltip.add(I18n.func_135052_a((String)"item.industrialwires.key.key_named.name", (Object[])new Object[0]) + " " + keys.func_150305_b(i).func_74779_i("name"));
            }
        }
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)this, 1, 0));
            subItems.add((Object)new ItemStack((Item)this, 1, 2));
        }
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return "item.industrialwires.key." + types[stack.func_77960_j()];
    }

    public static void setId(ItemStack stack, int lockID) {
        stack.func_77983_a("lockId", (NBTBase)new NBTTagInt(lockID));
    }

    public static int idForKey(@Nonnull ItemStack held) {
        if (held.func_77973_b() != IndustrialWires.key || held.func_77960_j() == 0) {
            return 0;
        }
        NBTTagCompound nbt = held.func_77978_p();
        if (nbt != null) {
            return nbt.func_74762_e("lockId");
        }
        return 0;
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand hand) {
        ItemStack held = playerIn.func_184586_b(hand);
        if (!worldIn.field_72995_K) {
            if (playerIn.func_70093_af() && held.func_77960_j() == 2) {
                NBTTagList allKeys;
                NBTTagCompound nbt = held.func_77978_p();
                if (nbt != null && (allKeys = nbt.func_150295_c("ringkeys", 10)).func_74745_c() > 1) {
                    NBTTagCompound next = allKeys.func_150305_b(0);
                    allKeys.func_74744_a(0);
                    allKeys.func_74742_a((NBTBase)next);
                    nbt.func_74768_a("lockId", next.func_74762_e("lockId"));
                    nbt.func_74778_a("name", next.func_74779_i("name"));
                    playerIn.field_71071_by.func_70296_d();
                }
            } else if (ItemKey.idForKey(held) != 0 && held.func_77960_j() == 1) {
                playerIn.openGui((Object)"industrialwires", 1, worldIn, 0, 0, hand == EnumHand.MAIN_HAND ? 1 : 0);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(hand));
    }

    @Override
    public void onChange(NBTTagCompound nbt, EntityPlayer p, EnumHand hand) {
        ItemStack held = p.func_184586_b(hand);
        String name = nbt.func_74779_i("name");
        if (!name.trim().isEmpty()) {
            held.func_77983_a("name", (NBTBase)new NBTTagString(name));
        } else {
            NBTTagCompound heldNBT = held.func_77978_p();
            if (heldNBT != null) {
                heldNBT.func_82580_o("name");
            }
        }
    }
}

