/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import malte0811.industrialwires.IEObjects;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.compat.Compat;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.oredict.OreIngredient;
import techreborn.api.TechRebornAPI;

public final class IC2TRHelper {
    public static Ingredient getStack(String type, String variant) {
        if (type.equals("crafting") && variant.equals("rubber") && ApiUtils.isExistingOreName((String)"itemRubber")) {
            return new OreIngredient("itemRubber");
        }
        HashSet<ItemStack> stacks = new HashSet<ItemStack>((Collection)Compat.getIC2Item.apply(type, variant));
        if (IndustrialWires.hasTechReborn) {
            switch (type) {
                case "cable": {
                    stacks.add(IC2TRHelper.getTRCable(variant));
                    break;
                }
                case "crafting": {
                    if (!"alloy".equals(variant)) break;
                    stacks.add(TechRebornAPI.subItemRetriever.getPlateByName("advanced_alloy"));
                    break;
                }
                case "te": {
                    if (!variant.equals("mv_transformer")) break;
                    stacks.add(new ItemStack(TechRebornAPI.getBlock((String)"MV_TRANSFORMER")));
                }
            }
        }
        stacks.removeIf(ItemStack::func_190926_b);
        Collection ingreds = stacks.stream().map(MyNBTIngredient::new).collect(Collectors.toList());
        if (ingreds.isEmpty()) {
            switch (type) {
                case "cable": {
                    return IC2TRHelper.getIECable(variant.substring("type:".length(), variant.indexOf(44)));
                }
                case "crafting": {
                    switch (variant) {
                        case "coil": {
                            ingreds.add(new MyIngredient(new ItemStack(IEObjects.blockMetalDecoration0)));
                            break;
                        }
                        case "alloy": {
                            return new OreIngredient("plateConstantan");
                        }
                        case "electric_motor": {
                            ingreds.add(new MyIngredient(new ItemStack(IEObjects.itemMaterial, 1, 27)));
                            break;
                        }
                        case "rubber": {
                            ingreds.add(new MyIngredient(new ItemStack(IEObjects.itemMaterial, 1, 13)));
                        }
                    }
                    break;
                }
                case "te": {
                    if (!variant.equals("mv_transformer")) break;
                    ingreds.add(new MyIngredient(new ItemStack(IEObjects.blockConnectors, 1, 7)));
                }
            }
        }
        if (ingreds.size() == 0) {
            IndustrialWires.logger.info("No ingredient found for " + type + ", " + variant);
        }
        return new MyCompoundIngredient(ingreds);
    }

    public static ItemStack getTRCable(String variant) {
        String cableType = variant.substring("type:".length(), variant.indexOf(44));
        int meta = -1;
        switch (cableType) {
            case "copper": {
                meta = 0;
                break;
            }
            case "tin": {
                meta = 1;
                break;
            }
            case "glass": {
                meta = 4;
                break;
            }
            case "gold": {
                meta = 2;
                break;
            }
            case "iron": {
                meta = 3;
            }
        }
        if (meta >= 0 && variant.charAt(variant.length() - 1) == '0') {
            return new ItemStack(TechRebornAPI.getBlock((String)"CABLE"), 1, meta);
        }
        return ItemStack.field_190927_a;
    }

    public static Ingredient getIECable(String type) {
        switch (type) {
            case "gold": {
                type = "electrum";
                break;
            }
            case "iron": {
                type = "steel";
                break;
            }
            case "tin": {
                type = "aluminum";
                break;
            }
            case "glass": {
                throw new IllegalArgumentException(type + " is not a valid IE wire type");
            }
        }
        type = Character.toUpperCase(type.charAt(0)) + type.substring(1);
        return new OreIngredient("wire" + type);
    }

    private static class MyIngredient
    extends Ingredient {
        public MyIngredient(ItemStack stack) {
            super(new ItemStack[]{stack});
        }
    }

    private static class MyCompoundIngredient
    extends CompoundIngredient {
        public MyCompoundIngredient(Collection<Ingredient> children) {
            super(children);
        }
    }

    private static class MyNBTIngredient
    extends IngredientNBT {
        public MyNBTIngredient(ItemStack stack) {
            super(stack);
        }
    }
}

