/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.blocks.controlpanel;

import java.util.List;
import javax.annotation.Nonnull;
import malte0811.industrialwires.blocks.controlpanel.TileEntityPanel;
import malte0811.industrialwires.controlpanel.ControlPanelNetwork;
import malte0811.industrialwires.controlpanel.PanelComponent;
import malte0811.industrialwires.controlpanel.PropertyComponents;
import malte0811.industrialwires.items.ItemPanelComponent;
import malte0811.industrialwires.util.MiscUtils;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class TileEntityComponentPanel
extends TileEntityPanel {
    private byte rsOut = 0;

    public TileEntityComponentPanel() {
        this.components = new PropertyComponents.AABBPanelProperties();
        this.panelNetwork = new SingleCompNetwork();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.field_145850_b.field_72995_K) {
            this.updateRSInput();
        }
    }

    public void updateRSInput() {
        int value = this.field_145850_b.func_175687_A(this.field_174879_c);
        if (value == 0) {
            for (EnumFacing f : EnumFacing.field_176754_o) {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(f));
                if (state.func_177230_c() != Blocks.field_150488_af || (Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O) <= value) continue;
                value = (Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
            }
        }
        ((SingleCompNetwork)this.panelNetwork).setGlobalInput((byte)value);
    }

    public void markBlockForUpdate(BlockPos pos) {
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.getBlockPos());
            this.field_145850_b.func_184138_a(pos, state, state, 3);
            this.field_145850_b.func_175685_c(pos, state.func_177230_c(), true);
        }
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        if (this.defAABB == null) {
            AxisAlignedBB base = ((PropertyComponents.AABBPanelProperties)this.components).getPanelBoundingBox();
            this.defAABB = MiscUtils.apply(this.components.getPanelBaseTransform(), base.func_186666_e((double)this.components.getMaxHeight()));
        }
        return this.defAABB;
    }

    public int getRSOutput() {
        return this.rsOut;
    }

    @Override
    @Nonnull
    public ItemStack getTileDrop(EntityPlayer player, @Nonnull IBlockState state) {
        if (this.components.size() < 1) {
            return ItemStack.field_190927_a;
        }
        return ItemPanelComponent.stackFromComponent((PanelComponent)this.components.get(0));
    }

    @Override
    public boolean canJoinNetwork() {
        return false;
    }

    public void setComponent(PanelComponent comp) {
        this.components.clear();
        this.components.add(comp);
        comp.setPanel(this);
        comp.setNetwork(this.panelNetwork);
    }

    private class SingleCompNetwork
    extends ControlPanelNetwork {
        private SingleCompNetwork() {
        }

        @Override
        public void setOutputs(ControlPanelNetwork.IOwner owner, ControlPanelNetwork.RSChannelState ... out) {
            super.setOutputs(owner, out);
            byte oldOut = TileEntityComponentPanel.this.rsOut;
            TileEntityComponentPanel.this.rsOut = (byte)0;
            for (ControlPanelNetwork.OutputValue s : this.activeOutputs.values()) {
                TileEntityComponentPanel.this.rsOut = (byte)Math.max(TileEntityComponentPanel.this.rsOut, s.getTargetState().getStrength());
            }
            if (oldOut != TileEntityComponentPanel.this.rsOut) {
                TileEntityComponentPanel.this.markBlockForUpdate(TileEntityComponentPanel.this.field_174879_c);
            }
        }

        public void setGlobalInput(byte value) {
            for (ControlPanelNetwork.RSChannel channel : this.listeners.keySet()) {
                ControlPanelNetwork.RSChannelState state = new ControlPanelNetwork.RSChannelState(channel, value);
                for (ControlPanelNetwork.ChangeListener l : (List)this.listeners.get(channel)) {
                    l.onChange(state);
                }
            }
        }
    }
}

