/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.ranks;

import com.feed_the_beast.ftblib.lib.config.ConfigNull;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.DefaultRankConfigHandler;
import com.feed_the_beast.ftblib.lib.config.IRankConfigHandler;
import com.feed_the_beast.ftblib.lib.config.RankConfigAPI;
import com.feed_the_beast.ftblib.lib.config.RankConfigValueInfo;
import com.feed_the_beast.ftblib.lib.util.misc.Node;
import com.feed_the_beast.ftbutilities.ranks.Rank;
import com.feed_the_beast.ftbutilities.ranks.Ranks;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.server.permission.DefaultPermissionHandler;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.IPermissionHandler;
import net.minecraftforge.server.permission.context.IContext;

public enum FTBUtilitiesPermissionHandler implements IPermissionHandler,
IRankConfigHandler
{
    INSTANCE;


    public void registerNode(String node, DefaultPermissionLevel level, String desc) {
        DefaultPermissionHandler.INSTANCE.registerNode(node, level, desc);
    }

    public Collection<String> getRegisteredNodes() {
        return DefaultPermissionHandler.INSTANCE.getRegisteredNodes();
    }

    public boolean hasPermission(GameProfile profile, String nodeS, @Nullable IContext context) {
        if (profile.getId() == null) {
            if (profile.getName() == null) {
                return false;
            }
            profile = new GameProfile(EntityPlayer.func_175147_b((String)profile.getName()), profile.getName());
        }
        switch (Ranks.getPermissionResult(null, profile, Node.get((String)nodeS), context, true)) {
            case ALLOW: {
                return true;
            }
            case DENY: {
                return false;
            }
        }
        return DefaultPermissionHandler.INSTANCE.hasPermission(profile, nodeS, context);
    }

    public String getNodeDescription(String node) {
        return DefaultPermissionHandler.INSTANCE.getNodeDescription(node);
    }

    public void registerRankConfig(RankConfigValueInfo info) {
        DefaultRankConfigHandler.INSTANCE.registerRankConfig(info);
    }

    public Collection<RankConfigValueInfo> getRegisteredConfigs() {
        return DefaultRankConfigHandler.INSTANCE.getRegisteredConfigs();
    }

    public ConfigValue getConfigValue(MinecraftServer server, GameProfile profile, Node node, @Nullable IContext context) {
        Rank rank;
        ConfigNull value = ConfigNull.INSTANCE;
        if (Ranks.isActive() && !(rank = Ranks.INSTANCE.getRank(server, profile, context)).isNone() && (value = rank.cachedConfig.get(node)) == null) {
            RankConfigValueInfo info;
            value = ConfigNull.INSTANCE;
            JsonElement json = rank.getConfigRaw(node);
            if (!json.isJsonNull() && (info = RankConfigAPI.getHandler().getInfo(node)) != null) {
                value = info.defaultValue.copy();
                value.setValueFromJson(json);
            }
            rank.cachedConfig.put(node, (ConfigValue)value);
        }
        return value.isNull() ? DefaultRankConfigHandler.INSTANCE.getConfigValue(server, profile, node, context) : value;
    }

    @Nullable
    public RankConfigValueInfo getInfo(Node node) {
        return DefaultRankConfigHandler.INSTANCE.getInfo(node);
    }
}

