/*
 * Decompiled with CFR 0.152.
 */
package com.kjmaster.kjlib.common.energy;

import com.kjmaster.kjlib.common.energy.IItemEnergy;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class InvEnergyStorage
implements IEnergyStorage,
ICapabilitySerializable<NBTBase> {
    private int capacity;
    private int maxReceive;
    private int maxExtract;
    private ItemStack container;
    private IItemEnergy itemEnergy;

    public InvEnergyStorage(int capacity, int maxReceive, int maxExtract, ItemStack stack, IItemEnergy itemEnergy) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.container = stack;
        this.itemEnergy = itemEnergy;
    }

    public NBTBase serializeNBT() {
        if (this.container.func_77942_o()) {
            NBTTagCompound tagCompound = this.container.func_77978_p();
            if (tagCompound.func_74764_b("Energy")) {
                tagCompound.func_74768_a("Energy", this.getEnergyStored());
            } else {
                NBTTagCompound newTagCompound = new NBTTagCompound();
                newTagCompound.func_74768_a("Energy", this.getEnergyStored());
                this.container.func_77982_d(newTagCompound);
            }
        }
        return this.container.func_77978_p();
    }

    public void deserializeNBT(NBTBase nbt) {
        NBTTagCompound tagCompound = (NBTTagCompound)nbt;
        if (tagCompound != null && tagCompound.func_74764_b("Energy")) {
            int energy = tagCompound.func_74762_e("Energy");
            this.setEnergy(energy);
        } else {
            NBTTagCompound newTagCompound = new NBTTagCompound();
            newTagCompound.func_74768_a("Energy", this.getEnergyStored());
            this.container.func_77982_d(newTagCompound);
        }
    }

    public void setEnergy(int energy) {
        this.checkForEnergyTag();
        this.container.func_77978_p().func_74768_a("Energy", energy);
    }

    public void setCapacity(int capacity) {
        this.checkForEnergyTag();
        this.capacity = capacity;
        if (this.getEnergyStored() > capacity) {
            this.container.func_77978_p().func_74768_a("Energy", capacity);
        }
    }

    private void checkForEnergyTag() {
        if (this.container.func_77942_o()) {
            NBTTagCompound tagCompound = this.container.func_77978_p();
            if (!tagCompound.func_74764_b("Energy")) {
                tagCompound.func_74768_a("Energy", 0);
            }
        } else {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74768_a("Energy", 0);
            this.container.func_77982_d(tagCompound);
        }
    }

    public void setMaxTransfer(int maxTransfer) {
        this.setMaxReceive(maxTransfer);
        this.setMaxExtract(maxTransfer);
    }

    void setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
    }

    void setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.itemEnergy.receiveEnergy(this.container, maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.itemEnergy.extractEnergy(this.container, maxExtract, simulate);
    }

    public int getEnergyStored() {
        this.checkForEnergyTag();
        return this.container.func_77978_p().func_74762_e("Energy");
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return capability == CapabilityEnergy.ENERGY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing from) {
        if (!this.hasCapability(capability, from)) {
            return null;
        }
        return (T)CapabilityEnergy.ENERGY.cast((Object)this);
    }
}

