/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.enchantment.amulet;

import hellfirepvp.astralsorcery.common.enchantment.dynamic.DynamicEnchantment;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AmuletEnchantment
extends DynamicEnchantment {
    public AmuletEnchantment(DynamicEnchantment.Type type, @Nonnull Enchantment enchantment, int levelAddition) {
        super(type, enchantment, levelAddition);
    }

    public AmuletEnchantment(DynamicEnchantment.Type type, int levelAddition) {
        super(type, levelAddition);
    }

    @SideOnly(value=Side.CLIENT)
    public String getDescription() {
        String unlocKey = "amulet.enchantment." + this.type.name().toLowerCase() + ".name";
        String locLevels = I18n.func_135052_a((String)("amulet.enchantment.level." + (this.levelAddition == 1 ? "one" : "more")), (Object[])new Object[0]);
        if (this.type.hasEnchantmentTag()) {
            String locEnch = I18n.func_135052_a((String)this.enchantment.func_77320_a(), (Object[])new Object[0]);
            return I18n.func_135052_a((String)unlocKey, (Object[])new Object[]{String.valueOf(this.levelAddition), locLevels, locEnch});
        }
        return I18n.func_135052_a((String)unlocKey, (Object[])new Object[]{String.valueOf(this.levelAddition), locLevels});
    }

    public boolean canMerge(AmuletEnchantment other) {
        return this.type.equals((Object)other.type) && (!this.type.hasEnchantmentTag() || this.enchantment.equals(other.enchantment));
    }

    public void merge(AmuletEnchantment src) {
        if (this.canMerge(src)) {
            this.levelAddition += src.levelAddition;
        }
    }

    public NBTTagCompound serialize() {
        NBTTagCompound cmp = new NBTTagCompound();
        cmp.func_74768_a("type", this.type.ordinal());
        cmp.func_74768_a("level", this.levelAddition);
        if (this.type.hasEnchantmentTag()) {
            cmp.func_74778_a("ench", this.enchantment.getRegistryName().toString());
        }
        return cmp;
    }

    @Nullable
    public static AmuletEnchantment deserialize(NBTTagCompound cmp) {
        int typeId = cmp.func_74762_e("type");
        DynamicEnchantment.Type type = DynamicEnchantment.Type.values()[MathHelper.func_76125_a((int)typeId, (int)0, (int)(DynamicEnchantment.Type.values().length - 1))];
        int level = Math.max(0, cmp.func_74762_e("level"));
        if (type.hasEnchantmentTag()) {
            ResourceLocation res = new ResourceLocation(cmp.func_74779_i("ench"));
            Enchantment e = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(res);
            if (e != null) {
                return new AmuletEnchantment(type, e, level);
            }
        } else {
            return new AmuletEnchantment(type, level);
        }
        return null;
    }
}

