/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.tools;

import javax.annotation.Nonnull;
import mcjty.lib.tools.ItemStackTools;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidTools {
    @Nonnull
    public static ItemStack convertFluidToBucket(@Nonnull FluidStack fluidStack) {
        IFluidHandlerItem fh = FluidUtil.getFluidHandler((ItemStack)new ItemStack(Items.field_151133_ar));
        fh.fill(fluidStack, true);
        return fh.getContainer();
    }

    public static FluidStack convertBucketToFluid(@Nonnull ItemStack bucket) {
        IFluidTankProperties[] tankProperties;
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)bucket);
        if (fluidHandler == null) {
            return null;
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            FluidStack contents = properties.getContents();
            if (contents == null) continue;
            return contents;
        }
        return null;
    }

    public static boolean isEmptyContainer(@Nonnull ItemStack itemStack) {
        IFluidTankProperties[] tankProperties;
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack);
        if (fluidHandler == null) {
            return false;
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            if (!properties.canFill() || properties.getCapacity() <= 0) continue;
            FluidStack contents = properties.getContents();
            if (contents == null) {
                return true;
            }
            if (contents.amount <= 0) continue;
            return false;
        }
        return false;
    }

    public static boolean isFilledContainer(@Nonnull ItemStack itemStack) {
        IFluidTankProperties[] tankProperties;
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack);
        if (fluidHandler == null) {
            return false;
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            if (!properties.canDrain()) {
                return false;
            }
            FluidStack contents = properties.getContents();
            if (contents != null && contents.amount >= properties.getCapacity()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public static ItemStack drainContainer(@Nonnull ItemStack container) {
        ItemStack empty = container.func_77946_l();
        ItemStackTools.setStackSize(empty, 1);
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)empty);
        if (fluidHandler == null) {
            return ItemStackTools.getEmptyStack();
        }
        if (fluidHandler.drain(Integer.MAX_VALUE, true) != null) {
            return fluidHandler.getContainer();
        }
        return ItemStackTools.getEmptyStack();
    }

    @Nonnull
    public static ItemStack fillContainer(@Nonnull FluidStack fluidStack, @Nonnull ItemStack itemStack) {
        IFluidHandlerItem fh = FluidUtil.getFluidHandler((ItemStack)itemStack.func_77946_l());
        int filled = fh.fill(fluidStack, true);
        if (filled == 0) {
            return ItemStackTools.getEmptyStack();
        }
        return fh.getContainer();
    }

    public static int getCapacity(@Nonnull FluidStack fluidStack, @Nonnull ItemStack itemStack) {
        IFluidTankProperties[] tankProperties;
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack);
        if (fluidHandler == null) {
            return 0;
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            if (!properties.canDrainFluidType(fluidStack)) continue;
            return properties.getCapacity();
        }
        return 0;
    }
}

