/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.client.render.vbo;

import code.elix_x.excomms.reflection.ReflectionHelper;
import code.elix_x.excore.utils.client.render.IVertexBuffer;
import code.elix_x.excore.utils.client.render.OpenGLHelper;
import code.elix_x.excore.utils.client.render.vbo.VBO;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class VertexBufferSingleVBO
implements IVertexBuffer {
    protected final VertexFormat format;
    protected final int drawMode;
    protected final int vertexCount;
    private final VBO vbo;
    private static final Supplier<IllegalArgumentException> EXC = () -> new IllegalArgumentException("Failed ro reflect fields necessary for VertexBufferSingleVBO");
    private static final ReflectionHelper.AClass<VertexBuffer> vertexBufferClass = new ReflectionHelper.AClass<VertexBuffer>(VertexBuffer.class);
    private static final ReflectionHelper.AField<VertexBuffer, Integer> glBufferId = (ReflectionHelper.AField)vertexBufferClass.getDeclaredField("glBufferId", "field_177365_a").orElseThrow(EXC).setAccessible(true);
    private static final ReflectionHelper.AField<VertexBuffer, VertexFormat> vertexFormat = (ReflectionHelper.AField)vertexBufferClass.getDeclaredField("vertexFormat", "field_177363_b").orElseThrow(EXC).setAccessible(true);
    private static final ReflectionHelper.AField<VertexBuffer, Integer> count = (ReflectionHelper.AField)vertexBufferClass.getDeclaredField("count", "field_177363_b").orElseThrow(EXC).setAccessible(true);
    private boolean modifyClientStates = true;

    private VertexBufferSingleVBO(VertexFormat format, int drawMode, int vertexCount, VBO vbo) {
        this.format = format;
        this.drawMode = drawMode;
        this.vertexCount = vertexCount;
        this.vbo = vbo;
    }

    public VertexBufferSingleVBO(BufferBuilder vertexBuffer) {
        this(vertexBuffer.func_178973_g(), vertexBuffer.func_178979_i(), vertexBuffer.func_178989_h(), new VBO());
        ByteBuffer buffer = vertexBuffer.func_178966_f();
        this.vbo.bind();
        this.vbo.data(buffer, 35044);
        this.vbo.unbind();
    }

    public VertexBufferSingleVBO(VertexBuffer vertexBuffer, int drawMode) {
        this(vertexFormat.get(vertexBuffer).get(), drawMode, count.get(vertexBuffer).get(), new VBO(glBufferId.get(vertexBuffer).get()));
    }

    public VertexBufferSingleVBO setModifyClientStates(boolean modifyClientStates) {
        this.modifyClientStates = modifyClientStates;
        return this;
    }

    protected void renderPre() {
        this.vbo.bind();
        if (this.modifyClientStates) {
            OpenGLHelper.enableClientState(this.format);
        }
        block8: for (int i = 0; i < this.format.func_177345_h(); ++i) {
            VertexFormatElement element = this.format.func_177348_c(i);
            switch (element.func_177375_c()) {
                case POSITION: {
                    GL11.glVertexPointer((int)element.func_177370_d(), (int)element.func_177367_b().func_177397_c(), (int)this.format.func_177338_f(), (long)this.format.func_181720_d(i));
                    continue block8;
                }
                case NORMAL: {
                    GL11.glNormalPointer((int)element.func_177367_b().func_177397_c(), (int)this.format.func_177338_f(), (long)this.format.func_181720_d(i));
                    continue block8;
                }
                case COLOR: {
                    GL11.glColorPointer((int)element.func_177370_d(), (int)element.func_177367_b().func_177397_c(), (int)this.format.func_177338_f(), (long)this.format.func_181720_d(i));
                    continue block8;
                }
                case UV: {
                    OpenGlHelper.func_77472_b((int)(OpenGlHelper.field_77478_a + element.func_177369_e()));
                    GL11.glTexCoordPointer((int)element.func_177370_d(), (int)element.func_177367_b().func_177397_c(), (int)this.format.func_177338_f(), (long)this.format.func_181720_d(i));
                    continue block8;
                }
                case PADDING: {
                    continue block8;
                }
                case GENERIC: {
                    GL20.glEnableVertexAttribArray((int)element.func_177369_e());
                    GL20.glVertexAttribPointer((int)element.func_177369_e(), (int)element.func_177370_d(), (int)element.func_177367_b().func_177397_c(), (boolean)false, (int)this.format.func_177338_f(), (long)this.format.func_181720_d(i));
                    continue block8;
                }
            }
        }
    }

    @Override
    public final void draw() {
        this.renderPre();
        GlStateManager.func_187439_f((int)this.drawMode, (int)0, (int)this.vertexCount);
        this.renderPost();
    }

    protected void renderPost() {
        if (this.modifyClientStates) {
            OpenGLHelper.disableClientState(this.format);
        }
        this.vbo.unbind();
    }

    @Override
    public void cleanUp() {
        this.vbo.cleanUp();
    }
}

