/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.client.render.pipeline.model;

import code.elix_x.excomms.pipeline.PipelineElement;
import code.elix_x.excore.utils.client.render.model.UnpackedSimpleBakedModel;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class ModelDataModifier
implements PipelineElement<UnpackedSimpleBakedModel, UnpackedSimpleBakedModel> {
    private final Optional<Function<Boolean, Boolean>> ambientOcclusion;
    private final Optional<Function<Boolean, Boolean>> gui3d;
    private final Optional<Function<TextureAtlasSprite, TextureAtlasSprite>> texture;
    private final Optional<Function<ItemCameraTransforms, ItemCameraTransforms>> cameraTransforms;
    private final Optional<Function<ItemOverrideList, ItemOverrideList>> itemOverrideList;

    public static ModelDataModifier ambientOcclusion(Function<Boolean, Boolean> ambientOcclusion) {
        return new ModelDataModifier(ambientOcclusion, null, null, null, null);
    }

    public static ModelDataModifier gui3d(Function<Boolean, Boolean> gui3d) {
        return new ModelDataModifier(null, gui3d, null, null, null);
    }

    public static ModelDataModifier texture(Function<TextureAtlasSprite, TextureAtlasSprite> texture) {
        return new ModelDataModifier(null, null, texture, null, null);
    }

    public static ModelDataModifier cameraTransforms(Function<ItemCameraTransforms, ItemCameraTransforms> cameraTransforms) {
        return new ModelDataModifier(null, null, null, cameraTransforms, null);
    }

    public static ModelDataModifier itemOverrideList(Function<ItemOverrideList, ItemOverrideList> itemOverrideList) {
        return new ModelDataModifier(null, null, null, null, itemOverrideList);
    }

    public ModelDataModifier(Optional<Function<Boolean, Boolean>> ambientOcclusion, Optional<Function<Boolean, Boolean>> gui3d, Optional<Function<TextureAtlasSprite, TextureAtlasSprite>> texture, Optional<Function<ItemCameraTransforms, ItemCameraTransforms>> cameraTransforms, Optional<Function<ItemOverrideList, ItemOverrideList>> itemOverrideList) {
        this.ambientOcclusion = ambientOcclusion;
        this.gui3d = gui3d;
        this.texture = texture;
        this.cameraTransforms = cameraTransforms;
        this.itemOverrideList = itemOverrideList;
    }

    public ModelDataModifier(Function<Boolean, Boolean> ambientOcclusion, Function<Boolean, Boolean> gui3d, Function<TextureAtlasSprite, TextureAtlasSprite> texture, Function<ItemCameraTransforms, ItemCameraTransforms> cameraTransforms, Function<ItemOverrideList, ItemOverrideList> itemOverrideList) {
        this(Optional.ofNullable(ambientOcclusion), Optional.ofNullable(gui3d), Optional.ofNullable(texture), Optional.ofNullable(cameraTransforms), Optional.ofNullable(itemOverrideList));
    }

    @Override
    public UnpackedSimpleBakedModel pipe(UnpackedSimpleBakedModel in) {
        this.ambientOcclusion.ifPresent(funct -> in.setAmbientOcclusion((Boolean)funct.apply(in.isAmbientOcclusion())));
        this.gui3d.ifPresent(funct -> in.setGui3d((Boolean)funct.apply(in.isGui3d())));
        this.texture.ifPresent(funct -> in.setTexture((TextureAtlasSprite)funct.apply(in.getTexture())));
        this.cameraTransforms.ifPresent(funct -> in.setCameraTransforms((ItemCameraTransforms)funct.apply(in.getCameraTransforms())));
        this.itemOverrideList.ifPresent(funct -> in.setItemOverrideList((ItemOverrideList)funct.apply(in.getItemOverrideList())));
        return in;
    }
}

