/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.client.thingy;

import code.elix_x.excomms.color.RGBA;
import code.elix_x.excore.client.debug.AdvancedDebugTools;
import code.elix_x.excore.client.thingy.ThingyData;
import code.elix_x.excore.utils.client.gui.ElementalGuiScreen;
import code.elix_x.excore.utils.client.gui.elements.ButtonGuiElement;
import code.elix_x.excore.utils.client.gui.elements.CenteredStringGuiElement;
import code.elix_x.excore.utils.client.gui.elements.ColoredRectangleGuiElement;
import code.elix_x.excore.utils.client.gui.elements.GlintRectangleGuiElement;
import code.elix_x.excore.utils.client.gui.elements.GuiElement;
import code.elix_x.excore.utils.client.gui.elements.IGuiElement;
import code.elix_x.excore.utils.client.gui.elements.IGuiElementsHandler;
import code.elix_x.excore.utils.client.gui.elements.TexturedRectangleGuiElement;
import code.elix_x.excore.utils.client.resource.PrecacheResourcePack;
import code.elix_x.excore.utils.client.resource.WebResourcePack;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Mouse;

public class ThingyDisplay
implements IGuiElementsHandler<MovingHuman> {
    private static final String DOMAIN = "excorethingy";
    private final String loc;
    private final ThingyData data;
    private final Random random;
    private final int chance;
    private Multimap<GuiScreen, MovingHuman> guiHumansMultimap = HashMultimap.create();
    private PrecacheResourcePack cacheRP;
    private boolean failed = false;
    private LoadingCache<String, ResourceLocation> cachedIcons = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<String, ResourceLocation>(){

        public ResourceLocation load(String icon) {
            return new ResourceLocation(ThingyDisplay.DOMAIN, (icon = icon.replace(':', '\ue01a')).startsWith("http") ? icon : ThingyDisplay.this.loc + icon);
        }
    });

    ThingyDisplay(String loc, ThingyData data, Random random, int chance) {
        this.loc = loc;
        this.data = data;
        this.random = random;
        this.chance = chance;
        this.cacheRP = new PrecacheResourcePack(new WebResourcePack(DOMAIN));
        try {
            this.cacheRP.precache(this.getAllIcons());
        }
        catch (IOException e) {
            this.failed = true;
        }
        if (!this.failed) {
            AdvancedDebugTools.registerGUI(18, () -> {
                if (Minecraft.func_71410_x().field_71462_r != null) {
                    this.regenHumans(Minecraft.func_71410_x().field_71462_r);
                }
            });
        }
    }

    void cacheIcons() {
        if (this.failed) {
            return;
        }
        this.cacheRP.registerAsDefault();
        this.getAllIcons().forEach(icon -> Minecraft.func_71410_x().func_110434_K().func_110579_a(icon, (ITextureObject)new SimpleTexture(icon)));
    }

    private ResourceLocation getCachedIcon(String icon) {
        return (ResourceLocation)this.cachedIcons.getUnchecked((Object)icon);
    }

    private Stream<ResourceLocation> getAllIcons() {
        return Stream.concat(this.data.humans.stream().map(human -> human.icon), this.data.linkIcons.values().stream()).map(this::getCachedIcon);
    }

    private void regenHumans(GuiScreen gui) {
        if (this.failed) {
            return;
        }
        this.guiHumansMultimap.removeAll((Object)gui);
        List<ThingyData.Human> all = this.data.humans;
        ArrayList<ThingyData.Human> c = new ArrayList<ThingyData.Human>();
        int cc = 1 + this.random.nextInt(all.size());
        for (int i = 0; i < cc; ++i) {
            ThingyData.Human h = all.get(this.random.nextInt(all.size()));
            while (c.contains(h)) {
                h = all.get(this.random.nextInt(all.size()));
            }
            c.add(h);
        }
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
        for (ThingyData.Human h : c) {
            int size = 16 + this.random.nextInt(32);
            this.guiHumansMultimap.put((Object)gui, (Object)new MovingHuman(h, size, size, new Vec3i(this.random.nextInt(res.func_78326_a() - size), this.random.nextInt(res.func_78328_b() - size), 0), new Vec3d(this.random.nextDouble(), this.random.nextDouble(), 0.0), 1 + this.random.nextInt(9), CollisionPhysics.values()[this.random.nextInt(CollisionPhysics.values().length)]));
        }
    }

    @SubscribeEvent
    public void open(GuiOpenEvent event) {
        if (!(event.getGui() instanceof HumanGui) && !(Minecraft.func_71410_x().field_71462_r instanceof HumanGui)) {
            this.guiHumansMultimap.removeAll((Object)Minecraft.func_71410_x().field_71462_r);
            if (this.random.nextInt(this.chance) == 0) {
                this.regenHumans(event.getGui());
            }
        }
    }

    @SubscribeEvent
    public void tick(GuiScreenEvent.DrawScreenEvent.Pre event) {
        for (MovingHuman human : this.guiHumansMultimap.get((Object)event.getGui())) {
            human.update(new ScaledResolution(Minecraft.func_71410_x()));
        }
    }

    @SubscribeEvent
    public void draw(GuiScreenEvent.DrawScreenEvent.Post event) {
        for (MovingHuman human : this.guiHumansMultimap.get((Object)event.getGui())) {
            human.drawGuiPost(this, event.getGui(), event.getMouseX(), event.getMouseY(), event.getRenderPartialTicks());
        }
        for (MovingHuman human : this.guiHumansMultimap.get((Object)event.getGui())) {
            human.drawGuiPostPost(this, event.getGui(), event.getMouseX(), event.getMouseY(), event.getRenderPartialTicks());
        }
    }

    @SubscribeEvent
    public void click(GuiScreenEvent.MouseInputEvent event) {
        for (MovingHuman human : this.guiHumansMultimap.get((Object)event.getGui())) {
            if (!human.handleMouseEvent(this, event.getGui(), GuiElement.mouseX(), GuiElement.mouseY(), Mouse.getEventButtonState(), Mouse.getEventButton())) continue;
            event.setCanceled(true);
        }
    }

    @Override
    public void add(MovingHuman element) {
    }

    @Override
    public MovingHuman getFocused() {
        return null;
    }

    @Override
    public void setFocused(MovingHuman element) {
    }

    @Override
    public void looseFocus() {
    }

    public static enum CollisionPhysics {
        REFLECTION{

            @Override
            public Vec3d apply(Random random, ScaledResolution res, Vec3d pos, int sizeX, int sizeY, Vec3d motion) {
                Vec3d norm = null;
                if (pos.field_72450_a <= 0.0) {
                    norm = new Vec3d(1.0, 0.0, 0.0);
                } else if (pos.field_72450_a >= (double)(res.func_78326_a() - sizeX)) {
                    norm = new Vec3d(-1.0, 0.0, 0.0);
                } else if (pos.field_72448_b <= 0.0) {
                    norm = new Vec3d(0.0, 1.0, 0.0);
                } else if (pos.field_72448_b >= (double)(res.func_78328_b() - sizeY)) {
                    norm = new Vec3d(0.0, -1.0, 0.0);
                }
                if (norm != null) {
                    motion = motion.func_178788_d(CollisionPhysics.mul(norm, motion.func_72430_b(norm) * 2.0));
                }
                return motion;
            }
        }
        ,
        RANDOMONREFLECTION{

            @Override
            public Vec3d apply(Random random, ScaledResolution res, Vec3d pos, int sizeX, int sizeY, Vec3d motion) {
                Vec3d norm = null;
                if (pos.field_72450_a <= 0.0) {
                    norm = new Vec3d(1.0, 0.0, 0.0);
                } else if (pos.field_72450_a >= (double)(res.func_78326_a() - sizeX)) {
                    norm = new Vec3d(-1.0, 0.0, 0.0);
                } else if (pos.field_72448_b <= 0.0) {
                    norm = new Vec3d(0.0, 1.0, 0.0);
                } else if (pos.field_72448_b >= (double)(res.func_78328_b() - sizeY)) {
                    norm = new Vec3d(0.0, -1.0, 0.0);
                }
                if (norm != null) {
                    motion = motion.func_178788_d(CollisionPhysics.mul(norm, motion.func_72430_b(norm) * 2.0));
                    float angle = -25 + random.nextInt(50);
                    float cos = (float)Math.cos(Math.toRadians(angle));
                    float sin = (float)Math.sin(Math.toRadians(angle));
                    return new Vec3d(motion.field_72450_a * (double)cos - motion.field_72448_b * (double)sin, motion.field_72450_a * (double)sin + motion.field_72448_b * (double)cos, motion.field_72449_c);
                }
                return motion;
            }
        }
        ,
        RANDOMREFLECTION{

            @Override
            public Vec3d apply(Random random, ScaledResolution res, Vec3d pos, int sizeX, int sizeY, Vec3d motion) {
                float angle = -25 + random.nextInt(50);
                float cos = (float)Math.cos(Math.toRadians(angle));
                float sin = (float)Math.sin(Math.toRadians(angle));
                return REFLECTION.apply(random, res, pos, sizeX, sizeY, new Vec3d(motion.field_72450_a * (double)cos - motion.field_72448_b * (double)sin, motion.field_72450_a * (double)sin + motion.field_72448_b * (double)cos, motion.field_72449_c));
            }
        };


        public abstract Vec3d apply(Random var1, ScaledResolution var2, Vec3d var3, int var4, int var5, Vec3d var6);

        private static Vec3d mul(Vec3d vec, double d) {
            return new Vec3d(vec.field_72450_a * d, vec.field_72448_b * d, vec.field_72449_c * d);
        }
    }

    public class HumanGui
    extends ElementalGuiScreen {
        private final ThingyData.Human human;
        private final ResourceLocation icon;

        public HumanGui(GuiScreen parent, ThingyData.Human human, ResourceLocation icon) {
            super(parent, 256, 256);
            this.human = human;
            this.icon = icon;
        }

        @Override
        protected void addElements() {
            this.add((IGuiElement<ElementalGuiScreen>)new ColoredRectangleGuiElement<ElementalGuiScreen>("Shadow", 0, 0, this.field_146294_l, this.field_146295_m, 0, 0, new RGBA(0.0f, 0.0f, 0.0f, 0.83f)));
            this.add((IGuiElement<ElementalGuiScreen>)new TexturedRectangleGuiElement<ElementalGuiScreen>("Texture", this.xPos + 64, this.yPos, 128, 128, 0, 0, this.icon));
            if (this.human.getCategory((ThingyData)((ThingyDisplay)ThingyDisplay.this).data).glint) {
                this.add((IGuiElement<ElementalGuiScreen>)new GlintRectangleGuiElement<ElementalGuiScreen>("Texture", this.xPos + 64, this.yPos, 128, 128, 0, 0, this.human.getCategory((ThingyData)((ThingyDisplay)ThingyDisplay.this).data).color));
            }
            this.nextY += 130;
            for (ITextComponent bio : this.human.bio) {
                this.add((IGuiElement<ElementalGuiScreen>)new CenteredStringGuiElement<ElementalGuiScreen>("Bio", this.xPos + 128, this.nextY, 2, 2, bio.func_150254_d(), this.field_146289_q, this.human.getCategory((ThingyData)((ThingyDisplay)ThingyDisplay.this).data).color));
                this.nextY += 12;
            }
            List<ThingyData.Human.Link> links = this.human.links;
            if (links != null && links.size() > 0) {
                int nextX = this.xPos + 128 - links.size() * 68 / 2;
                for (final ThingyData.Human.Link link : links) {
                    this.add(new ButtonGuiElement("Link", nextX, this.nextY, 64, 64, 2, 2, link.url.toString()){

                        @Override
                        public void drawGuiPost(IGuiElementsHandler handler, GuiScreen gui, int mouseX, int mouseY, float partialTicks) {
                        }

                        @Override
                        public void drawGuiPostPost(IGuiElementsHandler handler, GuiScreen gui, int mouseX, int mouseY, float partialTicks) {
                            if (this.inside(mouseX, mouseY)) {
                                1.drawTooltipWithBackground(HumanGui.this.field_146289_q, mouseX, mouseY, false, true, link.url.toString());
                            }
                        }

                        @Override
                        public void onButtonPressed() {
                            super.onButtonPressed();
                            HumanGui.this.func_175276_a(new TextComponentString("").func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, link.url.toString()))));
                        }
                    });
                    this.add((IGuiElement<ElementalGuiScreen>)new TexturedRectangleGuiElement<ElementalGuiScreen>("Link Texture", nextX, this.nextY, 64, 64, 2, 2, ThingyDisplay.this.getCachedIcon(link.getIcon(ThingyDisplay.this.data))));
                    nextX += 68;
                }
            }
            this.parent.func_183500_a(this.field_146294_l, this.field_146295_m);
            this.parent.func_73866_w_();
        }

        @Override
        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.parent.func_73863_a(mouseX, mouseY, partialTicks);
            super.func_73863_a(mouseX, mouseY, partialTicks);
        }
    }

    public class MovingHuman
    extends ButtonGuiElement<ThingyDisplay> {
        private final ThingyData.Human human;
        private int sizeX;
        private int sizeY;
        private Vec3i pos;
        private Vec3d motion;
        private int speed;
        private CollisionPhysics physics;
        private ResourceLocation icon;

        public MovingHuman(ThingyData.Human human, int sizeX, int sizeY, Vec3i pos, Vec3d motion, int speed, CollisionPhysics physics) {
            super(human.name, 0, 0, sizeX, sizeY, 0, 0, "");
            this.sizeX = 32;
            this.sizeY = 32;
            this.human = human;
            this.icon = ThingyDisplay.this.getCachedIcon(human.icon);
            this.pos = pos;
            this.motion = motion;
            this.speed = speed;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.physics = physics;
        }

        public void update(ScaledResolution res) {
            Vec3d pos = new Vec3d(this.pos);
            for (int i = 0; i < this.speed; ++i) {
                this.motion = this.physics.apply(ThingyDisplay.this.random, res, pos, this.sizeX, this.sizeY, this.motion);
                pos = pos.func_178787_e(this.motion);
            }
            if (pos.field_72450_a + (double)this.sizeX < 0.0 || (double)res.func_78326_a() < pos.field_72450_a || pos.field_72448_b + (double)this.sizeY < 0.0 || (double)res.func_78328_b() < pos.field_72448_b) {
                pos = new Vec3d((double)ThingyDisplay.this.random.nextInt(res.func_78326_a() - this.sizeX), (double)ThingyDisplay.this.random.nextInt(res.func_78328_b() - this.sizeY), 0.0);
            }
            this.pos = new Vec3i(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }

        @Override
        public void drawGuiPost(ThingyDisplay handler, GuiScreen gui, int mouseX, int mouseY, float partialTicks) {
            this.xPos = this.pos.func_177958_n();
            this.yPos = this.pos.func_177956_o();
            this.resetButton();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.icon);
            MovingHuman.drawTexturedRect(this.toRectangle(), new Vec2f(0.0f, 0.0f), new Vec2f(1.0f, 1.0f));
        }

        @Override
        public void drawGuiPostPost(ThingyDisplay handler, GuiScreen gui, int mouseX, int mouseY, float partialTicks) {
            if (this.inside(mouseX, mouseY)) {
                MovingHuman.drawTooltipWithBackground(Minecraft.func_71410_x().field_71466_p, mouseX, mouseY, false, true, this.human.name);
            }
        }

        @Override
        public void onButtonPressed() {
            super.onButtonPressed();
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new HumanGui(Minecraft.func_71410_x().field_71462_r, this.human, this.icon));
        }

        public String toString() {
            return "MovingHuman [human=" + this.human + ", sizeX=" + this.sizeX + ", sizeY=" + this.sizeY + ", pos=" + this.pos + ", motion=" + this.motion + ", speed=" + this.speed + ", physics=" + (Object)((Object)this.physics) + ", icon=" + this.icon + "]";
        }
    }
}

