/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excomms.optional;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class NullableOptional<T> {
    private static final NullableOptional EMPTY = new NullableOptional(null);
    private final Optional<T> value;

    public static <T> NullableOptional<T> empty() {
        return EMPTY;
    }

    public static <T> NullableOptional<T> of(@Nullable T t) {
        return new NullableOptional<T>(Optional.ofNullable(t));
    }

    public static <T> NullableOptional<T> ofNull() {
        return NullableOptional.of(null);
    }

    public static <T> NullableOptional<T> ofNullable(@Nullable Optional<T> t) {
        return t != null ? NullableOptional.of(t.orElse(null)) : NullableOptional.empty();
    }

    private NullableOptional(@Nullable Optional<T> value) {
        this.value = value;
    }

    @Nullable
    public T get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value.orElse(null);
    }

    @Nonnull
    public Optional<T> getOpt() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public void ifPresent(@Nonnull Consumer<? super T> consumer) {
        if (this.value != null) {
            consumer.accept(this.get());
        }
    }

    public void ifPresentOpt(@Nonnull Consumer<Optional<? super T>> consumer) {
        if (this.value != null) {
            consumer.accept(this.getOpt());
        }
    }

    @Nonnull
    public NullableOptional<T> filter(@Nonnull Predicate<? super T> predicate) {
        return this.isPresent() && predicate.test(this.get()) ? this : NullableOptional.empty();
    }

    @Nonnull
    public NullableOptional<T> filterOpt(@Nonnull Predicate<Optional<? super T>> predicate) {
        return this.isPresent() && predicate.test(this.getOpt()) ? this : NullableOptional.empty();
    }

    @Nonnull
    public <U> NullableOptional<U> map(@Nonnull Function<? super T, Optional<U>> mapper) {
        if (!this.isPresent()) {
            return NullableOptional.empty();
        }
        return NullableOptional.ofNullable(mapper.apply(this.get()));
    }

    @Nonnull
    public <U> NullableOptional<U> flatMap(@Nonnull Function<? super T, NullableOptional<U>> mapper) {
        if (!this.isPresent()) {
            return NullableOptional.empty();
        }
        return Objects.requireNonNull(mapper.apply(this.get()));
    }

    @Nullable
    public T orElse(@Nullable T other) {
        return this.value != null ? this.get() : other;
    }

    @Nonnull
    public Optional<T> orElseOpt(@Nonnull Optional<T> other) {
        return this.value != null ? this.getOpt() : other;
    }

    @Nullable
    public T orElseGet(@Nonnull Supplier<? extends T> other) {
        return this.value != null ? this.get() : other.get();
    }

    @Nonnull
    public Optional<T> orElseGetOpt(@Nonnull Supplier<Optional<? extends T>> other) {
        return this.value != null ? this.getOpt() : other.get();
    }

    @Nullable
    public <X extends Throwable> T orElseThrow(@Nonnull Supplier<? extends X> exceptionSupplier) throws X {
        if (this.value != null) {
            return this.get();
        }
        throw (Throwable)exceptionSupplier.get();
    }

    @Nonnull
    public <X extends Throwable> Optional<T> orElseThrowOpt(@Nonnull Supplier<? extends X> exceptionSupplier) throws X {
        if (this.value != null) {
            return this.getOpt();
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof NullableOptional)) {
            return false;
        }
        NullableOptional that = (NullableOptional)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value != null ? String.format("NullableOptional[%s]", this.get()) : "NullableOptional.empty";
    }
}

