/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.acintegration.integrations.minetweaker;

import com.shinoow.abyssalcraft.api.ritual.RitualRegistry;
import com.shinoow.abyssalcraft.lib.util.RitualUtil;
import com.shinoow.acintegration.integrations.minetweaker.ACMT;
import com.shinoow.acintegration.integrations.minetweaker.ACMTMisc;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.abyssalcraft.Rituals")
public class Rituals {
    @ZenMethod
    public static void mapDimensionToBookType(int dim, int bookType) {
        if (bookType <= 4 && bookType >= 0 && dim != -1 && dim != 1) {
            ACMTMisc.TASKS.add(new AddBookType(dim, bookType));
        }
    }

    @ZenMethod
    public static void mapDimensionToName(int dim, String name) {
        if (dim != -1 && dim != 1) {
            ACMTMisc.TASKS.add(new AddName(dim, name));
        }
    }

    @ZenMethod
    public static void mapDimensionToBookTypeAndName(int dim, int bookType, String name) {
        Rituals.mapDimensionToBookType(dim, bookType);
        Rituals.mapDimensionToName(dim, name);
    }

    @ZenMethod
    public static void modifyRitualBookType(String name, int bookType) {
        ACMTMisc.TASKS.add(new ModifyRitual(name, 0, bookType));
    }

    @ZenMethod
    public static void modifyRitualDimension(String name, int dimension) {
        ACMTMisc.TASKS.add(new ModifyRitual(name, 1, dimension));
    }

    @ZenMethod
    public static void modifyRitualSacrificeRequirement(String name, boolean requiresSacrifice) {
        ACMTMisc.TASKS.add(new ModifyRitual(name, 2, requiresSacrifice));
    }

    @ZenMethod
    public static void modifyRitualEnergyRequirement(String name, float requiredEnergy) {
        ACMTMisc.TASKS.add(new ModifyRitual(name, 3, Float.valueOf(requiredEnergy)));
    }

    @ZenMethod
    public static void modifyRitualSacrifice(String name, IIngredient sacrifice) {
        ACMTMisc.TASKS.add(new ModifyRitual(name, 4, ACMT.toObject(sacrifice)));
    }

    @ZenMethod
    public static void modifyRitualNbtSensitivity(String name, boolean nbtSensitive) {
        ACMTMisc.TASKS.add(new ModifyRitual(name, 5, nbtSensitive));
    }

    @ZenMethod
    public static void modifyRitualNbtSensitivitySacrifice(String name, boolean nbtSensitiveSacrifice) {
        ACMTMisc.TASKS.add(new ModifyRitual(name, 6, nbtSensitiveSacrifice));
    }

    @ZenMethod
    public static void modifyRitualOfferings(String name, IIngredient[] offerings) {
        ACMTMisc.TASKS.add(new ModifyRitual(name, 7, ACMT.toObjects(offerings)));
    }

    @ZenMethod
    public static void modifyRitualReplaceOffering(String name, IIngredient original, IIngredient replace, boolean nbt) {
        ACMTMisc.TASKS.add(new ModifyRitual(name, 8, new Object[]{ACMT.toObject(original), ACMT.toObject(replace), nbt}));
    }

    private static class ModifyRitual
    implements IAction {
        private int type;
        private Object param;
        private String name;

        public ModifyRitual(String name, int type, Object param) {
            this.name = name;
            this.type = type;
            this.param = param;
        }

        public void apply() {
            switch (this.type) {
                case 0: {
                    RitualUtil.modifyRitualBookType((String)this.name, (int)((Integer)this.param));
                    break;
                }
                case 1: {
                    RitualUtil.modifyRitualDimension((String)this.name, (int)((Integer)this.param));
                    break;
                }
                case 2: {
                    RitualUtil.modifyRitualSacrificeRequirement((String)this.name, (boolean)((Boolean)this.param));
                    break;
                }
                case 3: {
                    RitualUtil.modifyRitualEnergyRequirement((String)this.name, (float)((Float)this.param).floatValue());
                    break;
                }
                case 4: {
                    RitualUtil.modifyRitualSacrifice((String)this.name, (Object)this.param);
                    break;
                }
                case 5: {
                    RitualUtil.modifyRitualNbtSensitivity((String)this.name, (boolean)((Boolean)this.param));
                    break;
                }
                case 6: {
                    RitualUtil.modifyRitualNbtSensitivitySacrifice((String)this.name, (boolean)((Boolean)this.param));
                    break;
                }
                case 7: {
                    RitualUtil.modifyRitualOfferings((String)this.name, (Object[])((Object[])this.param));
                    break;
                }
                case 8: {
                    RitualUtil.modifyRitualReplaceOffering((String)this.name, (Object)((Object[])this.param)[0], (Object)((Object[])this.param)[1], (boolean)((Boolean)((Object[])this.param)[2]));
                }
            }
        }

        private String getProperty(int i) {
            switch (i) {
                case 0: {
                    return "Book Type";
                }
                case 1: {
                    return "Dimension";
                }
                case 2: {
                    return "Sacrifice requirement";
                }
                case 3: {
                    return "Required Energy";
                }
                case 4: {
                    return "Altar Sacrifice";
                }
                case 5: {
                    return "NBT sensitive offerings";
                }
                case 6: {
                    return "NBT sensitive altar sacrifice";
                }
                case 7: {
                    return "Offerings";
                }
            }
            return "Unknown";
        }

        public String describe() {
            if (this.type == 8) {
                return String.format("Replacing offering %s in ritual %s with %s (NBT sensitivity: %s)", ((Object[])this.param)[0], this.name, ((Object[])this.param)[1], ((Object[])this.param)[2]);
            }
            return String.format("Modifying property %s of ritual %s with value %s", this.getProperty(this.type), this.name, this.param);
        }
    }

    private static class AddName
    implements IAction {
        private int dim;
        private String name;

        public AddName(int dim, String name) {
            this.dim = dim;
            this.name = name;
        }

        public void apply() {
            RitualRegistry.instance().addDimensionToName(this.dim, this.name);
        }

        public String describe() {
            return String.format("Mapped dimension ID %d to the name %s", this.dim, this.name);
        }
    }

    private static class AddBookType
    implements IAction {
        private int dim;
        private int bookType;

        public AddBookType(int dim, int bookType) {
            this.dim = dim;
            this.bookType = bookType;
        }

        public void apply() {
            RitualRegistry.instance().addDimensionToBookType(this.dim, this.bookType);
        }

        public String describe() {
            return String.format("Mapped dimension ID %d to Book Type %d", this.dim, this.bookType);
        }
    }
}

