/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.crop;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.core.block.state.Ic2BlockState;
import ic2.core.crop.IC2Crops;
import ic2.core.crop.TileEntityCrop;
import ic2.core.model.AbstractModel;
import ic2.core.model.BasicBakedBlockModel;
import ic2.core.model.VdUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CropModel
extends AbstractModel {
    private static final ResourceLocation STICK = new ResourceLocation("ic2", "blocks/crop/stick2");
    private static final Function<ResourceLocation, TextureAtlasSprite> MISSING = loc -> Minecraft.func_71410_x().func_147117_R().func_174944_f();
    static Map<ResourceLocation, TextureAtlasSprite> textures = new HashMap<ResourceLocation, TextureAtlasSprite>();
    private final LoadingCache<TileEntityCrop.CropRenderState, IBakedModel> modelCache = CacheBuilder.newBuilder().maximumSize(256L).expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<TileEntityCrop.CropRenderState, IBakedModel>(){

        public IBakedModel load(TileEntityCrop.CropRenderState key) throws Exception {
            if (key.crop == null || key.size <= 0) {
                return CropModel.this.generateStickModel(key.crosscrop);
            }
            return CropModel.this.generateModel(key);
        }
    });

    @Override
    public Collection<ResourceLocation> getTextures() {
        if (textures.isEmpty()) {
            IC2Crops.needsToPost = false;
            MinecraftForge.EVENT_BUS.post((Event)new Crops.CropRegisterEvent());
            for (CropCard crop : Crops.instance.getCrops()) {
                for (ResourceLocation aux : crop.getTexturesLocation()) {
                    textures.put(aux, null);
                }
            }
            textures.put(STICK, null);
        }
        return textures.keySet();
    }

    @Override
    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        for (Map.Entry<ResourceLocation, TextureAtlasSprite> entry : textures.entrySet()) {
            entry.setValue(bakedTextureGetter.apply(entry.getKey()));
        }
        return this;
    }

    private static ResourceLocation getTextureLocation(CropCard crop, int currentSize) {
        return crop.getTexturesLocation().get(currentSize - 1);
    }

    @Override
    public List<BakedQuad> func_188616_a(IBlockState rawState, EnumFacing side, long rand) {
        Ic2BlockState.Ic2BlockStateInstance state;
        TileEntityCrop.CropRenderState prop = rawState instanceof Ic2BlockState.Ic2BlockStateInstance && (state = (Ic2BlockState.Ic2BlockStateInstance)rawState).hasValue(TileEntityCrop.renderStateProperty) ? state.getValue(TileEntityCrop.renderStateProperty) : new TileEntityCrop.CropRenderState(null, 0, false);
        try {
            return ((IBakedModel)this.modelCache.get((Object)prop)).func_188616_a(rawState, side, rand);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    IBakedModel generateModel(TileEntityCrop.CropRenderState prop) {
        List[] faceQuads = new List[EnumFacing.field_82609_l.length];
        for (int i = 0; i < faceQuads.length; ++i) {
            faceQuads[i] = new ArrayList();
        }
        List<Object> generalQuads = new ArrayList<BakedQuad>();
        TextureAtlasSprite sprite_stick = textures.get(STICK);
        TextureAtlasSprite sprite_crop = textures.computeIfAbsent(CropModel.getTextureLocation(prop.crop, prop.size), MISSING);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            VdUtil.addCuboid(0.2f, 0.0f, 0.2f, 0.25f, 0.85f, 0.25f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            VdUtil.addCuboid(0.75f, 0.0f, 0.2f, 0.8f, 0.85f, 0.25f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            VdUtil.addCuboid(0.2f, 0.0f, 0.75f, 0.25f, 0.85f, 0.8f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            VdUtil.addCuboid(0.75f, 0.0f, 0.75f, 0.8f, 0.85f, 0.8f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            if (prop.crosscrop) {
                VdUtil.addCuboid(0.05f, 0.65f, 0.2f, 0.95f, 0.7f, 0.25f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
                VdUtil.addCuboid(0.2f, 0.65f, 0.05f, 0.25f, 0.7f, 0.95f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
                VdUtil.addCuboid(0.05f, 0.65f, 0.75f, 0.95f, 0.7f, 0.8f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
                VdUtil.addCuboid(0.75f, 0.65f, 0.05f, 0.8f, 0.7f, 0.95f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            }
            if (prop.crop == null) continue;
            VdUtil.addFlippedCuboid(0.0f, 0.0f, 0.225f, 1.0f, 1.0f, 0.225f, EnumSet.of(facing), sprite_crop, faceQuads, generalQuads);
            VdUtil.addFlippedCuboid(0.225f, 0.0f, 0.0f, 0.225f, 1.0f, 1.0f, EnumSet.of(facing), sprite_crop, faceQuads, generalQuads);
            VdUtil.addFlippedCuboid(0.0f, 0.0f, 0.775f, 1.0f, 1.0f, 0.775f, EnumSet.of(facing), sprite_crop, faceQuads, generalQuads);
            VdUtil.addFlippedCuboid(0.775f, 0.0f, 0.0f, 0.775f, 1.0f, 1.0f, EnumSet.of(facing), sprite_crop, faceQuads, generalQuads);
        }
        int used = 0;
        for (int i = 0; i < faceQuads.length; ++i) {
            if (faceQuads[i].isEmpty()) {
                faceQuads[i] = Collections.emptyList();
                continue;
            }
            ++used;
        }
        if (used == 0) {
            faceQuads = null;
        }
        if (generalQuads.isEmpty()) {
            generalQuads = Collections.emptyList();
        }
        return new BasicBakedBlockModel(faceQuads, generalQuads, sprite_stick);
    }

    IBakedModel generateStickModel(boolean crosscrop) {
        List[] faceQuads = new List[EnumFacing.field_82609_l.length];
        for (int i = 0; i < faceQuads.length; ++i) {
            faceQuads[i] = new ArrayList();
        }
        List<Object> generalQuads = new ArrayList<BakedQuad>();
        TextureAtlasSprite sprite_stick = textures.get(STICK);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            VdUtil.addCuboid(0.2f, 0.0f, 0.2f, 0.25f, 0.85f, 0.25f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            VdUtil.addCuboid(0.75f, 0.0f, 0.2f, 0.8f, 0.85f, 0.25f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            VdUtil.addCuboid(0.2f, 0.0f, 0.75f, 0.25f, 0.85f, 0.8f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            VdUtil.addCuboid(0.75f, 0.0f, 0.75f, 0.8f, 0.85f, 0.8f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            if (!crosscrop) continue;
            VdUtil.addCuboid(0.05f, 0.65f, 0.2f, 0.95f, 0.7f, 0.25f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            VdUtil.addCuboid(0.2f, 0.65f, 0.05f, 0.25f, 0.7f, 0.95f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            VdUtil.addCuboid(0.05f, 0.65f, 0.75f, 0.95f, 0.7f, 0.8f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            VdUtil.addCuboid(0.75f, 0.65f, 0.05f, 0.8f, 0.7f, 0.95f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
        }
        int used = 0;
        for (int i = 0; i < faceQuads.length; ++i) {
            if (faceQuads[i].isEmpty()) {
                faceQuads[i] = Collections.emptyList();
                continue;
            }
            ++used;
        }
        if (used == 0) {
            faceQuads = null;
        }
        if (generalQuads.isEmpty()) {
            generalQuads = Collections.emptyList();
        }
        return new BasicBakedBlockModel(faceQuads, generalQuads, sprite_stick);
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return textures.get(STICK);
    }

    @Override
    public void onReload() {
        this.modelCache.invalidateAll();
    }
}

