/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;
import reborncore.common.util.ItemUtils;

public class FluidUtils {
    public static boolean fluidEquals(Fluid f1, Fluid f2) {
        if (f1.equals(f2)) {
            return true;
        }
        String s1 = f1.getName();
        String s2 = f2.getName();
        if (s1.startsWith("fluid")) {
            s1 = s1.replaceFirst("fluid", "");
        }
        if (s2.startsWith("fluid")) {
            s2 = s2.replaceFirst("fluid", "");
        }
        return s1.equals(s2);
    }

    public static boolean fillContainers(IFluidHandler source, IInventory inventory, int inputSlot, int outputSlot, Fluid fluidToFill) {
        ItemStack inputStack = inventory.func_70301_a(inputSlot);
        ItemStack outputStack = inventory.func_70301_a(outputSlot);
        if (inputStack.func_190926_b()) {
            return false;
        }
        if (outputStack.func_190916_E() >= outputStack.func_77976_d()) {
            return false;
        }
        ItemStack copy = inputStack.func_77946_l();
        copy.func_190920_e(1);
        IFluidHandlerItem target = FluidUtils.getFluidHandler(copy);
        if (target == null) {
            return false;
        }
        int targetCapacity = target.getTankProperties()[0].getCapacity();
        FluidStack simulated = FluidUtil.tryFluidTransfer((IFluidHandler)target, (IFluidHandler)source, (int)targetCapacity, (boolean)false);
        if (simulated == null) {
            return false;
        }
        if (!outputStack.func_190926_b() && !ItemUtils.isItemEqual(FluidUtils.getFilledContainer(fluidToFill, inputStack.func_77946_l()), outputStack, true, true)) {
            return false;
        }
        FluidUtil.tryFluidTransfer((IFluidHandler)target, (IFluidHandler)source, (int)targetCapacity, (boolean)true);
        inventory.func_70299_a(inputSlot, ItemUtils.decreaseSize(inputStack));
        if (outputStack.func_190926_b()) {
            inventory.func_70299_a(outputSlot, target.getContainer());
        } else {
            ItemUtils.increaseSize(outputStack);
        }
        return true;
    }

    public static boolean drainContainers(IFluidHandler target, IInventory inventory, int inputSlot, int outputSlot) {
        ItemStack inputStack = inventory.func_70301_a(inputSlot);
        ItemStack outputStack = inventory.func_70301_a(outputSlot);
        if (inputStack.func_190926_b()) {
            return false;
        }
        if (outputStack.func_190916_E() >= outputStack.func_77976_d()) {
            return false;
        }
        ItemStack copy = inputStack.func_77946_l();
        copy.func_190920_e(1);
        IFluidHandlerItem source = FluidUtils.getFluidHandler(copy);
        if (source == null) {
            return false;
        }
        int sourceCapacity = source.getTankProperties()[0].getCapacity();
        FluidStack simulated = FluidUtil.tryFluidTransfer((IFluidHandler)target, (IFluidHandler)source, (int)sourceCapacity, (boolean)false);
        if (simulated == null) {
            return false;
        }
        if (!outputStack.func_190926_b() && !ItemUtils.isItemEqual(FluidUtils.getEmptyContainer(inputStack.func_77946_l()), outputStack, true, true)) {
            return false;
        }
        FluidUtil.tryFluidTransfer((IFluidHandler)target, (IFluidHandler)source, (int)sourceCapacity, (boolean)true);
        inventory.func_70299_a(inputSlot, ItemUtils.decreaseSize(inputStack));
        if (outputStack.func_190926_b()) {
            inventory.func_70299_a(outputSlot, source.getContainer());
        } else {
            ItemUtils.increaseSize(outputStack);
        }
        return true;
    }

    @Nonnull
    public static ItemStack getEmptyContainer(ItemStack filled) {
        if (filled.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)filled);
        if (fluidHandler != null) {
            fluidHandler.drain(fluidHandler.getTankProperties()[0].getCapacity(), true);
        }
        return filled;
    }

    @Nonnull
    public static ItemStack getFilledContainer(Fluid fluid, ItemStack empty) {
        if (fluid == null || empty.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)empty);
        fluidHandler.fill(new FluidStack(fluid, fluidHandler.getTankProperties()[0].getCapacity()), true);
        return empty;
    }

    @Nullable
    public static IFluidHandlerItem getFluidHandler(@Nonnull ItemStack stack) {
        return stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) ? (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) : null;
    }

    @Deprecated
    @Nullable
    public static FluidStack getFluidStackInContainer(@Nonnull ItemStack container) {
        if (!container.func_190926_b()) {
            container = container.func_77946_l();
            container.func_190920_e(1);
            IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)container);
            if (fluidHandler != null) {
                return fluidHandler.drain(1000, false);
            }
        }
        return null;
    }

    @Nullable
    public static FluidStack getFluidContained(@Nonnull ItemStack container) {
        IFluidHandlerItem fluidHandler;
        if (!container.func_190926_b() && (fluidHandler = FluidUtils.getFluidHandler(container = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1))) != null) {
            return fluidHandler.drain(Integer.MAX_VALUE, false);
        }
        return null;
    }
}

