/*
 * Decompiled with CFR 0.152.
 */
package com.corwinjv.mobtotems.blocks;

import com.corwinjv.mobtotems.blocks.ModBlock;
import com.corwinjv.mobtotems.blocks.tiles.IncenseKindlingBoxTileEntity;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class IncenseKindlingBox
extends ModBlock
implements ITileEntityProvider {
    private static final AxisAlignedBB boundingBox = new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 0.5, 0.8);

    public IncenseKindlingBox() {
        this.func_149711_c(2.0f);
        this.field_149758_A = true;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return boundingBox;
    }

    public boolean isVisuallyOpaque() {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    private boolean canPlaceOn(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        return (state.func_177230_c().func_181623_g() || state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)worldIn, pos)) && state.func_177230_c().func_149730_j(state);
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_176196_c(World worldIn, @Nonnull BlockPos pos) {
        return this.canPlaceAt(worldIn, pos, EnumFacing.UP);
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        return this.canPlaceOn(worldIn, blockpos);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.checkForDrop(worldIn, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos p_189540_5_) {
        this.checkForDrop(worldIn, pos, state);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
    }

    private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (this.canPlaceAt(worldIn, pos, EnumFacing.UP)) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }

    @Nonnull
    public TileEntity func_149915_a(@Nullable World worldIn, int meta) {
        return new IncenseKindlingBoxTileEntity();
    }

    public int func_149745_a(Random random) {
        return 0;
    }
}

