/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.materials;

import epicsquid.mysticallib.block.BlockBase;
import epicsquid.mysticallib.block.BlockOreBase;
import epicsquid.mysticallib.event.RegisterContentEvent;
import epicsquid.mysticallib.item.ItemBase;
import epicsquid.mysticallib.material.MaterialTypes;
import epicsquid.mysticalworld.MysticalWorld;
import epicsquid.mysticalworld.config.ConfigManager;
import epicsquid.mysticalworld.materials.IMetal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraftforge.oredict.OreDictionary;

public enum Metal implements IMetal
{
    copper("Copper", 3.5f, 0.65f, 2, -1, -1, MaterialTypes.material((String)"mysticalworld:copper"), true),
    silver("Silver", 5.0f, 0.35f, 2, -1, -1, MaterialTypes.material((String)"mysticalworld:silver"), true);

    private Item ingot;
    private Item nugget;
    private Item dust;
    private Item dustTiny;
    private Block block;
    private Block ore;
    private final float hardness;
    private final String oredictNameSuffix;
    private final boolean isEmbers;
    private final float experience;
    private final int level;
    private final int minXP;
    private final int maxXP;
    private final Item.ToolMaterial material;
    private boolean hasTool;

    private Metal(String oredictNameSuffix, float hardness, float experience, int level, int minXP, int maxXP, Item.ToolMaterial material, boolean hasTool) {
        this.oredictNameSuffix = oredictNameSuffix;
        this.hardness = hardness;
        this.isEmbers = false;
        this.experience = experience;
        this.level = level;
        this.minXP = minXP;
        this.maxXP = maxXP;
        this.material = material;
        this.hasTool = hasTool;
    }

    @Override
    public boolean hasTool() {
        return this.hasTool;
    }

    @Override
    public Item.ToolMaterial getMaterial() {
        return this.material;
    }

    @Override
    public float getHardness() {
        return this.hardness;
    }

    @Override
    public float getExperience() {
        return this.experience;
    }

    @Override
    @Nonnull
    public String getOredictNameSuffix() {
        return this.oredictNameSuffix;
    }

    @Override
    @Nullable
    public Item getIngot() {
        return this.ingot;
    }

    @Override
    @Nonnull
    public Item setIngot(@Nonnull Item item) {
        this.ingot = item;
        return this.ingot;
    }

    @Override
    @Nullable
    public Item getDust() {
        return this.dust;
    }

    @Override
    @Nonnull
    public Item setDust(@Nonnull Item dust) {
        this.dust = dust;
        return this.dust;
    }

    @Override
    @Nullable
    public Item getDustTiny() {
        return this.dustTiny;
    }

    @Override
    @Nonnull
    public Item setDustTiny(@Nonnull Item dustTiny) {
        this.dustTiny = dustTiny;
        return this.dustTiny;
    }

    @Override
    @Nullable
    public Block getBlock() {
        return this.block;
    }

    @Override
    @Nonnull
    public Block setBlock(@Nonnull Block block) {
        this.block = block;
        block.setHarvestLevel("pickaxe", this.getLevel());
        return this.block;
    }

    @Override
    @Nullable
    public Item getNugget() {
        return this.nugget;
    }

    @Override
    @Nonnull
    public Item setNugget(@Nonnull Item nugget) {
        this.nugget = nugget;
        return this.nugget;
    }

    @Override
    @Nullable
    public Block getOre() {
        return this.ore;
    }

    @Override
    @Nonnull
    public Block setOre(@Nonnull Block ore) {
        this.ore = ore;
        return this.ore;
    }

    @Override
    public boolean isEnabled() {
        if (this.isEmbers) {
            try {
                return ConfigManager.modules.embersModuleEnabled && ConfigManager.metals.getClass().getField("enable" + this.getOredictNameSuffix()).getBoolean(ConfigManager.metals);
            }
            catch (Exception e) {
                System.out.println("Error: Cannot find the specified metal in configs. Are you sure you added it?");
                return ConfigManager.modules.embersModuleEnabled;
            }
        }
        try {
            return ConfigManager.modules.mysticalWorldModuleEnabled && ConfigManager.metals.getClass().getField("enable" + this.getOredictNameSuffix()).getBoolean(ConfigManager.metals);
        }
        catch (Exception e) {
            System.out.println("Error: Cannot find the specified metal in configs. Are you sure you added it?");
            return ConfigManager.modules.mysticalWorldModuleEnabled;
        }
    }

    @Override
    public boolean hasGrindables() {
        return true;
    }

    @Override
    public boolean hasOre() {
        return true;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int getMinXP() {
        return this.minXP;
    }

    @Override
    public int getMaxXP() {
        return this.maxXP;
    }

    public static void registerMetals(@Nonnull RegisterContentEvent event) {
        for (Metal metal : Metal.values()) {
            if (!metal.isEnabled()) continue;
            if (ConfigManager.metals.enableIngots) {
                event.addItem(metal.setIngot(new ItemBase(metal.name() + "_ingot").setModelCustom(true).func_77637_a(MysticalWorld.tab)));
            }
            if (ConfigManager.metals.enableNuggets) {
                event.addItem(metal.setNugget(new ItemBase(metal.name() + "_nugget").setModelCustom(true).func_77637_a(MysticalWorld.tab)));
            }
            if (metal.hasGrindables()) {
                if (ConfigManager.metals.enableDusts) {
                    event.addItem(metal.setDust(new ItemBase(metal.name() + "_dust").setModelCustom(true).func_77637_a(MysticalWorld.tab)));
                }
                if (ConfigManager.metals.enableTinyDusts) {
                    event.addItem(metal.setDustTiny(new ItemBase(metal.name() + "_dust_tiny").setModelCustom(true).func_77637_a(MysticalWorld.tab)));
                }
            }
            if (ConfigManager.metals.enableBlocks) {
                event.addBlock(metal.setBlock(new BlockBase(Material.field_151573_f, SoundType.field_185852_e, metal.getHardness(), metal.name() + "_block").setModelCustom(true).func_149647_a(MysticalWorld.tab)));
            }
            if (!metal.hasOre() || !ConfigManager.metals.enableOres) continue;
            event.addBlock(metal.setOre(new BlockOreBase(Material.field_151576_e, SoundType.field_185851_d, metal.getHardness(), metal.name() + "_ore", null, metal.getLevel(), metal.getMinXP(), metal.getMaxXP()).setModelCustom(true).func_149647_a(MysticalWorld.tab)));
        }
    }

    public static void registerOreDict() {
        for (Metal metal : Metal.values()) {
            if (!metal.isEnabled()) continue;
            if (ConfigManager.metals.enableIngots) {
                OreDictionary.registerOre((String)("ingot" + metal.getOredictNameSuffix()), (Item)metal.getIngot());
            }
            if (ConfigManager.metals.enableNuggets) {
                OreDictionary.registerOre((String)("nugget" + metal.getOredictNameSuffix()), (Item)metal.getNugget());
            }
            if (metal.hasGrindables()) {
                if (ConfigManager.metals.enableDusts) {
                    OreDictionary.registerOre((String)("dust" + metal.getOredictNameSuffix()), (Item)metal.getDust());
                }
                if (ConfigManager.metals.enableTinyDusts) {
                    OreDictionary.registerOre((String)("dustTiny" + metal.getOredictNameSuffix()), (Item)metal.getDustTiny());
                }
            }
            if (ConfigManager.metals.enableBlocks) {
                OreDictionary.registerOre((String)("block" + metal.getOredictNameSuffix()), (Block)metal.getBlock());
            }
            if (!metal.hasOre() || !ConfigManager.metals.enableOres) continue;
            OreDictionary.registerOre((String)("ore" + metal.getOredictNameSuffix()), (Block)metal.getOre());
        }
    }
}

